/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfsync.apogee.ws.structure;

import gouv.education.apogee.commun.client.ws.creationse.CreationSEMetierServiceInterface;
import java.util.List;
import org.ametys.cms.repository.Content;
import org.ametys.odf.course.Course;
import org.ametys.odf.courselist.CourseList;
import org.ametys.odf.program.Container;
import org.ametys.odf.program.Program;
import org.ametys.odf.program.SubProgram;
import org.ametys.plugins.odfsync.apogee.ws.structure.AbstractApogeeStructure;
import org.ametys.plugins.odfsync.export.ExportReport;

public class ApogeeSingleProgramStructure
extends AbstractApogeeStructure {
    @Override
    public void checkProgram(Program program, ExportReport report) {
        this.checkMandatoryDataForContent((Content)program, this.getDIPMandatoryData((Content)program), report);
        this.checkMandatoryDataForContent((Content)program, this.getVDIMandatoryData((Content)program), report);
        this.checkMandatoryDataForOrgunits((Content)program, program.getOrgUnits(), this.getOrgUnitMandatoryDataForDIP(), report);
        List programPartChildren = program.getProgramPartChildren();
        if (!programPartChildren.isEmpty()) {
            report.setStatus(ExportReport.ExportStatus.CONTENT_STRUCTURE_INVALID);
        }
    }

    @Override
    public void checkSubProgram(SubProgram subProgram, ExportReport report) {
        throw new UnsupportedOperationException("No subprogram in this structure");
    }

    @Override
    public void checkContainerAsYear(Container container, ExportReport report, String containerNatureCode) {
        throw new UnsupportedOperationException("No year container in this structure");
    }

    @Override
    public void checkCourseList(CourseList courseList, ExportReport report) {
        throw new UnsupportedOperationException("No course list in this structure");
    }

    @Override
    public void checkCourse(Course course, ExportReport report) {
        throw new UnsupportedOperationException("No course in this structure");
    }

    @Override
    public void createProgram(Program program, ExportReport report) {
        try {
            CreationSEMetierServiceInterface creationService = this._apogeeWS.getCreationService();
            String codDIP = this.getCodeApogee((Content)program);
            Long versionDIP = this.getVersionApogee((Content)program);
            this._apogeeWS.createDIP((Content)program, null, codDIP, creationService);
            this._apogeeWS.createVDI((Content)program, null, codDIP, versionDIP, creationService);
        }
        catch (Exception e) {
            report.setStatus(ExportReport.ExportStatus.ERROR);
            this.getLogger().error("An error occurred exporting the program '{}' ({}) in Apogee", new Object[]{program.getTitle(), program.getId(), e});
        }
    }
}

