<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:cdm="http://cdm-fr.fr/2013/CDM"
    xmlns:cdmfr="http://cdm-fr.fr/2013/CDM-frSchema"
    exclude-result-prefixes="cdm cdmfr">
    
    <xsl:import href="../cdm112/cdmfr2content.xsl"/>
    
    <xsl:include href="program2content.xsl"/>
    <xsl:include href="container2content.xsl"/>
    <xsl:include href="course2content.xsl"/>
    <xsl:include href="orgunit2content.xsl"/>
    
    <xsl:param name="import-root-orgunit-only">false</xsl:param>

    <xsl:template name="program-parse">
        <xsl:call-template name="program-CDMid"/>
        <xsl:call-template name="program-language"/>
        <xsl:call-template name="program-catalog"/>
        <xsl:call-template name="program-certified"/>
        <xsl:call-template name="program-presentation"/>
        <xsl:call-template name="program-objectives"/>
        <xsl:call-template name="program-qualification"/>
        <xsl:call-template name="program-teachingOrganization"/>
        <xsl:call-template name="program-accessCondition"/>
        <xsl:call-template name="program-neededPrerequisite"/>
        <xsl:call-template name="program-recommendedPrerequisite"/>
        <xsl:call-template name="program-furtherStudy"/>
        <xsl:call-template name="program-studyAbroad"/>
        <xsl:call-template name="program-targetGroup"/>
        <xsl:call-template name="program-jobOpportunities"/>
        <xsl:call-template name="program-trainingStrategy"/>
        <xsl:call-template name="program-trainingInfo"/>
        <xsl:call-template name="program-knowledgeCheck"/>
        <xsl:call-template name="program-universalAdjustment"/>
        <xsl:call-template name="program-additionalInformations"/>
        <xsl:call-template name="program-reorientation"/>
        <xsl:call-template name="program-expenses"/>
        <xsl:call-template name="program-domain"/>
        <xsl:call-template name="program-rncpCode"/>
        <xsl:call-template name="program-rncpLevel"/>
        <xsl:call-template name="program-nsfCode"/>
        <xsl:call-template name="program-siseCode"/>
        <xsl:call-template name="program-dgesipCode"/>
        <xsl:call-template name="program-cite97Code"/>
        <xsl:call-template name="program-erasmusCode"/>
        <xsl:call-template name="program-fapCode"/>
        <xsl:call-template name="program-romeCode"/>
        <xsl:call-template name="program-code"/>
        <xsl:call-template name="program-cdmCode"/>
        <xsl:call-template name="program-title"/>
        <xsl:call-template name="program-mention"/>
        <xsl:call-template name="program-speciality"/>
        <xsl:call-template name="program-educationLevel"/>
        <xsl:call-template name="program-degree"/>
        <xsl:call-template name="program-jointOrgUnit"/>
        <xsl:call-template name="program-orgUnit"/>
        <xsl:call-template name="program-place"/>
        <xsl:call-template name="program-contacts"/>
        <xsl:call-template name="program-website"/>
        <xsl:call-template name="program-successRate"/>
        <xsl:call-template name="program-ects"/>
        <xsl:call-template name="program-educationKind"/>
        <xsl:call-template name="program-duration"/>
        <xsl:call-template name="program-educationLanguage"/>
        <xsl:call-template name="program-numberOfStudents"/>
        <xsl:call-template name="program-formofteachingOrg"/>
        <xsl:call-template name="program-distanceLearning"/>
        <xsl:call-template name="program-attachments"/>
        <xsl:call-template name="program-partnerLaboratories"/>
        <xsl:call-template name="program-partnerSchools"/>
        <xsl:call-template name="program-keywords"/>
        <xsl:call-template name="program-structure"/>
        <xsl:call-template name="program-subProgram"/>
        <xsl:call-template name="program-registration"/>
        <xsl:call-template name="program-teachingStart"/>
        <xsl:call-template name="program-teachingEnd"/>
        <xsl:call-template name="program-internshipOpen"/>
        <xsl:call-template name="program-internshipDescription"/>
        <xsl:call-template name="program-educationEntryLevel"/>
        <xsl:call-template name="program-campus"/>
        <xsl:call-template name="program-foreignPlace"/>
        <xsl:call-template name="program-programField"/>
        <xsl:call-template name="program-disciplines"/>
        <xsl:call-template name="program-furtherStudyPrograms"/>
        <xsl:call-template name="program-sectors"/>
        <xsl:call-template name="program-apprenticeshipOpen"/>
        <xsl:call-template name="program-apprenticeshipPeriod"/>
        <xsl:call-template name="program-apprenticeshipModalities"/>
        <xsl:call-template name="program-apprenticeshipContract"/>
        <xsl:call-template name="program-internationalEducation"/>
        <xsl:call-template name="program-internationalDimension"/>
        <xsl:call-template name="program-geocode"/>
        <xsl:call-template name="program-otherPartners"/>
        <xsl:call-template name="program-otherContact"/>
        <xsl:call-template name="program-availableCertification"/>
        <xsl:call-template name="program-inscription"/>
        <xsl:call-template name="program-additionalFields"/>
    </xsl:template>
    
    <xsl:template name="container-parse">
        <xsl:call-template name="container-CDMid"/>
        <xsl:call-template name="container-nature"/>
        <xsl:call-template name="container-period"/>
        <xsl:call-template name="container-teachingOrganization"/>
        <xsl:call-template name="container-code"/>
        <xsl:call-template name="container-title"/>
        <xsl:call-template name="container-ects"/>
        <xsl:call-template name="container-subProgram"/>
        <xsl:call-template name="container-structure"/>
        <xsl:call-template name="container-additionalFields"/>
    </xsl:template>
    
    <xsl:template match="cdm:course">
        <course>
            <xsl:call-template name="course-CDMid"/>
            <xsl:call-template name="course-catalog"/>
            <xsl:call-template name="course-language"/>
            <xsl:call-template name="course-nature"/>
            <xsl:call-template name="course-description"/>
            <xsl:call-template name="course-objectives"/>
            <xsl:call-template name="course-totalDurationOfCM"/>
            <xsl:call-template name="course-totalDurationOfTD"/>
            <xsl:call-template name="course-totalDurationOfTP"/>
            <xsl:call-template name="course-neededPrerequisite"/>
            <xsl:call-template name="course-formOfAssessment"/>
            <xsl:call-template name="course-syllabus"/>
            <xsl:call-template name="course-additionalInformations"/>
            <xsl:call-template name="course-title"/>
            <xsl:call-template name="course-cdmCode"/>
            <xsl:call-template name="course-erasmusCode"/>
            <xsl:call-template name="course-orgUnit"/>
            <xsl:call-template name="course-teachingLocation"/>
            <xsl:call-template name="course-contacts"/>
            <xsl:call-template name="course-ects"/>
            <xsl:call-template name="course-nbHours"/>
            <xsl:call-template name="course-maxNumberOfStudents"/>
            <xsl:call-template name="course-teachingTerm"/>
            <xsl:call-template name="course-timeSlot"/>
            <xsl:call-template name="course-level"/>
            <xsl:call-template name="course-formofteachingMethod"/>
            <xsl:call-template name="course-formofteachingOrg"/>
            <xsl:call-template name="course-teachingActivity"/>
            <xsl:call-template name="course-teachingLanguage"/>
            <xsl:call-template name="course-startDate"/>
            <xsl:call-template name="course-keywords"/>
            <xsl:call-template name="course-webLinkLabel"/>
            <xsl:call-template name="course-webLinkUrl"/>
            <xsl:call-template name="course-coursesReferences"/>
            <xsl:call-template name="course-openToExchangeStudents"/>
            <xsl:call-template name="course-bibliography"/>
            <xsl:call-template name="course-skills"/>
            
            <xsl:call-template name="course-additionalFields"/>
        </course>
    </xsl:template>
    
    <xsl:template match="cdm:orgUnit">
        <orgunit>
            <xsl:call-template name="orgunit-CDMid"/>
            <xsl:call-template name="orgunit-code"/>
            <xsl:call-template name="orgunit-codeUAI"/>
            <xsl:call-template name="orgunit-title"/>
            <xsl:call-template name="orgunit-type"/>
            <xsl:call-template name="orgunit-acronym"/>
            <xsl:call-template name="orgunit-description"/>
            <xsl:call-template name="orgunit-admissionInfo"/>
            <xsl:call-template name="orgunit-regulations"/>
            <xsl:call-template name="orgunit-expenses"/>
            <xsl:call-template name="orgunit-universalAdjustment"/>
            <xsl:call-template name="orgunit-studentFacilities"/>
            <xsl:call-template name="orgunit-additionalInfos"/>
            <xsl:call-template name="orgunit-webLinkLabel"/>
            <xsl:call-template name="orgunit-webLinkUrl"/>
            <xsl:call-template name="orgunit-contactsReferences"/>
            <xsl:call-template name="orgunit-additionalFields"/>
        </orgunit>
    </xsl:template>
    
    <!-- Program : domain, teachingLanguage, ects, duration, contacts, programWebsite, numberOfStudents, formofteachingOrg, erasmusCode, educationEntryLevel, campus, foreignPlace, programField, disciplines, furtherStudyPrograms, sectors, internshipOpen, internshipDescription, apprenticeshipOpen, apprenticeshipPeriod, apprenticeshipContract, internationalEducation, internationalDimension, geocode, otherPartners, availableCertification, inscription -->
    <!-- Container : nature -->
    <!-- Course : courseType, bibliography, skills, openToExchangeStudents, teachingLanguage, ects, nbHours, totalVolumeOf* -->
</xsl:stylesheet>
