<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2012 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:cdm="http://cdm-fr.fr/2012/CDM"
	xmlns:cdmfr="http://cdm-fr.fr/2012/CDM-frSchema"
	exclude-result-prefixes="cdm cdmfr">
	
	<xsl:import href="../cdm11/course2content.xsl"/>
	
	<!-- @Override Identifiant CDM -->
	<xsl:template name="course-CDMid">
		<xsl:attribute name="CDMid"><xsl:value-of select="cdm:courseID"/></xsl:attribute>
	</xsl:template>
	
	<!-- @Override CDM code -->
	<xsl:template name="course-cdmCode">
		<xsl:if test="cdm:courseID">
			<cdmCode><xsl:value-of select="cdm:courseID"/></cdmCode>
		</xsl:if>
	</xsl:template>
	
	<!-- @Override Titre -->
	<xsl:template name="course-title">
		<xsl:if test="cdm:courseName">
			<title><xsl:value-of select="cdm:courseName"/></title>
		</xsl:if>
	</xsl:template>
	
	<!-- @Override Composante -->
	<xsl:template name="course-orgUnit">
		<orgUnit>
			<xsl:for-each select="cdm:contacts/cdm:refOrgUnit">
				<item><xsl:value-of select="@ref"/></item>
			</xsl:for-each>
		</orgUnit>
	</xsl:template>
	
	<!-- @Override Contacts -->
	<xsl:template name="course-contacts">
        <contacts>
            <xsl:if test="cdm:contacts/cdm:refPerson[@role='responsable']">
                <entry name="1">
                    <role>responsible</role>
                    <persons>
                        <xsl:for-each select="cdm:contacts/cdm:refPerson[@role='responsable']">
                            <item><xsl:value-of select="@idRef"/></item>
                        </xsl:for-each>
                    </persons>
                </entry>
            </xsl:if>
            <xsl:if test="cdm:contacts/cdm:refPerson[@role='contact']">
                <xsl:variable name="entryPosition">
                    <xsl:choose>
                        <xsl:when test="cdm:contacts/cdm:refPerson[@role='responsable']">2</xsl:when>
                        <xsl:otherwise>1</xsl:otherwise>
                    </xsl:choose>
                </xsl:variable>
                <entry name="{$entryPosition}">
                    <role>contact</role>
                    <persons>
                        <xsl:for-each select="cdm:contacts/cdm:refPerson[@role='contact']">
                            <item><xsl:value-of select="@idRef"/></item>
                        </xsl:for-each>
                    </persons>
                </entry>
            </xsl:if>
        </contacts>
    </xsl:template>
    
    <xsl:template name="course-totalDurationOfCM">
        <xsl:if test="cdmfr:credits/cdmfr:globalVolume[@teachingtype='CM' and text() > 0]">
            <coursePart>
                <title>CM</title>
                <nature>CM</nature>
                <nbHours><xsl:value-of select="cdmfr:credits/cdmfr:globalVolume[@teachingtype='CM']"/></nbHours>
                <courseHolder><xsl:value-of select="cdm:courseID"/></courseHolder>
            </coursePart>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="course-totalDurationOfTD">
        <xsl:if test="cdmfr:credits/cdmfr:globalVolume[@teachingtype='TD' and text() > 0]">
            <coursePart>
                <title>TD</title>
                <nature>TD</nature>
                <nbHours><xsl:value-of select="cdmfr:credits/cdmfr:globalVolume[@teachingtype='TD']"/></nbHours>
                <courseHolder><xsl:value-of select="cdm:courseID"/></courseHolder>
            </coursePart>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="course-totalDurationOfTP">
        <xsl:if test="cdmfr:credits/cdmfr:globalVolume[@teachingtype='TP' and text() > 0]">
            <coursePart>
                <title>TP</title>
                <nature>TP</nature>
                <nbHours><xsl:value-of select="cdmfr:credits/cdmfr:globalVolume[@teachingtype='TP']"/></nbHours>
                <courseHolder><xsl:value-of select="cdm:courseID"/></courseHolder>
            </coursePart>
        </xsl:if>
    </xsl:template>
</xsl:stylesheet>