<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2012 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:docbook="http://docbook.org/ns/docbook" 
	xmlns:cdm="http://cdm-fr.fr/2011/CDM"
	xmlns:cdmfr="http://cdm-fr.fr/2011/CDM-frSchema"
	xmlns:odf="org.ametys.odf.OdfXSLTHelper"
	exclude-result-prefixes="cdm cdmfr">
	
	<xsl:import href="../program2content.xsl"/>
	
	<!-- +
	     | OVERRIDEN TEMPLATE
	     + -->
	     
	<!-- @Override Program ID-->
	<xsl:template name="program-CDMid">
		<xsl:attribute name="CDMid"><xsl:value-of select="cdm:programID"/></xsl:attribute>
	</xsl:template>
	
	<!-- @Override Code-->
	<xsl:template name="program-code">
		<xsl:if test="@ident">
			<code><xsl:value-of select="@ident"/></code>
		</xsl:if>
	</xsl:template>
	
	<!-- @Override CDM code-->
	<xsl:template name="program-cdmCode">
		<xsl:if test="cdm:programID">
			<cdmCode><xsl:value-of select="cdm:programID"/></cdmCode>
		</xsl:if>
	</xsl:template>
	
	<!-- @Override Composante -->
	<xsl:template name="program-orgUnit">
		<orgUnit>
			<xsl:for-each select="cdm:contacts/cdm:refOrgUnit">
				<item><xsl:value-of select="@ref"/></item>
			</xsl:for-each>
		</orgUnit>
	</xsl:template>
	
	<!-- @Override Contacts -->
    <xsl:template name="program-contacts">
        <contacts>
            <xsl:if test="cdm:contacts/cdm:refPerson[@role='responsable']">
                <entry name="1">
                    <role>responsible</role>
                    <persons>
                        <xsl:for-each select="cdm:contacts/cdm:refPerson[@role='responsable']">
                            <item><xsl:value-of select="@idRef"/></item>
                        </xsl:for-each>
                    </persons>
                </entry>
            </xsl:if>
            <xsl:if test="cdm:contacts/cdm:refPerson[@role='contact']">
                <xsl:variable name="entryPosition">
                    <xsl:choose>
                        <xsl:when test="cdm:contacts/cdm:refPerson[@role='responsable']">2</xsl:when>
                        <xsl:otherwise>1</xsl:otherwise>
                    </xsl:choose>
                </xsl:variable>
                <entry name="{$entryPosition}">
                    <role>contact</role>
                    <persons>
                        <xsl:for-each select="cdm:contacts/cdm:refPerson[@role='contact']">
                            <item><xsl:value-of select="@idRef"/></item>
                        </xsl:for-each>
                    </persons>
                </entry>
            </xsl:if>
        </contacts>
    </xsl:template>
	
	<!-- @Override Nombre d'étudiants -->
	<xsl:template name="program-numberOfStudents">
		<xsl:if test="cdm:admissionInfo/cdm:studentPlaces">
			<numberOfStudents><xsl:value-of select="cdm:admissionInfo/cdm:studentPlaces/@places"/></numberOfStudents>
		</xsl:if>
	</xsl:template>
	
	<!-- @Override Code ROME -->
	<xsl:template name="program-romeCode">
		<xsl:if test="cdm:qualification/cdmfr:profession/cdmfr:romeData">
			<romeCode><xsl:value-of select="cdm:qualification/cdmfr:profession/cdmfr:romeData"/></romeCode>
		</xsl:if>
	</xsl:template>
	
	<!-- @Override Lieux -->
	<xsl:template name="program-place">
		<xsl:if test="cdm:teachingPlace/cdm:adr/cdm:pcode">
			<place>
				<xsl:for-each select="cdm:teachingPlace[cdm:adr/cdm:pcode]">
					<item><xsl:value-of select="cdm:teachingPlace/cdm:adr/cdm:pcode"/></item>
				</xsl:for-each>
			</place>
		</xsl:if>
	</xsl:template>
	
	<!-- @Override Controle des connaissance -->
	<xsl:template name="program-knowledgeCheck">
		<knowledgeCheck>
		<xsl:if test="cdmfr:formOfAssessment/cdm:infoBlock">
				<xsl:apply-templates select="cdmfr:formOfAssessment/cdm:infoBlock[*]" mode="infoblock"/>
		</xsl:if>
		</knowledgeCheck>
	</xsl:template>
	
	<!-- @Override Poursuite d'étude -->
	<xsl:template name="program-furtherStudy">
		<furtherStudy>
			<xsl:if test="cdmfr:aip/cdmfr:possibleFollowUp/*">
				<xsl:apply-templates select="cdmfr:aip/cdmfr:possibleFollowUp[*]" mode="infoblock"/>
			</xsl:if>
		</furtherStudy>
	</xsl:template>
    
    <!-- @Override Savoir-faire et compétences -->
    <xsl:template name="program-qualification">
        <qualification>
            <xsl:if test="cdm:qualification/cdmfr:studyQualification/cdm:infoBlock/*">
                <xsl:apply-templates select="cdm:qualification/cdmfr:studyQualification/cdm:infoBlock[*]" mode="infoblock"/>
            </xsl:if>
        </qualification>
    </xsl:template>
    
    <!-- @Override Organisation de l'enseignement -->
    <xsl:template name="program-formofteachingOrg">
        <xsl:variable name="$lllValue" select="cdmfr:programDescription/cmdfr:lifelongLearning/@lllValue" />
        <xsl:variable name="$lllContext" select="cdmfr:programDescription/cmdfr:lifelongLearning/@lllContext" />
        
        <xsl:variable name="pid" select="cmd:programID" />
        
        <formofteachingOrg>
            <xsl:choose>
                <xsl:when test="$lllValue = 'formation continue'"><item>formCont</item></xsl:when>
                <xsl:when test="$lllValue = 'formation continue en alternance'"><item>formCont</item><item>formAppr</item></xsl:when> 
                <xsl:when test="$lllValue = 'formation professionnelle'"><item>formPro</item></xsl:when> 
                <xsl:when test="$lllContext = 'formCont'"><item>formCont</item></xsl:when>
                <xsl:when test="$lllContext = 'formContAlt'"><item>formCont</item><item>formAppr</item></xsl:when>
                <xsl:when test="$lllContext = 'formProf'"><item>formPro</item></xsl:when>
                <xsl:when test="$lllContext = 'adossProf'"><item>formPro</item></xsl:when>
                <xsl:when test="$lllContext = 'adossRech'"><!-- ODF-919 --></xsl:when>
            </xsl:choose>
        </formofteachingOrg>
    </xsl:template>
    
	<!-- @Override Program structure -->
	<xsl:template name="program-structure">
		<!-- Liste d'UE -->
		<xsl:if test="cdmfr:programStructure/cdmfr:refCourse/@ref">
			<coursesReferences name="Liste">
				<xsl:if test="@ident">
					<xsl:attribute name="code"><xsl:value-of select="concat(@ident, '-CL')" /></xsl:attribute>
				</xsl:if>
				<xsl:for-each select="cdmfr:programStructure/cdmfr:refCourse">
					<item><xsl:value-of select="@ref"/></item>
				</xsl:for-each>
			</coursesReferences>
		</xsl:if>
	</xsl:template>
	
	<!-- @Override Program sub-program -->
	<xsl:template name="program-subProgram">
		<!-- Sous-programme ou conteneur -->
		<xsl:for-each select="cdmfr:programStructure/cdmfr:refProgram/@ref">
			<xsl:variable name="subprogram"><xsl:value-of select="."/></xsl:variable>
			<xsl:apply-templates select="//cdm:program[cdm:programID = $subprogram]" mode="rof-subprogram"/>
		</xsl:for-each>
	</xsl:template>
	
	<!-- Conteneurs -->
	<xsl:template match="cdm:program[cdmfr:programDescription/@nature = 'semestre' or cdmfr:programDescription/@nature = 'année']" mode="rof-subprogram">
		<container>
			<xsl:call-template name="program-parse"/>
		</container>
	</xsl:template>
	
	<!-- Sous-programmes -->
	<xsl:template match="cdm:program" mode="rof-subprogram">
		<subProgram>
			<xsl:attribute name="nature"><xsl:value-of select="cdmfr:programDescription/@nature"/></xsl:attribute>
			<xsl:call-template name="program-parse"/>
		</subProgram>
	</xsl:template>
	
	<!-- Listes d'UE -->
	<xsl:template match="cdm:program[cdmfr:programStructure/cdmfr:refCourse/@ref and not(cdmfr:programStructure/cdmfr:refProgram/@ref) and not(cdmfr:programDescription/@nature = 'semestre')]" mode="rof-subprogram">
		<coursesReferences name="{cdmfr:programName/cdmfr:text}" code="{cdmfr:programCode[@codeSet='userDefined']}">
			<xsl:for-each select="cdmfr:programStructure/cdmfr:refCourse">
				<item><xsl:value-of select="@ref"/></item>
			</xsl:for-each>
		</coursesReferences>
	</xsl:template>
	
	<!-- +
	     | TEMPLATE FOR ROOT PROGRAMS
	     + -->
	     
	<!-- Title -->
	<xsl:template name="root-program-title">
		<xsl:if test="cdmfr:programName/cdmfr:text">
			<xsl:variable name="degree" select="/cdm:CDM/cdm:program[@ident = /cdm:CDM/cdmfr:habilitation/cdmfr:habiliId]/cdm:qualification/cdmfr:degree/@degree"/>
            <title><xsl:value-of select="cdmfr:programName/cdmfr:text"/></title>
			<!-- <title><xsl:value-of select="odf:degreeLabel($degree)"/><xsl:text> </xsl:text><xsl:value-of select="cdmfr:programName/cdmfr:text"/></title> -->
		</xsl:if>
	</xsl:template>
	
	<!-- Degree -->
	<xsl:template name="root-program-degree">
		<xsl:variable name="degree-title" select="/cdm:CDM/cdm:program[@ident = /cdm:CDM/cdmfr:habilitation/cdmfr:habiliId]/cdm:qualification/cdmfr:degree" />
		<xsl:variable name="degree-key">
			<xsl:choose>
				<xsl:when test="$degree-title = 'FORM. ING.'"><xsl:text>FI</xsl:text></xsl:when>
				<xsl:when test="$degree-title = 'LIC LMD'"><xsl:text>XA</xsl:text></xsl:when>
				<xsl:when test="$degree-title = 'LIC PRO'"><xsl:text>DP</xsl:text></xsl:when>
				<xsl:when test="$degree-title = 'MAST LMD'"><xsl:text>XB</xsl:text></xsl:when>
				<xsl:when test="$degree-title = 'MAST ING'"><xsl:text>XC</xsl:text></xsl:when>
				<xsl:when test="$degree-title = 'MASTERE SP'"><xsl:text>7</xsl:text></xsl:when>
				<xsl:when test="$degree-title = 'DOCTORAT'"><xsl:text>YA</xsl:text></xsl:when>
				<xsl:when test="$degree-title = 'DOCT.UNI.G'"><xsl:text>YB</xsl:text></xsl:when>
				<xsl:when test="$degree-title = 'DIP OENOL'"><xsl:text>ZD</xsl:text></xsl:when>
				<xsl:when test="$degree-title = 'D.UNIV. B0'"><xsl:text>UA</xsl:text></xsl:when>
				<xsl:when test="$degree-title = 'D.UNIV. B1'"><xsl:text>UB</xsl:text></xsl:when>
				<xsl:when test="$degree-title = 'D.UNIV. B2'"><xsl:text>UC</xsl:text></xsl:when>
				<xsl:when test="$degree-title = 'D.UNIV. B3'"><xsl:text>UD</xsl:text></xsl:when>
				<xsl:when test="$degree-title = 'D.UNIV. B4'"><xsl:text>UE</xsl:text></xsl:when>
				<xsl:when test="$degree-title = 'D.UNIV. B5'"><xsl:text>UF</xsl:text></xsl:when>
			</xsl:choose>
		</xsl:variable>
			
		<xsl:if test="$degree-key != ''">
			<degree><xsl:value-of select="$degree-key"/></degree>
		</xsl:if>
	</xsl:template>
	
	<!-- Domaine -->
	<xsl:template name="root-program-domain">
        <domain>
            <xsl:for-each select="/cdm:CDM/cdmfr:habilitation/cdmfr:field/@primaryDomainName">
                <item><xsl:value-of select="."/></item>
            </xsl:for-each>
        </domain>
	</xsl:template>
	
	<!-- Mention -->
	<xsl:template name="root-program-mention">
		<xsl:if test="/cdm:CDM/cdm:program[@ident = /cdm:CDM/cdmfr:habilitation/cdmfr:habiliId]/cdmfr:programName/cdmfr:text">
			<xsl:variable name="mention" select="substring-after(/cdm:CDM/cdm:program[@ident = /cdm:CDM/cdmfr:habilitation/cdmfr:habiliId]/cdmfr:programName/cdmfr:text, 'MENTION : ')"/>
			<xsl:variable name="end"><xsl:text> </xsl:text>sous réserve d'habilitation</xsl:variable>
			<xsl:choose>
				<xsl:when test="contains($mention, $end)"><mention><xsl:value-of select="substring-before($mention, $end)"/></mention></xsl:when>
				<xsl:otherwise><mention><xsl:value-of select="$mention"/></mention></xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>
	
	<!-- Composantes -->
	<xsl:template name="root-program-orgUnit">
        <xsl:param name="ME"/>
        <xsl:param name="SP"/>
        
		<orgUnit>
            <xsl:choose>
                <!-- Recherche des composantes dans le programme PR -->
                <xsl:when test="cdm:contacts/cdmfr:refOrgResp[cdmfr:respRole = 'composante de responsabilité pédagogique']/cdmfr:refOrgUnit/@ref">
                    <xsl:call-template name="root-program-orgUnit-items">
                        <xsl:with-param name="program" select="."/>
                    </xsl:call-template>
                </xsl:when>
                <!-- sinon, recherche des composantes dans la spécialité SP (si présente) -->
                <xsl:when test="$SP/cdm:contacts/cdmfr:refOrgResp[cdmfr:respRole = 'composante de responsabilité pédagogique']/cdmfr:refOrgUnit/@ref">
                    <xsl:call-template name="root-program-orgUnit-items">
                        <xsl:with-param name="program" select="$SP"/>
                    </xsl:call-template>
                </xsl:when>
                <!-- sinon, recherche des composantes dans la mention ME (si présente) -->
                <xsl:when test="$ME/cdm:contacts/cdmfr:refOrgResp[cdmfr:respRole = 'composante de responsabilité pédagogique']/cdmfr:refOrgUnit/@ref">
                    <xsl:call-template name="root-program-orgUnit-items">
                        <xsl:with-param name="program" select="$ME"/>
                    </xsl:call-template>
                </xsl:when>
            </xsl:choose>
		</orgUnit>
	</xsl:template>
	
    <xsl:template name="root-program-orgUnit-items">
        <xsl:param name="program"/>
        
        <xsl:for-each select="$program/cdm:contacts/cdmfr:refOrgResp[cdmfr:respRole = 'composante de responsabilité pédagogique']">
            <xsl:if test="cdmfr:refOrgUnit/@ref != ''">
                <item><xsl:value-of select="cdmfr:refOrgUnit/@ref"/></item>
            </xsl:if>
        </xsl:for-each>
    </xsl:template>
    
	<!-- Crédits ECTS -->
	<xsl:template name="root-program-ects">
		<xsl:if test="/cdm:CDM/cdm:program[@ident = /cdm:CDM/cdmfr:habilitation/cdmfr:habiliId]/cdm:qualification/cdmfr:credits/@ECTScredits">
			<ects><xsl:value-of select="/cdm:CDM/cdm:program[@ident = /cdm:CDM/cdmfr:habilitation/cdmfr:habiliId]/cdm:qualification/cdmfr:credits/@ECTScredits"/></ects>
		</xsl:if>
	</xsl:template>
	
	<!-- Présentation -->
	<xsl:template name="root-program-presentation">
		<xsl:param name="ME"/>
		<xsl:param name="SP"/>
		
		<!-- Concaténation de la mention ME (si présente), de la spécialité SP (si présente) et du programme PR-->
		<presentation>
			<xsl:if test="cdmfr:programDescription/cdm:infoBlock/* or $ME/cdmfr:programDescription/cdm:infoBlock/* or $SP/cdmfr:programDescription/cdm:infoBlock/*">
					<article version="5" xmlns="http://docbook.org/ns/docbook">
						<xsl:apply-templates select="$ME/cdmfr:programDescription/cdm:infoBlock[*]" mode="infoblock-without-article"/>
						<xsl:apply-templates select="$SP/cdmfr:programDescription/cdm:infoBlock[*]" mode="infoblock-without-article"/>
						<xsl:apply-templates select="cdmfr:programDescription/cdm:infoBlock[*]" mode="infoblock-without-article"/>
					</article>
			</xsl:if>
		</presentation>
	</xsl:template>
	
	<!-- Objectifs -->
	<xsl:template name="root-program-objectives">
		<xsl:param name="ME"/>
		<xsl:param name="SP"/>
		
		<!-- Concaténation de la mention ME (si présente), de la spécialité SP (si présente) et du programme PR-->
		<objectives>
			<xsl:if test="$ME/cdm:learningObjectives/* or $SP/cdm:learningObjectives/* or cdm:learningObjectives/*">
				<article version="5" xmlns="http://docbook.org/ns/docbook">
					<xsl:apply-templates select="$ME/cdm:learningObjectives[*]" mode="infoblock-without-article"/>
					<xsl:apply-templates select="$SP/cdm:learningObjectives[*]" mode="infoblock-without-article"/>
					<xsl:apply-templates select="cdm:learningObjectives[*]" mode="infoblock-without-article"/>
				</article>
			</xsl:if>
		</objectives>
	</xsl:template>
	
	<!-- Connaissances -->
	<xsl:template name="root-program-qualification">
		<xsl:param name="ME"/>
		<xsl:param name="SP"/>
		
		<!-- Concaténation de la mention ME (si présente), de la spécialité SP (si présente) et du programme PR-->
		<qualification>
			<xsl:if test="$ME/cdm:qualification/cdmfr:studyQualification/cdm:infoBlock/* or $SP/cdm:qualification/cdmfr:studyQualification/cdm:infoBlock/* or cdm:qualification/cdmfr:studyQualification/cdm:infoBlock/*">
				<article version="5" xmlns="http://docbook.org/ns/docbook">
					<xsl:apply-templates select="$ME/cdm:qualification/cdmfr:studyQualification/cdm:infoBlock[*]" mode="infoblock-without-article"/>
					<xsl:apply-templates select="$SP/cdm:qualification/cdmfr:studyQualification/cdm:infoBlock[*]" mode="infoblock-without-article"/>
					<xsl:apply-templates select="cdm:qualification/cdmfr:studyQualification/cdm:infoBlock[*]" mode="infoblock-without-article"/>
				</article>
			</xsl:if>
		</qualification>
	</xsl:template>
	
	<!-- Controle des connaissances -->
	<xsl:template name="root-program-knowledgeCheck">
		<xsl:param name="ME"/>
		<xsl:param name="SP"/>
		
		<!-- Concaténation de la mention ME (si présente), de la spécialité SP (si présente) et du programme PR-->
		<knowledgeCheck>
			<xsl:if test="$ME/cdmfr:formOfAssessment/cdm:infoBlock/* or $SP/cdmfr:formOfAssessment/cdm:infoBlock/* or cdmfr:formOfAssessment/cdm:infoBlock/*">
				<article version="5" xmlns="http://docbook.org/ns/docbook">
					<xsl:apply-templates select="$ME/cdmfr:formOfAssessment/cdm:infoBlock[*]" mode="infoblock-without-article"/>
					<xsl:apply-templates select="$SP/cdmfr:formOfAssessment/cdm:infoBlock[*]" mode="infoblock-without-article"/>
					<xsl:apply-templates select="cdmfr:formOfAssessment/cdm:infoBlock[*]" mode="infoblock-without-article"/>
				</article>
			</xsl:if>
		</knowledgeCheck>
	</xsl:template>
	
	<!-- Organisation des études -->
	<xsl:template name="root-program-teachingOrganization">
		<xsl:param name="ME"/>
		<xsl:param name="SP"/>
		
		<!-- Concaténation de la mention ME (si présente), de la spécialité SP (si présente) et du programme PR-->
		<teachingOrganization>
			<xsl:if test="$ME/cdmfr:programStructure/cdm:infoBlock/* or $SP/cdmfr:programStructure/cdm:infoBlock/* or cdmfr:programStructure/cdm:infoBlock/*">
				<article version="5" xmlns="http://docbook.org/ns/docbook">
					<xsl:apply-templates select="$ME/cdmfr:programStructure/cdm:infoBlock[*]" mode="infoblock-without-article"/>
					<xsl:apply-templates select="$SP/cdmfr:programStructure/cdm:infoBlock[*]" mode="infoblock-without-article"/>
					<xsl:apply-templates select="cdmfr:programStructure/cdm:infoBlock[*]" mode="infoblock-without-article"/>
				</article>
			</xsl:if>
		</teachingOrganization>
	</xsl:template>
	
	<!-- Condition d'accès -->
	<xsl:template name="root-program-accessCondition">
		<xsl:param name="ME"/>
		<xsl:param name="SP"/>
		
		<!-- Concaténation de la mention ME (si présente), de la spécialité SP (si présente) et du programme PR-->
		<accessCondition>
			<xsl:if test="$ME/cdm:admissionInfo/cdmfr:admissionDescription/* or $SP/cdm:admissionInfo/cdmfr:admissionDescription/* or cdm:admissionInfo/cdmfr:admissionDescription/*">
				<article version="5" xmlns="http://docbook.org/ns/docbook">
					<xsl:apply-templates select="$ME/cdm:admissionInfo/cdmfr:admissionDescription[*]" mode="infoblock-without-article"/>
					<xsl:apply-templates select="$SP/cdm:admissionInfo/cdmfr:admissionDescription[*]" mode="infoblock-without-article"/>
					<xsl:apply-templates select="cdm:admissionInfo/cdmfr:admissionDescription[*]" mode="infoblock-without-article"/>
				</article>
			</xsl:if>
		</accessCondition>
	</xsl:template>
	
	<!-- Pré-requis -->
	<xsl:template name="root-program-neededPrerequisite">
		<xsl:param name="ME"/>
		<xsl:param name="SP"/>
		
		<!-- Concaténation de la mention ME (si présente), de la spécialité SP (si présente) et du programme PR-->
		<neededPrerequisite>
			<xsl:if test="$ME/cdm:formalPrerequisites/* or $SP/cdm:formalPrerequisites/* or cdm:formalPrerequisites/*">
				<article version="5" xmlns="http://docbook.org/ns/docbook">
					<xsl:apply-templates select="$ME/cdm:formalPrerequisites[*]" mode="infoblock-without-article"/>
					<xsl:apply-templates select="$SP/cdm:formalPrerequisites[*]" mode="infoblock-without-article"/>
					<xsl:apply-templates select="cdm:formalPrerequisites[*]" mode="infoblock-without-article"/>
				</article>
			</xsl:if>
		</neededPrerequisite>
	</xsl:template>
	
	<!-- Pré-requis recommandés -->
	<xsl:template name="root-program-recommendedPrerequisite">
		<xsl:param name="ME"/>
		<xsl:param name="SP"/>
		
		<!-- Concaténation de la mention ME (si présente), de la spécialité SP (si présente) et du programme PR-->
		<recommendedPrerequisite>
			<xsl:if test="$ME/cdm:recommendedPrerequisites/* or $SP/cdm:recommendedPrerequisites/* or cdm:recommendedPrerequisites/*">
				<article version="5" xmlns="http://docbook.org/ns/docbook">
					<xsl:apply-templates select="$ME/cdm:recommendedPrerequisites[*]" mode="infoblock-without-article"/>
					<xsl:apply-templates select="$SP/cdm:recommendedPrerequisites[*]" mode="infoblock-without-article"/>
					<xsl:apply-templates select="cdm:recommendedPrerequisites[*]" mode="infoblock-without-article"/>
				</article>
			</xsl:if>
		</recommendedPrerequisite>
	</xsl:template>
	
	<!-- Poursuite d'étude -->
	<xsl:template name="root-program-furtherStudy">
		<xsl:param name="ME"/>
		<xsl:param name="SP"/>
		
		<!-- Concaténation de la mention ME (si présente), de la spécialité SP (si présente) et du programme PR-->
		<furtherStudy>
			<xsl:if test="$ME/cdmfr:aip/cdmfr:possibleFollowUp/* or $SP/cdmfr:aip/cdmfr:possibleFollowUp/* or cdmfr:aip/cdmfr:possibleFollowUp/*">
				<article version="5" xmlns="http://docbook.org/ns/docbook">
					<xsl:apply-templates select="$ME/cdmfr:aip/cdmfr:possibleFollowUp[*]" mode="infoblock-without-article"/>
					<xsl:apply-templates select="$SP/cdmfr:aip/cdmfr:possibleFollowUp[*]" mode="infoblock-without-article"/>
					<xsl:apply-templates select="cdmfr:aip/cdmfr:possibleFollowUp[*]" mode="infoblock-without-article"/>
				</article>
			</xsl:if>
		</furtherStudy>
	</xsl:template>
	
	<!-- Etude à l'étranger -->
	<xsl:template name="root-program-studyAbroad">
		<xsl:param name="ME"/>
		<xsl:param name="SP"/>
		
		<!-- Concaténation de la mention ME (si présente), de la spécialité SP (si présente) et du programme PR-->
		<studyAbroad>
			<xsl:if test="$ME/cdm:studyAbroad/* or $SP/cdm:studyAbroad/* or cdm:studyAbroad/*">
				<article version="5" xmlns="http://docbook.org/ns/docbook">
					<xsl:apply-templates select="$ME/cdm:studyAbroad[*]" mode="infoblock-without-article"/>
					<xsl:apply-templates select="$SP/cdm:studyAbroad[*]" mode="infoblock-without-article"/>
					<xsl:apply-templates select="cdm:studyAbroad[*]" mode="infoblock-without-article"/>
				</article>
			</xsl:if>
		</studyAbroad>
	</xsl:template>
	
	<!-- Public cible -->
	<xsl:template name="root-program-targetGroup">
		<xsl:param name="ME"/>
		<xsl:param name="SP"/>
		
		<!-- Concaténation de la mention ME (si présente), de la spécialité SP (si présente) et du programme PR-->
		<targetGroup>
			<xsl:if test="$ME/cdm:targetGroup/* or $SP/cdm:targetGroup/* or cdm:targetGroup/*">
				<article version="5" xmlns="http://docbook.org/ns/docbook">
					<xsl:apply-templates select="$ME/cdm:targetGroup[*]" mode="infoblock-without-article"/>
					<xsl:apply-templates select="$SP/cdm:targetGroup[*]" mode="infoblock-without-article"/>
					<xsl:apply-templates select="cdm:targetGroup[*]" mode="infoblock-without-article"/>
				</article>
			</xsl:if>
		</targetGroup>
	</xsl:template>
	
	<!-- Métiers -->
	<xsl:template name="root-program-jobOpportunities">
		<xsl:param name="ME"/>
		<xsl:param name="SP"/>
		
		<!-- Concaténation de la mention ME (si présente), de la spécialité SP (si présente) et du programme PR-->
		<jobOpportunities>
			<xsl:if test="$ME/cdm:qualification/cdmfr:profession/cdm:infoBlock/* or $SP/cdm:qualification/cdmfr:profession/cdm:infoBlock/* or cdm:qualification/cdmfr:profession/cdm:infoBlock/*">
				<article version="5" xmlns="http://docbook.org/ns/docbook">
					<xsl:apply-templates select="$ME/cdm:qualification/cdmfr:profession/cdm:infoBlock[*]" mode="infoblock-without-article"/>
					<xsl:apply-templates select="$SP/cdm:qualification/cdmfr:profession/cdm:infoBlock[*]" mode="infoblock-without-article"/>
					<xsl:apply-templates select="cdm:qualification/cdmfr:profession/cdm:infoBlock[*]" mode="infoblock-without-article"/>
				</article>
			</xsl:if>
		</jobOpportunities>
	</xsl:template>
	
	<!-- Aménagements -->
	<xsl:template name="root-program-universalAdjustment">
		<xsl:param name="ME"/>
		<xsl:param name="SP"/>
		
		<!-- Concaténation de la mention ME (si présente), de la spécialité SP (si présente) et du programme PR-->
		<universalAdjustment>
			<xsl:if test="$ME/cdm:universalAjustment/* or $SP/cdm:universalAjustment/* or cdm:universalAjustment/*">
				<article version="5" xmlns="http://docbook.org/ns/docbook">
					<xsl:apply-templates select="$ME/cdm:universalAjustment[*]" mode="infoblock-without-article"/>
					<xsl:apply-templates select="$SP/cdm:universalAjustment[*]" mode="infoblock-without-article"/>
					<xsl:apply-templates select="cdm:universalAjustment[*]" mode="infoblock-without-article"/>
				</article>
			</xsl:if>
		</universalAdjustment>
	</xsl:template>
	
	<!-- Informations complémentaires -->
	<xsl:template name="root-program-additionalInformations">
		<xsl:param name="ME"/>
		<xsl:param name="SP"/>
		
		<!-- Concaténation de la mention ME (si présente), de la spécialité SP (si présente) et du programme PR-->
		<additionalInformations>
			<xsl:if test="$ME/cdm:infoBlock[not(@userDefined = 'ametys-extension')]/* or $SP/cdm:infoBlock[not(@userDefined = 'ametys-extension')]/* or cdm:infoBlock[not(@userDefined = 'ametys-extension')]/*">
				<article version="5" xmlns="http://docbook.org/ns/docbook">
					<xsl:apply-templates select="$ME/cdm:infoBlock[not(@userDefined = 'ametys-extension')][*]" mode="infoblock-without-article"/>
					<xsl:apply-templates select="$SP/cdm:infoBlock[not(@userDefined = 'ametys-extension')][*]" mode="infoblock-without-article"/>
					<xsl:apply-templates select="cdm:infoBlock[not(@userDefined = 'ametys-extension')][*]" mode="infoblock-without-article"/>
				</article>
			</xsl:if>
		</additionalInformations>
	</xsl:template>
	
	<!-- Passerelle et ré-orientation -->
	<xsl:template name="root-program-reorientation">
	</xsl:template>
	
	<!-- Couts -->
	<xsl:template name="root-program-expenses">
		<xsl:param name="ME"/>
		<xsl:param name="SP"/>
		
		<!-- Concaténation de la mention ME (si présente), de la spécialité SP (si présente) et du programme PR-->
		<expenses>
			<xsl:if test="$ME/cdm:expenses/* or $SP/cdm:expenses/* or cdm:expenses/*">
				<article version="5" xmlns="http://docbook.org/ns/docbook">
					<xsl:apply-templates select="$ME/cdm:expenses[*]" mode="infoblock-without-article"/>
					<xsl:apply-templates select="$SP/cdm:expenses[*]" mode="infoblock-without-article"/>
					<xsl:apply-templates select="cdm:expenses[*]" mode="infoblock-without-article"/>
				</article>
			</xsl:if>
		</expenses>
	</xsl:template>
    
    <!-- Etablissement partenaires -->
    <xsl:template name="root-program-partnerSchools">
        <xsl:if test="/cdm:CDM/cdmfr:habilitation/cdmfr:partnership[cdmfr:refOrgUnit/@ref or cdmfr:partnerName/cdmfr:text]">
            <partnerSchools>
                <xsl:for-each select="/cdm:CDM/cdmfr:habilitation/cdmfr:partnership[cdmfr:refOrgUnit/@ref or cdmfr:partnerName/cdmfr:text]">
                    <entry name="{position()}">
                        <xsl:variable name="refId" select="cdmfr:refOrgUnit/@ref"/>
                        <xsl:choose>
                            <xsl:when test="cdmfr:partnerName/cdmfr:text">
                                <linkLabel><xsl:value-of select="cdmfr:partnerName/cdmfr:text"/></linkLabel>
                            </xsl:when>
                            <xsl:when test="$refId != ''">
                                <linkLabel><xsl:value-of select="/cdm:CDM/cdm:orgUnit[cdm:orgUnitID = $refId]/cdm:orgUnitName"/></linkLabel>
                            </xsl:when>
                        </xsl:choose>
                        
                        <xsl:if test="$refId != ''">
                             <linkUrl><xsl:value-of select="/cdm:CDM/cdm:orgUnit[cdm:orgUnitID = $refId]/cdmfr:webLink/cdm:href"/></linkUrl>
                        </xsl:if>
                    </entry>
                </xsl:for-each>
            </partnerSchools>
        </xsl:if>
    </xsl:template>
	
	
</xsl:stylesheet>