/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfsync.apogee.ws;

import gouv.education.apogee.commun.client.ws.creationse.CreationSEMetierServiceInterface;
import gouv.education.apogee.commun.client.ws.creationse.CreationSEMetierServiceInterfaceServiceLocator;
import gouv.education.apogee.commun.transverse.dto.offreformation.creerse.CentreInsPedagogiDTO;
import gouv.education.apogee.commun.transverse.dto.offreformation.creerse.CentreInsPedagogiDTO2;
import gouv.education.apogee.commun.transverse.dto.offreformation.creerse.CmpHabiliteeVdiDTO;
import gouv.education.apogee.commun.transverse.dto.offreformation.creerse.ComposanteCGEDTO;
import gouv.education.apogee.commun.transverse.dto.offreformation.creerse.DiplomeDTO;
import gouv.education.apogee.commun.transverse.dto.offreformation.creerse.ElementPedagogiDTO4;
import gouv.education.apogee.commun.transverse.dto.offreformation.creerse.ElementPedagogiDTO6;
import gouv.education.apogee.commun.transverse.dto.offreformation.creerse.EtapeDTO;
import gouv.education.apogee.commun.transverse.dto.offreformation.creerse.LienVetElpLseDTO;
import gouv.education.apogee.commun.transverse.dto.offreformation.creerse.ListeElementPedagogiDTO3;
import gouv.education.apogee.commun.transverse.dto.offreformation.creerse.Nullable2Int;
import gouv.education.apogee.commun.transverse.dto.offreformation.creerse.Nullable3Int;
import gouv.education.apogee.commun.transverse.dto.offreformation.creerse.NullableDecimal;
import gouv.education.apogee.commun.transverse.dto.offreformation.creerse.NullableInt;
import gouv.education.apogee.commun.transverse.dto.offreformation.creerse.RegimeDTO;
import gouv.education.apogee.commun.transverse.dto.offreformation.creerse.VdiFractionnerVetDTO;
import gouv.education.apogee.commun.transverse.dto.offreformation.creerse.VersionDiplomeDTO;
import gouv.education.apogee.commun.transverse.dto.offreformation.creerse.VersionEtapeDTO;
import java.math.BigDecimal;
import java.rmi.RemoteException;
import java.time.LocalDate;
import java.util.List;
import java.util.stream.Stream;
import javax.xml.rpc.ServiceException;
import org.ametys.cms.data.ContentDataHelper;
import org.ametys.cms.data.ContentValue;
import org.ametys.cms.repository.Content;
import org.ametys.core.util.HttpUtils;
import org.ametys.odf.course.Course;
import org.ametys.odf.courselist.CourseList;
import org.ametys.odf.orgunit.OrgUnit;
import org.ametys.odf.program.Container;
import org.ametys.odf.program.SubProgram;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.data.holder.ModelAwareDataHolder;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;

public class ApogeeWS
extends AbstractLogEnabled
implements Serviceable,
Component {
    public static final String ROLE = ApogeeWS.class.getName();
    protected AmetysObjectResolver _resolver;

    public void service(ServiceManager manager) throws org.apache.avalon.framework.service.ServiceException {
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
    }

    public CreationSEMetierServiceInterface getCreationService() throws ServiceException {
        String wsURL = HttpUtils.sanitize((String)((String)Config.getInstance().getValue("apogee.ws.url")));
        CreationSEMetierServiceInterfaceServiceLocator locator = new CreationSEMetierServiceInterfaceServiceLocator();
        locator.setCreationSEMetierEndpointAddress(wsURL);
        return locator.getCreationSEMetier();
    }

    public void createDIP(Content content, String title, String codDip) throws RemoteException, ServiceException {
        this.createDIP(content, title, codDip, this.getCreationService());
    }

    public void createDIP(Content content, String title, String codDip, CreationSEMetierServiceInterface creationSEMetierServiceInterface) throws RemoteException {
        String computedTitle = StringUtils.isNotBlank((CharSequence)title) ? title : content.getTitle();
        DiplomeDTO dip = new DiplomeDTO();
        dip.setCodDip(codDip);
        dip.setLibDip(computedTitle);
        dip.setLicDip(StringUtils.substring((String)computedTitle, (int)0, (int)24));
        String educationKindId = ContentDataHelper.getContentIdFromContentData((ModelAwareDataHolder)content, (String)"educationKind");
        Content educationKindContent = (Content)this._resolver.resolveById(educationKindId);
        dip.setCodNdi((String)educationKindContent.getValue("codeApogee"));
        dip.setCodCycle((String)content.getValue("cycleApogee/codeApogee"));
        String degreeCodeId = ContentDataHelper.getContentIdFromContentData((ModelAwareDataHolder)content, (String)"degree");
        Content degreeContent = (Content)this._resolver.resolveById(degreeCodeId);
        dip.setCodTypDip((String)degreeContent.getValue("codeApogee"));
        creationSEMetierServiceInterface.creerDIP(dip);
    }

    public void createVDI(Content content, String title, String codDip, Long versionDIP) throws RemoteException, ServiceException {
        this.createVDI(content, title, codDip, versionDIP, this.getCreationService());
    }

    public void createVDI(Content content, String title, String codDip, Long versionDIP, CreationSEMetierServiceInterface creationSEMetierServiceInterface) throws RemoteException {
        String computedTitle = StringUtils.isNotBlank((CharSequence)title) ? title : content.getTitle();
        VersionDiplomeDTO vdi = new VersionDiplomeDTO();
        vdi.setCodDip(codDip);
        vdi.setCodVersionDip(new NullableInt(versionDIP.intValue()));
        vdi.setLicVersionDip(StringUtils.substring((String)computedTitle, (int)0, (int)24));
        LocalDate startRecruitmentDate = (LocalDate)content.getValue("start-date-recruitment");
        LocalDate endRecruitmentDate = (LocalDate)content.getValue("end-date-recruitment");
        vdi.setDebutRecrutement(String.valueOf(startRecruitmentDate.getYear()));
        vdi.setFinRecrutement(String.valueOf(endRecruitmentDate.getYear()));
        LocalDate startValidationDate = (LocalDate)content.getValue("start-date-validation");
        LocalDate endValidationDate = (LocalDate)content.getValue("end-date-validation");
        vdi.setDebutValidation(String.valueOf(startValidationDate.getYear()));
        vdi.setFinValidation(String.valueOf(endValidationDate.getYear()));
        CmpHabiliteeVdiDTO[] tabCmpHabiliteeVDIs = (CmpHabiliteeVdiDTO[])ContentDataHelper.getContentIdsListFromMultipleContentData((ModelAwareDataHolder)content, (String)"orgUnit").stream().map(id -> this._getOrgUnitById((String)id)).filter(o -> o != null).map(o -> this._createCmpHabiliteeVdiDTO((OrgUnit)o)).toArray(CmpHabiliteeVdiDTO[]::new);
        vdi.setListComposantesHabilitees(tabCmpHabiliteeVDIs);
        creationSEMetierServiceInterface.creerVDI(vdi);
    }

    public void createETP(Content content, String title, String codETP) throws RemoteException, ServiceException {
        this.createETP(content, title, codETP, this.getCreationService());
    }

    public void createETP(Content content, String title, String codETP, CreationSEMetierServiceInterface creationSEMetierServiceInterface) throws RemoteException {
        String computedTitle = StringUtils.isNotBlank((CharSequence)title) ? title : content.getTitle();
        EtapeDTO etp = new EtapeDTO();
        etp.setCodEtp(codETP);
        etp.setLicEtp(StringUtils.substring((String)computedTitle, (int)0, (int)24));
        etp.setLibEtp(computedTitle);
        etp.setCodCycle((String)content.getValue("cycleApogee/codeApogee"));
        if (content instanceof SubProgram) {
            SubProgram subProgram = (SubProgram)content;
            ComposanteCGEDTO[] tabComp = (ComposanteCGEDTO[])subProgram.getOrgUnits().stream().map(id -> this._getOrgUnitById((String)id)).filter(o -> o != null).map(o -> this._createComposanteCGEDTO((OrgUnit)o)).toArray(ComposanteCGEDTO[]::new);
            etp.setListComposantesCGE(tabComp);
        } else if (content instanceof Container) {
            ContentValue value = (ContentValue)content.getValue("orgUnit");
            ComposanteCGEDTO[] tabComp = new ComposanteCGEDTO[]{this._createComposanteCGEDTO((OrgUnit)value.getContent())};
            etp.setListComposantesCGE(tabComp);
        }
        creationSEMetierServiceInterface.creerETP(etp);
    }

    public void createVET(Content content, String title, String codETP, Long versionETP) throws RemoteException, ServiceException {
        this.createVET(content, title, codETP, versionETP, this.getCreationService());
    }

    public void createVET(Content content, String title, String codETP, Long versionETP, CreationSEMetierServiceInterface creationSEMetierServiceInterface) throws RemoteException {
        String computedTitle = StringUtils.isNotBlank((CharSequence)title) ? title : content.getTitle();
        VersionEtapeDTO vet = new VersionEtapeDTO();
        vet.setCodEtp(codETP);
        vet.setCodVersionEtp(new NullableInt(versionETP.intValue()));
        vet.setLibWeb(computedTitle);
        vet.setCodDureeEtp((String)content.getValue("duration-apogee/codeApogee"));
        if (content instanceof SubProgram) {
            SubProgram subProgram = (SubProgram)content;
            String orgUnitId = (String)subProgram.getOrgUnits().get(0);
            OrgUnit orgUnit = this._getOrgUnitById(orgUnitId);
            vet.setCodComposante((String)orgUnit.getValue("codeApogee"));
        } else if (content instanceof Container) {
            ContentValue value = (ContentValue)content.getValue("orgUnit");
            vet.setCodComposante((String)value.getContent().getValue("codeApogee"));
        }
        String[] inscriptionTypes = (String[])content.getValue("inscription-types/codeApogee", true);
        RegimeDTO[] tabRegimes = (RegimeDTO[])Stream.of(inscriptionTypes).map(it -> this._createRegime((String)it)).toArray(RegimeDTO[]::new);
        vet.setListRegimes(tabRegimes);
        String[] cips = (String[])content.getValue("cips/codeApogee", true);
        CentreInsPedagogiDTO2[] tabCIP = (CentreInsPedagogiDTO2[])Stream.of(cips).map(cip -> this._createCIPVET((String)cip)).toArray(CentreInsPedagogiDTO2[]::new);
        vet.setListCIP(tabCIP);
        creationSEMetierServiceInterface.creerVET(vet);
    }

    public void createLinkDIPETP(String codDIP, Long versionDIP, String codETP, Long versionETP) throws RemoteException, ServiceException {
        this.createLinkDIPETP(codDIP, versionDIP, codETP, versionETP, this.getCreationService());
    }

    public void createLinkDIPETP(String codDIP, Long versionDIP, String codETP, Long versionETP, CreationSEMetierServiceInterface creationSEMetierServiceInterface) throws RemoteException {
        VdiFractionnerVetDTO lien = new VdiFractionnerVetDTO();
        lien.setCodDip(codDIP);
        lien.setCodVersionDip(new Nullable3Int(versionDIP.intValue()));
        lien.setCodEtp(codETP);
        lien.setCodVersionEtp(new Nullable3Int(versionETP.intValue()));
        lien.setAnMinEtpDip(new NullableInt("1"));
        lien.setAnMaxEtpDip(new NullableInt("2"));
        creationSEMetierServiceInterface.creerLienVetVdi(lien);
    }

    public void createLinkETPELPLSE(String codETP, Long versionETP, String codLSE, String codELP, Long nbELP, Double ectsMin, Double ectsMax) throws RemoteException, ServiceException {
        this.createLinkETPELPLSE(codETP, versionETP, codLSE, codELP, nbELP, ectsMin, ectsMax, this.getCreationService());
    }

    public void createLinkETPELPLSE(String codETP, Long versionETP, String codLSE, String codELP, Long nbELP, Double ectsMin, Double ectsMax, CreationSEMetierServiceInterface creationSEMetierServiceInterface) throws RemoteException {
        LienVetElpLseDTO lien = new LienVetElpLseDTO();
        if (StringUtils.isNotBlank((CharSequence)codETP)) {
            lien.setCodEtp(codETP);
        }
        if (versionETP != null) {
            lien.setCodVersionEtp(new Nullable3Int(versionETP.intValue()));
        } else {
            lien.setCodVersionEtp(new Nullable3Int());
        }
        lien.setCodListeElp(codLSE);
        lien.setCodElp(codELP);
        if (nbELP != null) {
            lien.setNbrMinElp(new Nullable2Int(nbELP.intValue()));
            lien.setNbrMaxElp(new Nullable2Int(nbELP.intValue()));
            lien.setNbrMinCredits(new NullableDecimal(new BigDecimal(ectsMin)));
            lien.setNbrMaxCredits(new NullableDecimal(new BigDecimal(ectsMax)));
        }
        creationSEMetierServiceInterface.creerLienVetElpLse(lien);
    }

    public void createLSE(CourseList courseList, String title, String codLSE) throws RemoteException, ServiceException {
        this.createLSE(courseList, title, codLSE, this.getCreationService());
    }

    public void createLSE(CourseList courseList, String title, String codLSE, CreationSEMetierServiceInterface creationSEMetierServiceInterface) throws RemoteException {
        String computedTitle = StringUtils.isNotBlank((CharSequence)title) ? title : courseList.getTitle();
        int i = 0;
        List courses = courseList.getCourses();
        ElementPedagogiDTO4[] tabELP = new ElementPedagogiDTO4[courses.size()];
        for (Course course : courses) {
            tabELP[i] = new ElementPedagogiDTO4((String)course.getValue("codeApogee"));
            ++i;
        }
        ListeElementPedagogiDTO3 lse = new ListeElementPedagogiDTO3();
        lse.setCodListeElp(codLSE);
        String choiceTypeAmetys = (String)courseList.getValue("choiceType");
        String typList = "O";
        if (choiceTypeAmetys.equals("MANDATORY")) {
            typList = "F";
        } else if (choiceTypeAmetys.equals("CHOICE")) {
            typList = "X";
        }
        lse.setTypListeElp(typList);
        lse.setLibCourtListeElp(StringUtils.substring((String)computedTitle, (int)0, (int)24));
        lse.setLibListeElp(computedTitle);
        lse.setListElementPedagogi(tabELP);
        creationSEMetierServiceInterface.creerLSE(lse);
    }

    public void createMandatoryLSE(String titleLSE, String codLSE, String codELP) throws RemoteException, ServiceException {
        this.createMandatoryLSE(titleLSE, codLSE, codELP, this.getCreationService());
    }

    public void createMandatoryLSE(String titleLSE, String codLSE, String codELP, CreationSEMetierServiceInterface creationSEMetierServiceInterface) throws RemoteException {
        ElementPedagogiDTO4[] tabELP = new ElementPedagogiDTO4[]{new ElementPedagogiDTO4(codELP)};
        ListeElementPedagogiDTO3 lse = new ListeElementPedagogiDTO3();
        lse.setCodListeElp(codLSE);
        lse.setTypListeElp("F");
        lse.setLibCourtListeElp(StringUtils.substring((String)titleLSE, (int)0, (int)24));
        lse.setLibListeElp(titleLSE);
        lse.setListElementPedagogi(tabELP);
        creationSEMetierServiceInterface.creerLSE(lse);
    }

    public void createELP(Content content, String title, String codELP) throws RemoteException, ServiceException {
        this.createELP(content, title, codELP, this.getCreationService());
    }

    public void createELP(Content content, String title, String codELP, CreationSEMetierServiceInterface creationSEMetierServiceInterface) throws RemoteException {
        ContentValue value;
        String computedTitle = StringUtils.isNotBlank((CharSequence)title) ? title : content.getTitle();
        ElementPedagogiDTO6 elp = new ElementPedagogiDTO6();
        elp.setCodElp(codELP);
        elp.setLibElp(computedTitle);
        elp.setLibCourtElp(StringUtils.substring((String)computedTitle, (int)0, (int)24));
        if (content instanceof Container) {
            value = (ContentValue)content.getValue("nature");
            elp.setCodNatureElp((String)value.getContent().getValue("codeApogee"));
        } else if (content instanceof Course) {
            value = (ContentValue)content.getValue("courseType");
            elp.setCodNatureElp((String)value.getContent().getValue("codeApogee"));
        }
        if (content instanceof Course) {
            String orgUnitId = (String)((Course)content).getOrgUnits().get(0);
            OrgUnit orgUnit = this._getOrgUnitById(orgUnitId);
            elp.setCodComposante((String)orgUnit.getValue("codeApogee"));
        } else if (content instanceof Container) {
            value = (ContentValue)content.getValue("orgUnit");
            elp.setCodComposante((String)value.getContent().getValue("codeApogee"));
        }
        String[] cips = (String[])content.getValue("cips/codeApogee", true);
        CentreInsPedagogiDTO[] tabCIP = (CentreInsPedagogiDTO[])Stream.of(cips).map(cip -> this._createCIPELP((String)cip)).toArray(CentreInsPedagogiDTO[]::new);
        elp.setListCentreInsPedagogi(tabCIP);
        creationSEMetierServiceInterface.creerELP_v2(elp);
    }

    private OrgUnit _getOrgUnitById(String orgUnitId) {
        try {
            OrgUnit orgUnit = (OrgUnit)this._resolver.resolveById(orgUnitId);
            return orgUnit;
        }
        catch (Exception e) {
            this.getLogger().warn("Can't get orgunit from id " + orgUnitId, (Throwable)e);
            return null;
        }
    }

    private CentreInsPedagogiDTO2 _createCIPVET(String code) {
        CentreInsPedagogiDTO2 cip = new CentreInsPedagogiDTO2();
        cip.setCodCIP(code);
        return cip;
    }

    private CentreInsPedagogiDTO _createCIPELP(String code) {
        return new CentreInsPedagogiDTO(code);
    }

    private RegimeDTO _createRegime(String code) {
        RegimeDTO regime = new RegimeDTO();
        regime.setCodRegime(code);
        return regime;
    }

    private ComposanteCGEDTO _createComposanteCGEDTO(OrgUnit orgUnit) {
        ComposanteCGEDTO comp = new ComposanteCGEDTO();
        comp.setCodComposante((String)orgUnit.getValue("codeApogee"));
        comp.setCodCGE((String)orgUnit.getValue("codeCGE"));
        return comp;
    }

    private CmpHabiliteeVdiDTO _createCmpHabiliteeVdiDTO(OrgUnit orgUnit) {
        CmpHabiliteeVdiDTO comp = new CmpHabiliteeVdiDTO();
        comp.setCodComposanteHabilitee((String)orgUnit.getValue("codeApogee"));
        return comp;
    }
}

