<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns="http://docbook.org/ns/docbook"
	xmlns:cdm="http://cdm-fr.fr/2012/CDM"
	xmlns:ametys-cdm="http://www.ametys.org/cdm/1.0"
    xmlns:html="http://www.w3.org/1999/xhtml"
    xmlns:xhtml="http://www.w3.org/1999/xhtml"
	xmlns:xlink="http://www.w3.org/1999/xlink"
    xmlns:editor="org.ametys.cms.transformation.xslt.InlineEditorHelper"
	exclude-result-prefixes="cdm">
    
    <xsl:output method="xml" indent="yes" />
    
	<xsl:template match="*" mode="infoblock">
    	<article version="5">
    		<xsl:apply-templates select="cdm:p|cdm:bold|cdm:strong|cdm:italic|cdm:em|cdm:subBlock|cdm:list|cdm:br|text()|cdm:webLink|cdm:email|xhtml:table"/>
    	</article>
    </xsl:template>
    
    <xsl:template match="*" mode="infoblock-without-article">
    	<xsl:apply-templates select="cdm:p|cdm:bold|cdm:strong|cdm:italic|cdm:em|cdm:subBlock|cdm:list|cdm:br|text()|cdm:webLink|cdm:email|xhtml:table"/>
    </xsl:template>
    <xsl:template match="cdm:subBlock">
    	<section>
    		<xsl:apply-templates/>
    	</section>
    </xsl:template>
    
    <xsl:template match="cdm:header">
    	<title>
    		<xsl:value-of select="text()"/>
    	</title>
    </xsl:template>
    
    <xsl:template match="cdm:list">
    	<xsl:choose>
    		<xsl:when test="@listType = 'numbered'">
    			<orderedlist>
					<xsl:apply-templates select="cdm:listItem"/>
    			</orderedlist>
    		</xsl:when>
    		<xsl:otherwise>
    			<itemizedlist>
					<xsl:apply-templates select="cdm:listItem"/>
				</itemizedlist>
    		</xsl:otherwise>
    	</xsl:choose>
    </xsl:template>
    
    <xsl:template match="cdm:listItem">
        <listitem>
            <para>
				<xsl:apply-templates/>
			</para>
        </listitem>
    </xsl:template>
    
    <xsl:template match="cdm:p">
    	<para>
			<xsl:apply-templates/>
		</para>
    </xsl:template>
    
    <xsl:template match="cdm:br">
    	<phrase role="linebreak"/>
    </xsl:template>
    
    <xsl:template match="cdm:bold|cdm:strong">
    	<emphasis role="strong">
			<xsl:apply-templates/>
		</emphasis>
    </xsl:template>
    
    <xsl:template match="cdm:italic|cdm:em">
    	<emphasis>
			<xsl:apply-templates/>
		</emphasis>
    </xsl:template>
    
    <xsl:template match="cdm:picture">
     	<mediaobject>
            <xsl:choose>
                <xsl:when test="cdm:extension/ametys-cdm:video-type">
                    <xsl:attribute name="type">
                        <xsl:choose>
                            <xsl:when test="cdm:extension/ametys-cdm:video-type = 'youtube' or cdm:extension/ametys-cdm:video-type = 'dailymotion'"><xsl:value-of select="cdm:extension/ametys-cdm:video-type"/></xsl:when>
                            <xsl:otherwise>video</xsl:otherwise>
                        </xsl:choose>
                    </xsl:attribute>
                    <videoobject>
                        <videodata fileref="{cdm:webLink/cdm:href}" width="{cdm:extension/ametys-cdm:width}" depth="{cdm:extension/ametys-cdm:height}">
                            <xsl:attribute name="type">
                                <xsl:choose>
                                    <xsl:when test="cdm:extension/ametys-cdm:video-type = 'explorer'">local</xsl:when>
                                    <xsl:otherwise><xsl:value-of select="cdm:extension/ametys-cdm:video-type"/></xsl:otherwise>
                                </xsl:choose>
                            </xsl:attribute>
                        </videodata>
                    </videoobject>
                </xsl:when>
                <xsl:otherwise>
                    <alt/>
             		<imageobject>
             			<imagedata type="local" fileref="{cdm:webLink/cdm:href}" width="{cdm:extension/ametys-cdm:width}" depth="{cdm:extension/ametys-cdm:height}"/>
             		</imageobject>
                </xsl:otherwise>
            </xsl:choose>
     	</mediaobject>
    </xsl:template>
    
    <xsl:template match="cdm:email">
    	<xsl:if test="text() != ''">
	    	<link>
	    		<xsl:attribute name="xlink:href">
	    			<xsl:text>mailto:</xsl:text>
	       			<xsl:value-of select="text()"/>
	       		</xsl:attribute>
	       		<xsl:apply-templates/>
	    	</link>
    	</xsl:if>
    </xsl:template>
    
    <xsl:template match="cdm:webLink[@role = 'learningObjectMetadata']">
    	<!-- LOM sheets, ignore -->
    </xsl:template>
    
    <xsl:template match="cdm:webLink">
    	<xsl:if test="normalize-space(cdm:href) != ''">
	        <link>
	       		<xsl:attribute name="xlink:href">
	       			<xsl:value-of select="cdm:href"/>
	       		</xsl:attribute>
	       		<xsl:choose>
	       			<xsl:when test="normalize-space(cdm:linkName)">
	       				<xsl:apply-templates select="cdm:linkName"/>
	       			</xsl:when>
	       			<xsl:otherwise>
	       				<xsl:apply-templates select="cdm:href"/>
	       			</xsl:otherwise>
	       		</xsl:choose>
	        </link>
    	</xsl:if>
    </xsl:template>
    
    <xsl:template match="xhtml:table">
        <table>
            <xsl:variable name="width" select="editor:getStyleValue(@style, 'width')"/>
            <xsl:if test="$width = '100%'">
                <xsl:attribute name="width">100%</xsl:attribute>
            </xsl:if>
            
            <xsl:if test="caption/text()">
                <xsl:attribute name="title"><xsl:value-of select="caption/text()"/></xsl:attribute>
                
                <xsl:variable name="captionTextAlign" select="editor:getStyleValue(caption/@style, 'text-align')"/>
                <xsl:if test="$captionTextAlign != ''">
                    <xsl:attribute name="titleAlign"><xsl:value-of select="$captionTextAlign"/></xsl:attribute>
                </xsl:if>
            </xsl:if>
            
            <xsl:copy-of select="@class|@summary|@align|@marker"/>
            
            <xsl:choose>
                <xsl:when test="xhtml:tbody">
                    <xsl:apply-templates select="xhtml:tbody"/>
                </xsl:when>
                <xsl:otherwise>
                    <tbody>
                        <xsl:apply-templates select="xhtml:tr"/>
                    </tbody>
                </xsl:otherwise>
            </xsl:choose>
        </table>
    </xsl:template>
    
    <xsl:template match="xhtml:tbody">
        <tbody>
            <xsl:copy-of select="@class"/>
            <xsl:apply-templates select="xhtml:tr"/>
        </tbody>
    </xsl:template>
    
    <xsl:template match="xhtml:tr">
        <tr>
            <xsl:copy-of select="@class"/>
            <xsl:apply-templates select="xhtml:td|xhtml:th"/>
        </tr>
    </xsl:template>
    
    <xsl:template match="xhtml:th">
        <th>
            <xsl:copy-of select="@class"/>
            <xsl:copy-of select="@colspan"/>
            <xsl:copy-of select="@rowspan"/>
            
            <xsl:variable name="valign" select="editor:getStyleValue(@style, 'vertical-align')"/>
            <xsl:if test="$valign != ''">
                <xsl:attribute name="valign"><xsl:value-of select="$valign"/></xsl:attribute>
            </xsl:if>
            
            <xsl:variable name="align" select="editor:getStyleValue(@style, 'text-align')"/>
            <xsl:if test="$align != ''">
                <xsl:attribute name="align"><xsl:value-of select="$align"/></xsl:attribute>
            </xsl:if>
            
            <xsl:variable name="height" select="editor:getStyleValue(@style, 'height')"/>
            <xsl:if test="$height != ''">
                <xsl:attribute name="height"><xsl:value-of select="$height"/></xsl:attribute>
            </xsl:if>
            
            <xsl:variable name="width" select="editor:getStyleValue(@style, 'width')"/>
            <xsl:if test="$width != ''">
                <xsl:attribute name="width"><xsl:value-of select="$width"/></xsl:attribute>
            </xsl:if>
            
            <xsl:apply-templates/>
        </th>
    </xsl:template>    
    
    <xsl:template match="xhtml:td">
        <td>
            <xsl:copy-of select="@class|@colspan|@rowspan"/>
            
            <xsl:variable name="valign" select="editor:getStyleValue(@style, 'vertical-align')"/>
            <xsl:if test="$valign != ''">
                <xsl:attribute name="valign"><xsl:value-of select="$valign"/></xsl:attribute>
            </xsl:if>
            
            <xsl:variable name="align" select="editor:getStyleValue(@style, 'text-align')"/>
            <xsl:if test="$align != ''">
                <xsl:attribute name="align"><xsl:value-of select="$align"/></xsl:attribute>
            </xsl:if>
            
            <xsl:variable name="height" select="editor:getStyleValue(@style, 'height')"/>
            <xsl:if test="$height != ''">
                <xsl:attribute name="height"><xsl:value-of select="$height"/></xsl:attribute>
            </xsl:if>
            
            <xsl:variable name="width" select="editor:getStyleValue(@style, 'width')"/>
            <xsl:if test="$width != ''">
                <xsl:attribute name="width"><xsl:value-of select="$width"/></xsl:attribute>
            </xsl:if>
            
            <xsl:apply-templates/>
        </td>
    </xsl:template>
    
    <xsl:template match="ametys-cdm:htmlexpert">
        <html:htmlexpert>
            <xsl:value-of select="."/>
        </html:htmlexpert>
    </xsl:template>
    
    <xsl:template match="processing-instruction('ametys-unmodifiable')[normalize-space(.) = 'start']">
        <html:htmlexpert>
            <xsl:value-of select="./following-sibling::text()[1]"/>
        </html:htmlexpert>
    </xsl:template>
    
    <xsl:template match="node()[following-sibling::processing-instruction('ametys-unmodifiable')[normalize-space(.) = 'end'] and
                                preceding-sibling::processing-instruction('ametys-unmodifiable')[normalize-space(.) = 'start']]">
        <!-- already processed in template matching the processing-instruction, ignore -->
    </xsl:template>
    
    <xsl:template match="text()[not(parent::*[parent::*])]">
    	<xsl:if test="normalize-space(.) != ''">
	    	<para>
	    		<xsl:value-of select="normalize-space(.)"/>
	    	</para>
    	</xsl:if>
    </xsl:template>
    
</xsl:stylesheet>