/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package org.ametys.plugins.odfsync.generic.scc;

import java.util.Optional;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

import org.ametys.odf.enumeration.OdfReferenceTableEntry;
import org.ametys.plugins.odfsync.scc.operator.ODFSynchronizingContentOperatorHelper;

/**
 * Get mapped values from connector to Ametys.
 */
public class ImportSynchronizingContentOperatorHelper extends ODFSynchronizingContentOperatorHelper
{
    private String _fieldName;
    
    @Override
    public void configure(Configuration configuration) throws ConfigurationException
    {
        super.configure(configuration);
        _fieldName = configuration.getChild("field-name").getValue();
    }
    
    @Override
    protected Optional<OdfReferenceTableEntry> _getReferenceTableEntry(String contentTypeId, String connectorCode)
    {
        return Optional.of(connectorCode)
            .map(code -> _odfRefTableHelper.getItemFromConnector(contentTypeId, code, _fieldName)) // First check if we find the content from code of connector
            .or(() -> super._getReferenceTableEntry(contentTypeId, connectorCode)); // Then check if we find the content from XML mapping
    }
}
