/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfsync.scc;

import java.util.Map;
import java.util.Set;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ModifiableContent;
import org.ametys.odf.catalog.CopyCatalogUpdater;
import org.ametys.odf.program.ProgramTranslationUpdater;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollectionHelper;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;

/**
 * The catalog copy updater to add the internal scc id if exists
 */
public class SCCCopyUpdater extends AbstractLogEnabled implements CopyCatalogUpdater, ProgramTranslationUpdater, Serviceable
{
    /** The ametys object resolver */
    protected AmetysObjectResolver _resolver;
    
    /** The SCC helper */
    protected SynchronizableContentsCollectionHelper _sccHelper;
    
    public void service(ServiceManager manager) throws ServiceException
    {
        _resolver = (AmetysObjectResolver) manager.lookup(AmetysObjectResolver.ROLE);
        _sccHelper = (SynchronizableContentsCollectionHelper) manager.lookup(SynchronizableContentsCollectionHelper.ROLE);
    }
    
    public void updateContents(String initialCatalogName, String newCatalogName, Map<Content, Content> copiedContents, Content targetParentContent)
    {
        for (Content initialContent : copiedContents.keySet())
        {
            Set<String> synchronizableCollectionIds = _sccHelper.getSynchronizableCollectionIds(initialContent);
            if (!synchronizableCollectionIds.isEmpty())
            {
                Content createdContent = copiedContents.get(initialContent);
                
                if (createdContent instanceof ModifiableContent modifiableCreatedContent)
                {
                    for (String sccId : synchronizableCollectionIds)
                    {
                        _sccHelper.updateSCCProperty(modifiableCreatedContent, sccId);
                    }
                
                    modifiableCreatedContent.saveChanges();
                }
            }
        }
    }
}
