<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2012 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:cdm="http://cdm-fr.fr/2011/CDM"
	xmlns:cdmfr="http://cdm-fr.fr/2011/CDM-frSchema"
	xmlns:exsl="http://exslt.org/common"
	exclude-result-prefixes="cdm cdmfr exsl">
	
	<xsl:import href="../cdmfr2content.xsl"/>
	
	<xsl:include href="person2content.xsl"/>
	<xsl:include href="orgunit2content.xsl"/>
	<xsl:include href="course2content.xsl"/>
	<xsl:include href="program2content.xsl"/>
	
	<!-- @Override Program : Find the mention ME (= program referenced in habilitation) -->
	<xsl:template match="cdm:program">
		<xsl:if test="@ident = /cdm:CDM/cdmfr:habilitation/cdmfr:habiliId">
			
			<xsl:choose>
				<xsl:when test="starts-with(@ident, 'FH')">
					<!-- Import of mention FH as the root program. The referenced programs PR are sub-programs -->
					<xsl:apply-templates select="." mode="root-program"/>
				</xsl:when>
				
				<xsl:otherwise>
					<xsl:variable name="firstProgramRef" select="cdmfr:programStructure/cdmfr:refProgram/@ref"/>
					<xsl:choose>
						<xsl:when test="starts-with(/cdm:CDM/cdm:program[cdm:programID = $firstProgramRef]/@ident, 'PR') and count(cdmfr:programStructure/cdmfr:refProgram) &gt; 1">
							<!-- Import of mention ME as the root program. The referenced programs PR are sub-programs -->
							<xsl:apply-templates select="." mode="root-program"/>
						</xsl:when>
						<xsl:otherwise>
							<!-- Iteration of referenced programs -->
							<xsl:for-each select="cdmfr:programStructure/cdmfr:refProgram">
								<xsl:variable name="programRef" select="@ref"/>
								<xsl:variable name="ident" select="/cdm:CDM/cdm:program[cdm:programID = $programRef]/@ident"/>
		
								<xsl:choose>
									<xsl:when test="starts-with($ident, 'SP')">
										<!-- Referenced program is a speciality SP -->
										<xsl:variable name="program-count" select="count(/cdm:CDM/cdm:program[cdm:programID = $programRef]/cdmfr:programStructure/cdmfr:refProgram)" />
										<xsl:choose>
											<xsl:when test="$program-count != 1">
												<!-- The speciality has several programs PR => Import the speciality as root program. The referenced programs PR are sub-programs of the speciality -->
												<!-- Also import the speciality if no sub-programs -->
												<xsl:apply-templates select="/cdm:CDM/cdm:program[cdm:programID = $programRef]" mode="root-program">
													<xsl:with-param name="ME" select="/cdm:CDM/cdm:program[@ident = /cdm:CDM/cdmfr:habilitation/cdmfr:habiliId]"/>
												</xsl:apply-templates>
											</xsl:when>
											<xsl:otherwise>
												<!-- The speciality has only one PR program => Import the PR program as root program -->
												 <xsl:variable name="spProgramRef" select="/cdm:CDM/cdm:program[cdm:programID = $programRef]/cdmfr:programStructure/cdmfr:refProgram/@ref"/>
												 <xsl:apply-templates select="/cdm:CDM/cdm:program[cdm:programID = $spProgramRef]" mode="root-program">
												 	<xsl:with-param name="ME" select="/cdm:CDM/cdm:program[@ident = /cdm:CDM/cdmfr:habilitation/cdmfr:habiliId]"></xsl:with-param>
												 	<xsl:with-param name="SP" select="/cdm:CDM/cdm:program[cdm:programID = $programRef]"></xsl:with-param>
												 </xsl:apply-templates>
											</xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<xsl:when test="starts-with($ident, 'PR')">
										<!-- Import all PR programs as root programs. There is no speciality -->
										<xsl:apply-templates select="/cdm:CDM/cdm:program[cdm:programID = $programRef]" mode="root-program">
											<xsl:with-param name="ME" select="/cdm:CDM/cdm:program[@ident = /cdm:CDM/cdmfr:habilitation/cdmfr:habiliId]"/>
										</xsl:apply-templates>
									</xsl:when>
								</xsl:choose>
							</xsl:for-each>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>
	
	<xsl:template match="cdm:program" mode="root-program">
		<xsl:param name="ME"/> <!-- Vide si la mention ME est le programe -->
		<xsl:param name="SP"/> <!-- Vide si la spécialité SP est le programe -->
		
		<xsl:variable name="ME-node" select="exsl:node-set($ME)"/>
		<xsl:variable name="SP-node" select="exsl:node-set($SP)"/>
		<program>
			<xsl:call-template name="program-CDMid"/>
			<xsl:call-template name="program-language"/>
			<xsl:call-template name="root-program-title"/>
			<xsl:call-template name="root-program-presentation">
				<xsl:with-param name="ME" select="$ME-node"/>
				<xsl:with-param name="SP" select="$SP-node"/>
			</xsl:call-template>
			<xsl:call-template name="root-program-objectives">
				<xsl:with-param name="ME" select="$ME-node"/>
				<xsl:with-param name="SP" select="$SP-node"/>
			</xsl:call-template>
			<xsl:call-template name="root-program-qualification">
				<xsl:with-param name="ME" select="$ME-node"/>
				<xsl:with-param name="SP" select="$SP-node"/>
			</xsl:call-template>
			<xsl:call-template name="root-program-teachingOrganization">
				<xsl:with-param name="ME" select="$ME-node"/>
				<xsl:with-param name="SP" select="$SP-node"/>
			</xsl:call-template>
			<xsl:call-template name="root-program-accessCondition">
				<xsl:with-param name="ME" select="$ME-node"/>
				<xsl:with-param name="SP" select="$SP-node"/>
			</xsl:call-template>
			<xsl:call-template name="root-program-neededPrerequisite">
				<xsl:with-param name="ME" select="$ME-node"/>
				<xsl:with-param name="SP" select="$SP-node"/>
			</xsl:call-template>
			<xsl:call-template name="root-program-recommendedPrerequisite">
				<xsl:with-param name="ME" select="$ME-node"/>
				<xsl:with-param name="SP" select="$SP-node"/>
			</xsl:call-template>
			<xsl:call-template name="root-program-furtherStudy">
				<xsl:with-param name="ME" select="$ME-node"/>
				<xsl:with-param name="SP" select="$SP-node"/>
			</xsl:call-template>
			<xsl:call-template name="root-program-studyAbroad">
				<xsl:with-param name="ME" select="$ME-node"/>
				<xsl:with-param name="SP" select="$SP-node"/>
			</xsl:call-template>
			<xsl:call-template name="root-program-targetGroup">
				<xsl:with-param name="ME" select="$ME-node"/>
				<xsl:with-param name="SP" select="$SP-node"/>
			</xsl:call-template>
			<xsl:call-template name="root-program-jobOpportunities">
				<xsl:with-param name="ME" select="$ME-node"/>
				<xsl:with-param name="SP" select="$SP-node"/>
			</xsl:call-template>
			<xsl:call-template name="program-trainingStrategy">
				<xsl:with-param name="ME" select="$ME-node"/>
				<xsl:with-param name="SP" select="$SP-node"/>
			</xsl:call-template>
			<xsl:call-template name="root-program-knowledgeCheck">
				<xsl:with-param name="ME" select="$ME-node"/>
				<xsl:with-param name="SP" select="$SP-node"/>
			</xsl:call-template>
			<xsl:call-template name="root-program-universalAdjustment">
				<xsl:with-param name="ME" select="$ME-node"/>
				<xsl:with-param name="SP" select="$SP-node"/>
			</xsl:call-template>
			<xsl:call-template name="root-program-additionalInformations">
				<xsl:with-param name="ME" select="$ME-node"/>
				<xsl:with-param name="SP" select="$SP-node"/>
			</xsl:call-template>
			<xsl:call-template name="root-program-reorientation">
				<xsl:with-param name="ME" select="$ME-node"/>
				<xsl:with-param name="SP" select="$SP-node"/>
			</xsl:call-template>
			<xsl:call-template name="root-program-expenses">
				<xsl:with-param name="ME" select="$ME-node"/>
				<xsl:with-param name="SP" select="$SP-node"/>
			</xsl:call-template>
            <xsl:call-template name="root-program-partnerSchools"/>
			<xsl:call-template name="root-program-domain"/>
			<xsl:call-template name="program-rncpCode"/>
			<xsl:call-template name="program-siseCode"/>
			<xsl:call-template name="program-cite97Code"/>
			<xsl:call-template name="program-erasmusCode"/>
			<xsl:call-template name="program-romeCode"/>
			<xsl:call-template name="program-dgesipCode"/>
            <xsl:call-template name="program-fapCode"/>
			<xsl:call-template name="program-code"/>
			<xsl:call-template name="program-cdmCode"/>
			<xsl:call-template name="root-program-mention"/>
			<xsl:call-template name="program-speciality"/>
			<xsl:call-template name="program-educationLevel"/>
			<xsl:call-template name="root-program-degree"/>
			<xsl:call-template name="program-jointOrgUnit"/>
			<xsl:call-template name="root-program-orgUnit">
                <xsl:with-param name="ME" select="$ME-node"/>
                <xsl:with-param name="SP" select="$SP-node"/>
            </xsl:call-template>
			<xsl:call-template name="program-place"/>
			<xsl:call-template name="program-contacts"/>
            <xsl:call-template name="program-website"/>
			<xsl:call-template name="program-successRate"/>
			<xsl:call-template name="root-program-ects"/>
			<xsl:call-template name="program-educationKind"/>
			<xsl:call-template name="program-duration"/>
			<xsl:call-template name="program-educationLanguage"/>
			<xsl:call-template name="program-numberOfStudents"/>
            <xsl:call-template name="program-formofteachingOrg"/>
			<xsl:call-template name="program-distanceLearning"/>
			<xsl:call-template name="program-keywords"/>
			<xsl:call-template name="program-structure"/>
			<xsl:call-template name="program-subProgram"/>
            <xsl:call-template name="program-registration"/>
            <xsl:call-template name="program-teachingStart"/>
		</program>
	</xsl:template>
	
</xsl:stylesheet>
