/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfsync.cdmfr.actions;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ametys.cms.repository.Content;
import org.ametys.odf.ODFHelper;
import org.ametys.odf.catalog.CatalogsManager;
import org.ametys.odf.helper.DeleteODFContentHelper;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollection;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollectionHelper;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang3.StringUtils;

public class DeleteRemoteProgramAction
extends ServiceableAction {
    protected AmetysObjectResolver _resolver;
    protected DeleteODFContentHelper _deleteODFContentHelper;
    protected ODFHelper _odfHelper;
    protected SynchronizableContentsCollectionHelper _sccHelper;
    protected CatalogsManager _catalogsManager;

    public void service(ServiceManager sManager) throws ServiceException {
        super.service(sManager);
        this._sccHelper = (SynchronizableContentsCollectionHelper)sManager.lookup(SynchronizableContentsCollectionHelper.ROLE);
        this._resolver = (AmetysObjectResolver)this.manager.lookup(AmetysObjectResolver.ROLE);
        this._deleteODFContentHelper = (DeleteODFContentHelper)this.manager.lookup(DeleteODFContentHelper.ROLE);
        this._odfHelper = (ODFHelper)this.manager.lookup(ODFHelper.ROLE);
        this._catalogsManager = (CatalogsManager)this.manager.lookup(CatalogsManager.ROLE);
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        HashMap<String, HashSet<String>> results = new HashMap<String, HashSet<String>>();
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        HashSet<String> errors = new HashSet<String>();
        SynchronizableContentsCollection scc = this._sccHelper.getSCCFromModelId("org.ametys.plugins.odfsync.remote.cdmfr.scc");
        if (scc == null) {
            errors.add("Can't find synchronizable contents collections for the remote CDMFr import with model id org.ametys.plugins.odfsync.remote.cdmfr.scc");
        } else {
            String code = this._getParameterValue(request, "code", errors);
            String lang = this._getParameterValue(request, "language", errors);
            if (errors.isEmpty()) {
                String catalog = this._getCatalog(scc, request);
                Content content = (Content)this._odfHelper.getODFContent("org.ametys.plugins.odf.Content.program", code, catalog, lang);
                this._deleteODFContentHelper.deleteContents(Collections.singletonList(content.getId()), DeleteODFContentHelper.DeleteMode.FULL.name(), true);
            }
        }
        if (!errors.isEmpty()) {
            results.put("errors", errors);
        }
        return results;
    }

    private String _getParameterValue(Request request, String parameterName, Set<String> errors) {
        String result = request.getParameter(parameterName);
        if (StringUtils.isEmpty((CharSequence)result)) {
            errors.add("Metadata '" + parameterName + "' is mandatory.");
        }
        return result;
    }

    private String _getCatalog(SynchronizableContentsCollection scc, Request request) {
        String forcedCatalog = (String)scc.getParameterValues().get("remote.catalog");
        if (StringUtils.isNotEmpty((CharSequence)forcedCatalog)) {
            return forcedCatalog;
        }
        String remoteCatalog = request.getParameter("catalog");
        if (this._catalogsManager.getCatalog(remoteCatalog) == null) {
            return this._catalogsManager.getDefaultCatalogName();
        }
        return remoteCatalog;
    }
}

