/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfsync.scc.operator;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.ametys.odf.enumeration.OdfReferenceTableEntry;
import org.ametys.odf.enumeration.OdfReferenceTableHelper;
import org.ametys.plugins.odfsync.generic.scc.AbstractMappingHelper;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class ODFSynchronizingContentOperatorHelper
extends AbstractMappingHelper
implements Component,
Initializable {
    protected OdfReferenceTableHelper _odfRefTableHelper;
    protected Map<String, Map<String, String>> _codeMappings;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._odfRefTableHelper = (OdfReferenceTableHelper)manager.lookup(OdfReferenceTableHelper.ROLE);
    }

    public void initialize() throws Exception {
        this._codeMappings = new HashMap<String, Map<String, String>>();
    }

    public String getReferenceTableEntryId(String contentTypeId, String connectorCode) {
        return Optional.ofNullable(connectorCode).flatMap(code -> this._getReferenceTableEntry(contentTypeId, (String)code)).map(OdfReferenceTableEntry::getId).orElse(null);
    }

    protected Optional<OdfReferenceTableEntry> _getReferenceTableEntry(String contentTypeId, String connectorCode) {
        return Optional.of(connectorCode).flatMap(code -> this._getReferenceTableEntryFromMapping((String)code, contentTypeId));
    }

    protected Optional<OdfReferenceTableEntry> _getReferenceTableEntryFromMapping(String connectorCode, String contentTypeId) {
        return Optional.ofNullable(connectorCode).map(code -> this._getConvertedCode((String)code, contentTypeId)).map(code -> this._odfRefTableHelper.getItemFromCode(contentTypeId, code));
    }

    protected String _getConvertedCode(String connectorCode, String contentTypeId) {
        String shortContentTypeId = contentTypeId.substring(contentTypeId.lastIndexOf(".") + 1);
        return this._codeMappings.computeIfAbsent(shortContentTypeId, this::_readContentTypeMapping).getOrDefault(connectorCode, connectorCode);
    }

    protected Map<String, String> _readContentTypeMapping(String contentTypeId) {
        String fileName = contentTypeId.toLowerCase() + "_conversion.xml";
        String baseUri = "/code/" + fileName;
        try {
            return super._readMapping(baseUri);
        }
        catch (Exception e) {
            this.getLogger().error("Unable to read the mapping file '{}' for content type '{}'", new Object[]{fileName, contentTypeId, e});
            return Map.of();
        }
    }
}

