/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfsync.pegase.ws;

import java.util.Map;

import org.ametys.core.ui.Callable;
import org.ametys.plugins.odfsync.export.AbstractExportClientSideElement;

/**
 * Client side element for Pégase export button
 */
public class PegaseExportClientSideElement extends AbstractExportClientSideElement
{
    @Override
    protected String getActivateParam()
    {
        return "pegase.activate";
    }
    
    @Override
    protected String getStructureComponentRole()
    {
        return PegaseStructureComponent.ROLE;
    }
    
    @Override
    @Callable(rights = "ODF_Rights_Pegase_Export")
    public Map<String, Object> getExportReportInfo(String programId)
    {
        return super.getExportReportInfo(programId);
    }
    
    @Override
    @Callable(rights = "ODF_Rights_Pegase_Export")
    public Map<String, Object> exportProgram(String programId)
    {
        return super.exportProgram(programId);
    }
}
