/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfsync.apogee.ws.structure;

import gouv.education.apogee.commun.client.ws.creationse.CreationSEMetierServiceInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.ametys.cms.data.ContentValue;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ModifiableContent;
import org.ametys.odf.course.Course;
import org.ametys.odf.courselist.CourseList;
import org.ametys.odf.orgunit.OrgUnit;
import org.ametys.odf.program.Container;
import org.ametys.odf.program.ProgramPart;
import org.ametys.odf.program.SubProgram;
import org.ametys.plugins.odfsync.apogee.ws.ApogeeStructureComponent;
import org.ametys.plugins.odfsync.apogee.ws.ApogeeWS;
import org.ametys.plugins.odfsync.export.AbstractExportStructure;
import org.ametys.plugins.odfsync.export.ExportReport;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractApogeeStructure
extends AbstractExportStructure {
    public static final String ROLE = ApogeeStructureComponent.class.getName();
    public static final String CODE_APOGEE_ATTRIBUTE_NAME = "codeApogee";
    public static final String VERSION_APOGEE_ATTRIBUTE_NAME = "versionApogee";
    public static final String CODE_APOGEE_SEPARATOR = "-";
    protected ApogeeWS _apogeeWS;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._apogeeWS = (ApogeeWS)((Object)manager.lookup(ApogeeWS.ROLE));
    }

    public List<String> getDIPMandatoryData(Content content) {
        ArrayList<String> mandatoryData = new ArrayList<String>();
        mandatoryData.add(CODE_APOGEE_ATTRIBUTE_NAME);
        mandatoryData.add("educationKind");
        mandatoryData.add("cycleApogee");
        mandatoryData.add("degree");
        return mandatoryData;
    }

    public List<String> getVDIMandatoryData(Content content) {
        ArrayList<String> mandatoryData = new ArrayList<String>();
        mandatoryData.add(VERSION_APOGEE_ATTRIBUTE_NAME);
        mandatoryData.add("start-date-recruitment");
        mandatoryData.add("end-date-recruitment");
        mandatoryData.add("start-date-validation");
        mandatoryData.add("end-date-validation");
        return mandatoryData;
    }

    public List<String> getETPMandatoryData(Content content) {
        ArrayList<String> mandatoryData = new ArrayList<String>();
        mandatoryData.add(CODE_APOGEE_ATTRIBUTE_NAME);
        mandatoryData.add("cycleApogee");
        return mandatoryData;
    }

    public List<String> getVETMandatoryData(Content content) {
        ArrayList<String> mandatoryData = new ArrayList<String>();
        mandatoryData.add(VERSION_APOGEE_ATTRIBUTE_NAME);
        mandatoryData.add("duration-apogee");
        mandatoryData.add("inscription-types");
        mandatoryData.add("cips");
        return mandatoryData;
    }

    public List<String> getLSEMandatoryData(Content content) {
        ArrayList<String> mandatoryData = new ArrayList<String>();
        mandatoryData.add(CODE_APOGEE_ATTRIBUTE_NAME);
        mandatoryData.add("choiceType");
        String choiceTypeAmetys = (String)content.getValue("choiceType");
        if (choiceTypeAmetys.equals("CHOICE")) {
            mandatoryData.add("min");
        }
        return mandatoryData;
    }

    public List<String> getELPMandatoryData(Content content) {
        ArrayList<String> mandatoryData = new ArrayList<String>();
        mandatoryData.add(CODE_APOGEE_ATTRIBUTE_NAME);
        mandatoryData.add("cips");
        mandatoryData.add("orgUnit");
        if (content instanceof Container) {
            mandatoryData.add("nature");
        } else if (content instanceof Course) {
            mandatoryData.add("courseType");
        }
        return mandatoryData;
    }

    public List<String> getOrgUnitMandatoryDataForDIP() {
        ArrayList<String> mandatoryData = new ArrayList<String>();
        mandatoryData.add(CODE_APOGEE_ATTRIBUTE_NAME);
        return mandatoryData;
    }

    public List<String> getOrgUnitMandatoryDataForETP() {
        ArrayList<String> mandatoryData = new ArrayList<String>();
        mandatoryData.add(CODE_APOGEE_ATTRIBUTE_NAME);
        mandatoryData.add("codeCGE");
        return mandatoryData;
    }

    public List<String> getOrgUnitMandatoryDataForELP() {
        ArrayList<String> mandatoryData = new ArrayList<String>();
        mandatoryData.add(CODE_APOGEE_ATTRIBUTE_NAME);
        return mandatoryData;
    }

    public String getCodeApogee(Content content) {
        String codeApogee = (String)content.getValue(CODE_APOGEE_ATTRIBUTE_NAME);
        if (StringUtils.isNotBlank((CharSequence)codeApogee) && codeApogee.contains(CODE_APOGEE_SEPARATOR)) {
            return StringUtils.substringBefore((String)codeApogee, (String)CODE_APOGEE_SEPARATOR);
        }
        return codeApogee;
    }

    public Long getVersionApogee(Content content) {
        String codeApogee = (String)content.getValue(CODE_APOGEE_ATTRIBUTE_NAME);
        if (StringUtils.isNotBlank((CharSequence)codeApogee) && codeApogee.contains(CODE_APOGEE_SEPARATOR)) {
            return Long.parseLong(StringUtils.substringAfterLast((String)codeApogee, (String)CODE_APOGEE_SEPARATOR));
        }
        return null;
    }

    public abstract void checkSubProgram(SubProgram var1, ExportReport var2);

    public void checkContainerAsYear(Container container, ExportReport report, String containerNatureCode) {
        if (this.checkContainerYear(containerNatureCode, report)) {
            this.checkMandatoryDataForContent((Content)container, this.getETPMandatoryData((Content)container), report);
            this.checkMandatoryDataForContent((Content)container, this.getVETMandatoryData((Content)container), report);
            List orgUnits = container.getOrgUnits();
            this.checkMandatoryDataForOrgunits((Content)container, orgUnits, this.getOrgUnitMandatoryDataForETP(), report);
            List programPartChildren = container.getProgramPartChildren();
            for (ProgramPart childProgramPart : programPartChildren) {
                if (childProgramPart instanceof Container) {
                    Container containerChildProgramPart = (Container)childProgramPart;
                    String childContainerNatureCode = this.getContainerNatureCode(containerChildProgramPart);
                    this.checkContainerAsSemester(containerChildProgramPart, report, childContainerNatureCode);
                    continue;
                }
                report.setStatus(ExportReport.ExportStatus.CONTENT_STRUCTURE_INVALID);
                break;
            }
            if (programPartChildren.isEmpty()) {
                report.setStatus(ExportReport.ExportStatus.CONTENT_STRUCTURE_INVALID);
            }
        } else {
            report.setStatus(ExportReport.ExportStatus.CONTENT_STRUCTURE_INVALID);
        }
    }

    public void checkContainerAsSemester(Container container, ExportReport report, String containerNatureCode) {
        if (this.checkContainerSemester(containerNatureCode, report)) {
            this.checkMandatoryDataForContent((Content)container, this.getELPMandatoryData((Content)container), report);
            for (ProgramPart childProgramPart : container.getProgramPartChildren()) {
                if (childProgramPart instanceof CourseList) {
                    this.checkCourseList((CourseList)childProgramPart, report);
                    continue;
                }
                report.setStatus(ExportReport.ExportStatus.CONTENT_STRUCTURE_INVALID);
                break;
            }
        } else {
            report.setStatus(ExportReport.ExportStatus.CONTENT_STRUCTURE_INVALID);
        }
    }

    public void checkCourseList(CourseList courseList, ExportReport report) {
        this.checkMandatoryDataForContent((Content)courseList, this.getLSEMandatoryData((Content)courseList), report);
        for (Course course : courseList.getCourses()) {
            this.checkCourse(course, report);
        }
    }

    public void checkCourse(Course course, ExportReport report) {
        this.checkMandatoryDataForContent((Content)course, this.getELPMandatoryData((Content)course), report);
        this.checkMandatoryDataForOrgunits((Content)course, course.getOrgUnits(), this.getOrgUnitMandatoryDataForELP(), report);
        for (CourseList courseList : course.getCourseLists()) {
            this.checkCourseList(courseList, report);
        }
    }

    public void checkMandatoryDataForContent(Content content, List<String> mandatoryData, ExportReport report) {
        for (String dataPath : mandatoryData) {
            if (VERSION_APOGEE_ATTRIBUTE_NAME.equals(dataPath)) {
                this._checkVersionApogee(content, report);
                continue;
            }
            if (content.hasValue(dataPath)) {
                if ("string".equals(content.getType(dataPath).getId())) {
                    this._checkSimpleData(content, dataPath, report);
                    continue;
                }
                if (!"content".equals(content.getType(dataPath).getId())) continue;
                this._checkTableRef(content, dataPath, report);
                continue;
            }
            this._addMandatoryDataPathAndReport(content, dataPath, report);
        }
    }

    protected void _checkSimpleData(Content content, String dataPath, ExportReport report) {
        if (content.isMultiple(dataPath)) {
            String[] values = (String[])content.getValue(dataPath);
            if (values.length == 0 || StringUtils.isBlank((CharSequence)values[0])) {
                this._addMandatoryDataPathAndReport(content, dataPath, report);
            }
        } else {
            String value = (String)content.getValue(dataPath);
            if (StringUtils.isBlank((CharSequence)value)) {
                this._addMandatoryDataPathAndReport(content, dataPath, report);
            }
        }
    }

    protected void _checkTableRef(Content content, String dataPath, ExportReport report) {
        if (!content.isMultiple(dataPath)) {
            ContentValue value = (ContentValue)content.getValue(dataPath);
            ModifiableContent refContent = value.getContent();
            if (!value.hasValue(CODE_APOGEE_ATTRIBUTE_NAME)) {
                this._addMandatoryDataPathAndReport((Content)refContent, CODE_APOGEE_ATTRIBUTE_NAME, report);
            }
        }
    }

    protected void _checkVersionApogee(Content content, ExportReport report) {
        if (!content.hasValue(CODE_APOGEE_ATTRIBUTE_NAME)) {
            report.addInvalidDataPath(content, new I18nizableText("plugin.odf-sync", "PLUGINS_ODF_SYNC_EXPORT_APOGEE_MANDATORY_VERSION"));
        } else {
            String codeApogee = (String)content.getValue(CODE_APOGEE_ATTRIBUTE_NAME);
            if (!codeApogee.contains(CODE_APOGEE_SEPARATOR) || StringUtils.isBlank((CharSequence)StringUtils.substringAfterLast((String)codeApogee, (String)CODE_APOGEE_SEPARATOR))) {
                report.addInvalidDataPath(content, new I18nizableText("plugin.odf-sync", "PLUGINS_ODF_SYNC_EXPORT_APOGEE_MANDATORY_VERSION"));
            }
        }
    }

    public void checkMandatoryDataForOrgunits(Content content, List<String> orgUnits, List<String> mandatoryData, ExportReport report) {
        if (orgUnits.size() == 0) {
            this._addMandatoryDataPathAndReport(content, "orgUnit", report);
        } else {
            for (String orgUnitId : orgUnits) {
                OrgUnit orgUnit = (OrgUnit)this._resolver.resolveById(orgUnitId);
                this.checkMandatoryDataForContent((Content)orgUnit, mandatoryData, report);
            }
        }
    }

    protected void _createCourseList(CourseList courseList, Content parentApogee, CreationSEMetierServiceInterface creationService, ExportReport report) throws RemoteException {
        for (Course course : courseList.getCourses()) {
            this._createCourse(course, (Content)courseList, creationService, report);
        }
        String codELP = this.getCodeApogee(parentApogee);
        String codLSE = this.getCodeApogee((Content)courseList);
        this._apogeeWS.createLSE(courseList, null, codLSE, creationService);
        Long nbELP = null;
        Double ectsMin = 0.0;
        Double ectsMax = 0.0;
        String choiceTypeAmetys = (String)courseList.getValue("choiceType");
        if (choiceTypeAmetys.equals("CHOICE")) {
            nbELP = (Long)courseList.getValue("min");
            List ectsList = courseList.getCourses().stream().map(Course::getEcts).sorted().collect(Collectors.toList());
            int i = 0;
            while ((long)i < nbELP) {
                ectsMin = ectsMin + (Double)ectsList.get(0);
                ++i;
            }
            ectsMin = Math.floor(ectsMin) == 0.0 ? 1.0 : Math.floor(ectsMin);
            i = 1;
            while ((long)i <= nbELP) {
                ectsMax = ectsMax + (Double)ectsList.get(ectsList.size() - i);
                ++i;
            }
            ectsMax = Math.ceil(ectsMax) == 0.0 || ectsMin > ectsMax ? 1.0 : Math.ceil(ectsMax);
        }
        this._apogeeWS.createLinkETPELPLSE(null, null, codLSE, codELP, nbELP, ectsMin, ectsMax, creationService);
    }

    protected void _createCourse(Course course, Content parentApogee, CreationSEMetierServiceInterface creationService, ExportReport report) throws RemoteException {
        String codELP = this.getCodeApogee((Content)course);
        this._apogeeWS.createELP((Content)course, null, codELP, creationService);
        for (CourseList courseList : course.getCourseLists()) {
            this._createCourseList(courseList, (Content)course, creationService, report);
        }
    }

    protected boolean checkContainerSemester(String containerNatureCode, ExportReport report) {
        if (containerNatureCode.isBlank()) {
            report.setStatus(ExportReport.ExportStatus.CONTENT_STRUCTURE_INVALID);
            return false;
        }
        return "semestre".equals(containerNatureCode);
    }

    protected boolean checkContainerYear(String containerNatureCode, ExportReport report) {
        if (containerNatureCode.isBlank()) {
            report.setStatus(ExportReport.ExportStatus.CONTENT_STRUCTURE_INVALID);
            return false;
        }
        return "annee".equals(containerNatureCode);
    }

    private void _addMandatoryDataPathAndReport(Content content, String dataPath, ExportReport report) {
        I18nizableText invalidMessage = new I18nizableText("plugin.odf-sync", "PLUGINS_ODF_SYNC_EXPORT_APOGEE_MANDATORY_FIELD", Map.of("fieldName", content.getDefinition(dataPath).getLabel()));
        report.addInvalidDataPath(content, invalidMessage);
    }
}

