/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfsync.pegase.ws.structure;

import fr.pcscol.pegase.odf.ApiException;
import fr.pcscol.pegase.odf.api.ObjetsMaquetteApi;
import fr.pcscol.pegase.odf.model.Contexte;
import fr.pcscol.pegase.odf.model.CreerFormationRequest;
import fr.pcscol.pegase.odf.model.CreerGroupementRequest;
import fr.pcscol.pegase.odf.model.CreerObjetFormationRequest;
import fr.pcscol.pegase.odf.model.CreerObjetMaquetteRequest;
import fr.pcscol.pegase.odf.model.DescripteursAglae;
import fr.pcscol.pegase.odf.model.DescripteursEnqueteRequest;
import fr.pcscol.pegase.odf.model.DescripteursFormationRequest;
import fr.pcscol.pegase.odf.model.DescripteursFormationSyllabus;
import fr.pcscol.pegase.odf.model.DescripteursGroupementRequest;
import fr.pcscol.pegase.odf.model.DescripteursObjetFormationRequest;
import fr.pcscol.pegase.odf.model.DescripteursObjetFormationSyllabus;
import fr.pcscol.pegase.odf.model.DescripteursObjetMaquetteRequest;
import fr.pcscol.pegase.odf.model.DescripteursSiseRequest;
import fr.pcscol.pegase.odf.model.DescripteursSyllabus;
import fr.pcscol.pegase.odf.model.Enfant;
import fr.pcscol.pegase.odf.model.EnfantsStructure;
import fr.pcscol.pegase.odf.model.MaquetteStructure;
import fr.pcscol.pegase.odf.model.ObjetMaquetteDetail;
import fr.pcscol.pegase.odf.model.ObjetMaquetteStructure;
import fr.pcscol.pegase.odf.model.ObjetMaquetteSummary;
import fr.pcscol.pegase.odf.model.Pageable;
import fr.pcscol.pegase.odf.model.PagedObjetMaquetteSummaries;
import fr.pcscol.pegase.odf.model.PlageDeChoix;
import fr.pcscol.pegase.odf.model.TypeObjetMaquette;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import org.ametys.cms.data.ContentValue;
import org.ametys.cms.data.RichText;
import org.ametys.cms.data.RichTextHelper;
import org.ametys.cms.repository.Content;
import org.ametys.odf.ODFHelper;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.course.Course;
import org.ametys.odf.courselist.CourseList;
import org.ametys.odf.program.AbstractProgram;
import org.ametys.odf.program.Container;
import org.ametys.odf.program.Program;
import org.ametys.odf.program.ProgramPart;
import org.ametys.odf.program.SubProgram;
import org.ametys.plugins.odfsync.export.AbstractExportStructure;
import org.ametys.plugins.odfsync.export.ExportReport;
import org.ametys.plugins.odfsync.pegase.ws.PegaseApiManager;
import org.ametys.plugins.odfsync.pegase.ws.PegaseExportException;
import org.ametys.plugins.odfsync.pegase.ws.PegaseHelper;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.data.UnknownDataException;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;

public class PegaseProgramStructure
extends AbstractExportStructure
implements Component,
Initializable {
    public static final String ROLE = PegaseProgramStructure.class.getName();
    private static final String __CODE_PEGASE_ATTRIBUTE_NAME = "pegaseCode";
    private static final Pattern __CODE_PATTERN = Pattern.compile("^[A-Z0-9\\-]{3,30}$");
    private static final String __PEGASE_SYNC_CODE = "pegaseSyncCode";
    private static final String __ECTS_DATA_PATH = "ects";
    private static final String __PARCOURS_TYPE_ID = "PARCOURS-TYPE";
    private static final String __ANNEE_TYPE_ID = "ANNEE";
    private static final String __SEMESTRE_TYPE_ID = "SEMESTRE";
    private static final Map<String, Set<String>> __MANDATORY_ATTRIBUTES_BY_CONTENT_TYPE = new HashMap<String, Set<String>>();
    private PegaseApiManager _pegaseApiManager;
    private ODFHelper _odfHelper;
    private RichTextHelper _richTextHelper;
    private PegaseHelper _pegaseHelper;
    private boolean _isActive;
    private String _structureCode;
    private boolean _trustAmetys;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._odfHelper = (ODFHelper)manager.lookup(ODFHelper.ROLE);
        this._pegaseApiManager = (PegaseApiManager)((Object)manager.lookup(PegaseApiManager.ROLE));
        this._richTextHelper = (RichTextHelper)manager.lookup(RichTextHelper.ROLE);
        this._pegaseHelper = (PegaseHelper)manager.lookup(PegaseHelper.ROLE);
    }

    public void initialize() throws Exception {
        this._isActive = (Boolean)Config.getInstance().getValue("pegase.activate", true, (Object)false);
        if (this._isActive) {
            this._structureCode = (String)Config.getInstance().getValue("pegase.structure.code");
            this._trustAmetys = (Boolean)Config.getInstance().getValue("pegase.trust", true, (Object)false);
        }
    }

    private String _getEtag(ObjetsMaquetteApi objetsMaquetteApi) {
        List etags = (List)objetsMaquetteApi.getApiClient().getResponseHeaders().get("ETag");
        String etag = "1";
        if (etags != null && !etags.isEmpty()) {
            etag = (String)etags.get(0);
        }
        return etag;
    }

    private Pageable _getPageable(int page, int taille, List<String> tri) {
        Pageable pageable = new Pageable();
        pageable.setPage(Integer.valueOf(page));
        pageable.setTaille(Integer.valueOf(taille));
        pageable.setTri(tri);
        return pageable;
    }

    @Override
    public void checkProgram(Program program, ExportReport report) {
        if (!this._isActive) {
            throw new UnsupportedOperationException("P\u00e9gase is not active in the configuration, you cannot check the program for the export.");
        }
        try {
            this._checkProgramItem((ProgramItem)program, report);
        }
        catch (PegaseExportException e) {
            report.setStatus(ExportReport.ExportStatus.ERROR);
            this.getLogger().error("An error occured while checking the program", (Throwable)e);
        }
    }

    private void _checkProgramItem(ProgramItem programItem, ExportReport report) throws PegaseExportException {
        this._checkAttributes((Content)programItem, report);
        for (ProgramItem child : this._odfHelper.getChildProgramItems(programItem)) {
            this._checkProgramItem(child, report);
        }
    }

    private void _checkAttributes(Content content, ExportReport report) throws PegaseExportException {
        if (content instanceof Program) {
            this._checkPegaseCodesForProgram(content, report);
        } else if (content instanceof ProgramItem) {
            this._checkPegaseCodes(content, report);
        }
        String contentType = content.getTypes()[0];
        Set mandatoryAttributes = __MANDATORY_ATTRIBUTES_BY_CONTENT_TYPE.getOrDefault(contentType, Set.of());
        for (String attribute : mandatoryAttributes) {
            if (content.hasValue(attribute)) continue;
            this._addMandatoryDataPathAndReport(content, attribute, report);
        }
    }

    private void _checkPegaseCodesForProgram(Content content, ExportReport report) throws PegaseExportException {
        UUID syncCode = null;
        boolean hasValidSyncCode = false;
        if (content.hasValue(__PEGASE_SYNC_CODE)) {
            syncCode = this._getUuidIfValid((String)content.getValue(__PEGASE_SYNC_CODE));
            boolean bl = hasValidSyncCode = syncCode != null;
            if (!hasValidSyncCode) {
                report.addInvalidDataPath(content, new I18nizableText("plugin.odf-sync", "PLUGINS_ODF_SYNC_EXPORT_PEGASE_INVALID_SYNC_CODE"));
            }
        }
        boolean hasValidPegaseCode = false;
        if (content.hasValue(__CODE_PEGASE_ATTRIBUTE_NAME) && !(hasValidPegaseCode = this._isValidPegaseCode((String)content.getValue(__CODE_PEGASE_ATTRIBUTE_NAME)))) {
            report.addInvalidDataPath(content, new I18nizableText("plugin.odf-sync", "PLUGINS_ODF_SYNC_EXPORT_PEGASE_INVALID_CODE"));
        }
        if (hasValidSyncCode && hasValidPegaseCode) {
            this._checkProgramCoherenceWithTwoCodes((String)content.getValue(__CODE_PEGASE_ATTRIBUTE_NAME), syncCode, report);
        } else if (hasValidSyncCode && !hasValidPegaseCode) {
            this._getProgramAndcheckCoherenceForUUID(syncCode, report);
        } else if (!hasValidSyncCode && hasValidPegaseCode) {
            this._checkProgramCoherenceByCode((String)content.getValue(__CODE_PEGASE_ATTRIBUTE_NAME), report);
        } else {
            this._addMandatoryPegaseCodeAndReport(content, report);
        }
    }

    private void _checkProgramCoherenceWithTwoCodes(String pegaseCode, UUID pegaseSyncCode, ExportReport report) throws PegaseExportException {
        ObjetMaquetteSummary programFound = this._getProgramAndcheckCoherenceForUUID(pegaseSyncCode, report);
        if (programFound != null && !ExportReport.ExportStatus.NON_EDITABLE_PROGRAM_ALREADY_EXISTS.equals((Object)report.getStatus()) && !pegaseCode.equals(programFound.getCode())) {
            report.setStatus(ExportReport.ExportStatus.NON_EDITABLE_PROGRAM_ALREADY_EXISTS);
        }
    }

    private ObjetMaquetteSummary _getProgramAndcheckCoherenceForUUID(UUID syncCode, ExportReport report) throws PegaseExportException {
        try {
            ObjetsMaquetteApi objetsMaquetteApi = this._pegaseApiManager.getObjetsMaquetteApi();
            PagedObjetMaquetteSummaries pagedObjetMaquetteSummaries = objetsMaquetteApi.rechercherObjetMaquette(this._structureCode, this._getPageable(0, 10, List.of()), null, this._pegaseHelper.getEspaceId(this._structureCode).toString(), List.of(), null, null, List.of(syncCode), null, null, null, null);
            if (pagedObjetMaquetteSummaries.getTotalElements() == 1L) {
                ObjetMaquetteSummary objetMaquetteSummary = (ObjetMaquetteSummary)pagedObjetMaquetteSummaries.getItems().get(0);
                if (!TypeObjetMaquette.FORMATION.equals((Object)objetMaquetteSummary.getTypeObjetMaquette()) || objetMaquetteSummary.getValideInAnyContexte().booleanValue()) {
                    report.setStatus(ExportReport.ExportStatus.NON_EDITABLE_PROGRAM_ALREADY_EXISTS);
                }
                return objetMaquetteSummary;
            }
            report.setStatus(ExportReport.ExportStatus.NON_EDITABLE_PROGRAM_ALREADY_EXISTS);
            return null;
        }
        catch (ApiException | IOException e) {
            report.setStatus(ExportReport.ExportStatus.ERROR);
            this.getLogger().warn("Une erreur est survenue lors la recherche de l'\u00e9l\u00e9ment de code de synchronization P\u00e9gase '{}' pour v\u00e9rifier son existance pr\u00e9alable dans P\u00e9gase", (Object)syncCode, (Object)e);
            return null;
        }
    }

    private void _checkProgramCoherenceByCode(String pegaseCode, ExportReport report) throws PegaseExportException {
        try {
            ObjetsMaquetteApi objetsMaquetteApi = this._pegaseApiManager.getObjetsMaquetteApi();
            PagedObjetMaquetteSummaries pagedObjetMaquetteSummaries = objetsMaquetteApi.rechercherObjetMaquette(this._structureCode, this._getPageable(0, 10, List.of()), pegaseCode, this._pegaseHelper.getEspaceId(this._structureCode).toString(), List.of(), null, null, List.of(), null, null, null, null);
            Long numberOfResults = pagedObjetMaquetteSummaries.getTotalElements();
            if (numberOfResults == 1L) {
                ObjetMaquetteSummary objetMaquetteSummary = (ObjetMaquetteSummary)pagedObjetMaquetteSummaries.getItems().get(0);
                if (!TypeObjetMaquette.FORMATION.equals((Object)objetMaquetteSummary.getTypeObjetMaquette()) || objetMaquetteSummary.getValideInAnyContexte().booleanValue()) {
                    report.setStatus(ExportReport.ExportStatus.NON_EDITABLE_PROGRAM_ALREADY_EXISTS);
                }
            } else if (numberOfResults > 1L) {
                report.setStatus(ExportReport.ExportStatus.NON_EDITABLE_PROGRAM_ALREADY_EXISTS);
            }
        }
        catch (ApiException | IOException e) {
            report.setStatus(ExportReport.ExportStatus.ERROR);
            this.getLogger().warn("Une erreur est survenue lors la recherche de l'\u00e9l\u00e9ment de code de synchronization P\u00e9gase '{}' pour v\u00e9rifier son existance pr\u00e9alable dans P\u00e9gase", (Object)pegaseCode, (Object)e);
        }
    }

    private void _checkPegaseCodes(Content content, ExportReport report) {
        if (!(content.hasValue(__PEGASE_SYNC_CODE) && this._getUuidIfValid((String)content.getValue(__PEGASE_SYNC_CODE)) != null || content.hasValue(__CODE_PEGASE_ATTRIBUTE_NAME) && this._isValidPegaseCode((String)content.getValue(__CODE_PEGASE_ATTRIBUTE_NAME)))) {
            this._addMandatoryPegaseCodeAndReport(content, report);
        }
    }

    private UUID _getUuidIfValid(String uuidToCheck) {
        try {
            return UUID.fromString(uuidToCheck);
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean _isValidPegaseCode(String attribute) {
        return __CODE_PATTERN.matcher(attribute).matches();
    }

    private void _addMandatoryDataPathAndReport(Content content, String dataPath, ExportReport report) {
        I18nizableText invalidMessage = new I18nizableText("plugin.odf-sync", "PLUGINS_ODF_SYNC_EXPORT_PEGASE_MANDATORY_FIELD", Map.of("fieldName", content.getDefinition(dataPath).getLabel()));
        report.addInvalidDataPath(content, invalidMessage);
    }

    private void _addMandatoryPegaseCodeAndReport(Content content, ExportReport report) {
        I18nizableText invalidMessage = new I18nizableText("plugin.odf-sync", "PLUGINS_ODF_SYNC_EXPORT_PEGASE_MANDATORY_FIELDS", Map.of("fieldName", content.getDefinition(__PEGASE_SYNC_CODE).getLabel(), "secondFieldName", content.getDefinition(__CODE_PEGASE_ATTRIBUTE_NAME).getLabel()));
        report.addInvalidDataPath(content, invalidMessage);
    }

    private Set<ProgramItem> _getAllChildrenProgramItems(ProgramItem programItem) {
        return this._getAllChildrenProgramItems(programItem, new HashSet<ProgramItem>());
    }

    private Set<ProgramItem> _getAllChildrenProgramItems(ProgramItem programItem, Set<ProgramItem> allChildrenProgramItems) {
        allChildrenProgramItems.add(programItem);
        for (ProgramItem child : this._odfHelper.getChildProgramItems(programItem)) {
            if (allChildrenProgramItems.contains(child)) continue;
            allChildrenProgramItems.addAll(this._getAllChildrenProgramItems(child, allChildrenProgramItems));
        }
        return allChildrenProgramItems;
    }

    private ObjetMaquetteAndEtagIfExists _getPegaseProgramIfAlreadyExists(Program program, ExportReport report) throws PegaseExportException {
        return this._getPegaseObjetMaquetteDetailIfAlreadyExists((Content)program, TypeObjetMaquette.FORMATION, report);
    }

    private ObjetMaquetteAndEtagIfExists _getPegaseObjetFormationIfAlreadyExists(Content content, ExportReport report) throws PegaseExportException {
        return this._getPegaseObjetMaquetteDetailIfAlreadyExists(content, TypeObjetMaquette.OBJET_FORMATION, report);
    }

    private ObjetMaquetteAndEtagIfExists _getPegaseGroupIfAlreadyExists(Content content, ExportReport report) throws PegaseExportException {
        return this._getPegaseObjetMaquetteDetailIfAlreadyExists(content, TypeObjetMaquette.GROUPEMENT, report);
    }

    private ObjetMaquetteAndEtagIfExists _getPegaseObjetMaquetteDetailIfAlreadyExists(Content content, TypeObjetMaquette type, ExportReport report) throws PegaseExportException {
        try {
            if (content.hasValue(__PEGASE_SYNC_CODE)) {
                String id = (String)content.getValue(__PEGASE_SYNC_CODE);
                try {
                    ObjetsMaquetteApi objetsMaquetteApi = this._pegaseApiManager.getObjetsMaquetteApi();
                    ObjetMaquetteDetail objetMaquetteFound = objetsMaquetteApi.lireObjetMaquette(this._structureCode, UUID.fromString(id));
                    if (!type.equals((Object)objetMaquetteFound.getTypeObjetMaquette())) {
                        throw new PegaseExportException("Erreur lors de l'export de " + content.getTitle() + ". Un \u00e9l\u00e9ment avec l'identifiant P\u00e9gase existe d\u00e9j\u00e0 et n'est pas mutualisable ou modifiable");
                    }
                    return new ObjetMaquetteAndEtagIfExists(objetMaquetteFound, this._getEtag(objetsMaquetteApi));
                }
                catch (ApiException e) {
                    throw new PegaseExportException("Un code de synchronisation ('" + id + "') P\u00e9gase a \u00e9t\u00e9 entr\u00e9 pour l'\u00e9l\u00e9ment " + content.getTitle() + " mais aucun \u00e9l\u00e9ment ne correspond \u00e0 ce code dans P\u00e9gase.", e);
                }
            }
            if (content.hasValue(__CODE_PEGASE_ATTRIBUTE_NAME)) {
                String pegaseCode = (String)content.getValue(__CODE_PEGASE_ATTRIBUTE_NAME);
                return this._getObjetMaquetteDetailFromPaged(content, pegaseCode, type, report);
            }
        }
        catch (ApiException | IOException e) {
            throw new PegaseExportException("Une erreur est survenue en essayant de r\u00e9cup\u00e9rer un \u00e9l\u00e9ment d\u00e9j\u00e0 existant pour l'\u00e9l\u00e9ment '" + content.getTitle() + "'.", e);
        }
        return new ObjetMaquetteAndEtagIfExists(null, null);
    }

    private ObjetMaquetteAndEtagIfExists _getObjetMaquetteDetailFromPaged(Content content, String pegaseCode, TypeObjetMaquette type, ExportReport report) throws ApiException, IOException, PegaseExportException {
        PagedObjetMaquetteSummaries pagedObjetsMaquetteFound = this._pegaseApiManager.getObjetsMaquetteApi().rechercherObjetMaquette(this._structureCode, this._getPageable(0, Integer.MAX_VALUE, List.of()), pegaseCode, this._pegaseHelper.getEspaceId(this._structureCode).toString(), List.of(), null, null, List.of(), null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false));
        ObjetMaquetteAndEtagIfExists objetMaquetteFound = this._lookForObjetMaquetteInPage(content, pagedObjetsMaquetteFound, pegaseCode, type, report);
        if (objetMaquetteFound != null) {
            return objetMaquetteFound;
        }
        for (int page = 0; page < pagedObjetsMaquetteFound.getTotalPages(); ++page) {
            objetMaquetteFound = this._lookForObjetMaquetteInPage(content, page, Integer.MAX_VALUE, pegaseCode, type, report);
            if (objetMaquetteFound == null) continue;
            return objetMaquetteFound;
        }
        return new ObjetMaquetteAndEtagIfExists(null, null);
    }

    private ObjetMaquetteAndEtagIfExists _lookForObjetMaquetteInPage(Content content, int page, int taille, String pegaseCode, TypeObjetMaquette type, ExportReport report) throws ApiException, IOException, PegaseExportException {
        PagedObjetMaquetteSummaries pagedObjetsMaquetteFound = this._pegaseApiManager.getObjetsMaquetteApi().rechercherObjetMaquette(this._structureCode, this._getPageable(page, taille, List.of()), pegaseCode, this._pegaseHelper.getEspaceId(this._structureCode).toString(), List.of(), null, null, List.of(), null, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false));
        return this._lookForObjetMaquetteInPage(content, pagedObjetsMaquetteFound, pegaseCode, type, report);
    }

    private ObjetMaquetteAndEtagIfExists _lookForObjetMaquetteInPage(Content content, PagedObjetMaquetteSummaries pagedObjetsMaquetteFound, String pegaseCode, TypeObjetMaquette type, ExportReport report) throws ApiException, IOException, UnknownDataException, AmetysRepositoryException, PegaseExportException {
        List items = pagedObjetsMaquetteFound.getItems();
        if (items != null) {
            for (ObjetMaquetteSummary objetMaquette : items) {
                if (!pegaseCode.equals(objetMaquette.getCode())) continue;
                if (objetMaquette.getTypeObjetMaquette().equals((Object)type) && !objetMaquette.getValideInAnyContexte().booleanValue()) {
                    ObjetsMaquetteApi objetsMaquetteApi = this._pegaseApiManager.getObjetsMaquetteApi();
                    return new ObjetMaquetteAndEtagIfExists(objetsMaquetteApi.lireObjetMaquette(this._structureCode, objetMaquette.getId()), this._getEtag(objetsMaquetteApi));
                }
                report.updateExportReport(ExportReport.ExportStatus.ERROR, ExportReport.ProblemTypes.ELEMENT_ALREADY_EXIST);
                throw new PegaseExportException("Erreur lors de l'export de " + content.getTitle() + ". Un \u00e9l\u00e9ment avec l'identifiant ou le code P\u00e9gase existe d\u00e9j\u00e0 et n'est pas mutualisable ou modifiable");
            }
        }
        return new ObjetMaquetteAndEtagIfExists(null, null);
    }

    private void _initCreerObjetMaquetteRequest(CreerObjetMaquetteRequest creerObjetMaquetteRequest, TypeObjetMaquette typeObjetMaquette, Boolean mutualise, Content content) throws PegaseExportException {
        creerObjetMaquetteRequest.setCode((String)content.getValue(__CODE_PEGASE_ATTRIBUTE_NAME));
        creerObjetMaquetteRequest.setTypeObjetMaquette(typeObjetMaquette);
        creerObjetMaquetteRequest.setEspaceId(this._pegaseHelper.getEspaceId(this._structureCode));
        creerObjetMaquetteRequest.setMutualise(mutualise);
    }

    private Enfant _createPegaseChild(UUID pegaseId, boolean mandatory) {
        Enfant pegaseChild = new Enfant();
        pegaseChild.setId(pegaseId.toString());
        pegaseChild.setObligatoire(Boolean.valueOf(mandatory));
        return pegaseChild;
    }

    @Override
    public void createProgram(Program program, ExportReport report) {
        if (!this._isActive) {
            throw new UnsupportedOperationException("P\u00e9gase is not active in the configuration, you cannot import or synchronize a program in P\u00e9gase.");
        }
        int nbTotal = this._getAllChildrenProgramItems((ProgramItem)program).size();
        report.setNbTotal(nbTotal);
        try {
            ObjetMaquetteDetail pegaseProgram = this._createOrUpdateProgram(program, report);
            report.addElementExported((Content)program);
            List children = program.getProgramPartChildren();
            HashMap<String, PegaseChildWithChildren> childrenToLink = new HashMap<String, PegaseChildWithChildren>();
            for (ProgramPart child : children) {
                PegaseChildWithChildren enfant = this._createChild((Content)child, false, report);
                if (enfant == null) continue;
                childrenToLink.put(enfant.pegaseChild().getId(), enfant);
            }
            this._detachAndAttachAllChildren((Content)program, pegaseProgram.getId(), childrenToLink, report);
        }
        catch (Exception e) {
            report.updateStatus(ExportReport.ExportStatus.ERROR);
            this.getLogger().error("Une erreur est survenue lors de l'export de la formation '{}' ({}) dans P\u00e9gase", new Object[]{program.getTitle(), program.getId(), e});
        }
    }

    private ObjetMaquetteDetail _createOrUpdateProgram(Program program, ExportReport report) throws PegaseExportException {
        try {
            ObjetMaquetteAndEtagIfExists objetMaquetteAndEtagIfExists = this._getPegaseProgramIfAlreadyExists(program, report);
            ObjetMaquetteDetail objetMaquetteDetailFound = objetMaquetteAndEtagIfExists.objetMaquetteDetail();
            if (objetMaquetteDetailFound == null) {
                return this._createProgram(program);
            }
            String etag = objetMaquetteAndEtagIfExists.etag();
            return this._updateProgram(program, objetMaquetteDetailFound, etag);
        }
        catch (Exception e) {
            report.updateExportReport(ExportReport.ExportStatus.ERROR, ExportReport.ProblemTypes.API_ERROR);
            throw new PegaseExportException("Une erreur est survenue lors de la cr\u00e9ation ou modification de la formation dans P\u00e9gase", e);
        }
    }

    private ObjetMaquetteDetail _createProgram(Program program) throws ApiException, IOException, PegaseExportException {
        ObjetsMaquetteApi objetsMaquetteApi = this._pegaseApiManager.getObjetsMaquetteApi();
        CreerFormationRequest creerFormationRequest = new CreerFormationRequest();
        this._initCreerObjetMaquetteRequest((CreerObjetMaquetteRequest)creerFormationRequest, TypeObjetMaquette.FORMATION, false, (Content)program);
        creerFormationRequest.setDescripteursObjetMaquette((DescripteursObjetMaquetteRequest)this._getDescripteursFormationRequest(program));
        ObjetMaquetteDetail programCreated = objetsMaquetteApi.creerObjetMaquette(this._structureCode, (CreerObjetMaquetteRequest)creerFormationRequest);
        String etag = this._getEtag(objetsMaquetteApi);
        return this._updateDescripteurProgram((AbstractProgram)program, programCreated.getId(), etag, objetsMaquetteApi);
    }

    private ObjetMaquetteDetail _updateProgram(Program program, ObjetMaquetteDetail objetMaquetteDetailFound, String etag) throws IOException, ApiException, PegaseExportException {
        ObjetsMaquetteApi objetsMaquetteApi = this._pegaseApiManager.getObjetsMaquetteApi();
        DescripteursFormationRequest descripteursFormationRequest = this._getDescripteursFormationRequest(program);
        UUID pegaseProgramId = objetMaquetteDetailFound.getId();
        objetsMaquetteApi.modifierDescripteursObjetMaquette(this._structureCode, pegaseProgramId, etag, (DescripteursObjetMaquetteRequest)descripteursFormationRequest);
        return this._updateDescripteurProgram((AbstractProgram)program, pegaseProgramId, this._getEtag(objetsMaquetteApi), objetsMaquetteApi);
    }

    private ObjetMaquetteDetail _updateDescripteurProgram(AbstractProgram program, UUID pegaseId, String etag, ObjetsMaquetteApi objetsMaquetteApi) throws ApiException, IOException, PegaseExportException {
        this._updateDescripteursEnqueteFormation(program, pegaseId, etag, objetsMaquetteApi);
        return this._updateDescripteursSyllabus((Content)program, pegaseId, TypeObjetMaquette.FORMATION, (DescripteursSyllabus)new DescripteursFormationSyllabus());
    }

    private DescripteursFormationRequest _getDescripteursFormationRequest(Program program) {
        DescripteursFormationRequest descripteursFormationRequest = new DescripteursFormationRequest();
        String programTitle = program.getTitle();
        descripteursFormationRequest.setLibelle(StringUtils.truncate((String)programTitle, (int)50));
        descripteursFormationRequest.setLibelleLong(StringUtils.truncate((String)programTitle, (int)150));
        descripteursFormationRequest.setEcts(this._getEctsFromContent((Content)program));
        descripteursFormationRequest.setType(this._pegaseHelper.getPegaseCodeForField((Content)program, "educationKind"));
        return descripteursFormationRequest;
    }

    private ObjetMaquetteDetail _updateDescripteursSyllabus(Content content, UUID pegaseProgramId, TypeObjetMaquette type, DescripteursSyllabus descripteursSyllabus) throws ApiException, IOException, PegaseExportException {
        ObjetsMaquetteApi objetsMaquetteApi = this._pegaseApiManager.getObjetsMaquetteApi();
        String description = null;
        if (content.hasValue("description")) {
            description = this._richTextHelper.richTextToString((RichText)content.getValue("description"));
        } else if (content.hasValue("presentation")) {
            description = this._richTextHelper.richTextToString((RichText)content.getValue("presentation"));
        }
        if (description != null) {
            descripteursSyllabus.setDescription(StringUtils.truncate((String)description, (int)2000));
        }
        if (content.hasValue("objectives")) {
            descripteursSyllabus.setObjectif(StringUtils.truncate((String)this._richTextHelper.richTextToString((RichText)content.getValue("objectives")), (int)2000));
        }
        if (content.hasValue("neededPrerequisite")) {
            descripteursSyllabus.setPrerequisPedagogique(StringUtils.truncate((String)this._richTextHelper.richTextToString((RichText)content.getValue("neededPrerequisite")), (int)2000));
        }
        ObjetMaquetteAndEtagIfExists objetMaquetteExistingAndEtag = this._getPegaseObjetMaquetteDetailIfAlreadyExists(content, type, new ExportReport(content));
        return objetsMaquetteApi.modifierDescripteursSyllabusObjetMaquette(this._structureCode, pegaseProgramId, objetMaquetteExistingAndEtag.etag(), descripteursSyllabus);
    }

    private ObjetMaquetteDetail _updateDescripteursEnqueteFormation(AbstractProgram program, UUID pegaseProgramId, String etag, ObjetsMaquetteApi objetsMaquetteApi) throws ApiException {
        DescripteursSiseRequest descripteursSiseRequest = new DescripteursSiseRequest();
        descripteursSiseRequest.setTypeDiplome(this._pegaseHelper.getPegaseCodeForField((Content)program, "degree"));
        descripteursSiseRequest.setNiveauDiplomeSise(this._pegaseHelper.getPegaseCodeForField((Content)program, "educationLevel"));
        descripteursSiseRequest.setNiveauDiplome(this._pegaseHelper.getPegaseCodeForField((Content)program, "rncpLevel"));
        descripteursSiseRequest.setDomaineFormation(this._pegaseHelper.getPegaseCodeForFirstValue((Content)program, "domain"));
        descripteursSiseRequest.setMention(this._pegaseHelper.getPegaseCodeForField((Content)program, "mention"));
        descripteursSiseRequest.setChampFormation(this._pegaseHelper.getPegaseCodeForField((Content)program, "programField"));
        DescripteursEnqueteRequest descripteursEnqueteRequest = new DescripteursEnqueteRequest();
        descripteursEnqueteRequest.setDescripteursSise(descripteursSiseRequest);
        DescripteursAglae descripteursAglae = new DescripteursAglae();
        descripteursAglae.setHabilitePourBoursesAglae(Boolean.valueOf(false));
        descripteursEnqueteRequest.setDescripteursAglae(descripteursAglae);
        return objetsMaquetteApi.modifierDescripteursEnqueteObjetMaquette(this._structureCode, pegaseProgramId, etag, descripteursEnqueteRequest);
    }

    private BigDecimal _getEctsFromContent(Content content) {
        if (content.hasValue(__ECTS_DATA_PATH)) {
            Object value = content.getValue(__ECTS_DATA_PATH);
            if (value instanceof Double) {
                Double ects = (Double)value;
                return BigDecimal.valueOf(ects);
            }
            if (value instanceof ContentValue) {
                ContentValue contentValue = (ContentValue)value;
                try {
                    BigDecimal ects = contentValue.getContentIfExists().map(c -> (String)c.getValue("code")).map(Double::parseDouble).map(BigDecimal::valueOf).orElse(null);
                    return ects;
                }
                catch (NumberFormatException e) {
                    this.getLogger().debug("The ects value '{}' is not a double, therefore, it is not compatible with P\u00e9gase ects and will not be exported", (Object)contentValue);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PegaseChildWithChildren _createChild(Content content, boolean parentMutualise, ExportReport report) {
        boolean success = true;
        try {
            if (content instanceof Container) {
                Container container = (Container)content;
                PegaseChildWithChildren pegaseChildWithChildren = this._createOFFromContainer(container, parentMutualise, report);
                return pegaseChildWithChildren;
            }
            if (content instanceof SubProgram) {
                SubProgram subProgram = (SubProgram)content;
                PegaseChildWithChildren pegaseChildWithChildren = this._createObjetFormationAndChildren((Content)subProgram, __PARCOURS_TYPE_ID, parentMutualise, report);
                return pegaseChildWithChildren;
            }
            if (content instanceof Course) {
                Course course = (Course)content;
                PegaseChildWithChildren pegaseChildWithChildren = this._createObjetFormationAndChildren((Content)course, this._pegaseHelper.getPegaseCodeForFirstValue((Content)course, "courseType"), parentMutualise, report);
                return pegaseChildWithChildren;
            }
            if (content instanceof CourseList) {
                PegaseChildWithChildren course = this._createGroupFromCourseList((CourseList)content, parentMutualise, report);
                return course;
            }
            PegaseChildWithChildren course = null;
            return course;
        }
        catch (Exception ex) {
            success = false;
            this.getLogger().error("Erreur lors de l'export de l'\u00e9l\u00e9ment '{}'", (Object)content.getTitle(), (Object)ex);
            PegaseChildWithChildren pegaseChildWithChildren = null;
            return pegaseChildWithChildren;
        }
        finally {
            if (success) {
                report.addElementExported(content);
            }
        }
    }

    private PegaseChildWithChildren _createOFFromContainer(Container container, boolean parentMutualise, ExportReport report) throws PegaseExportException, IOException, ApiException {
        String type = null;
        String natureCode = this.getContainerNatureCode(container);
        boolean isYear = "annee".equals(natureCode);
        boolean isSemester = "semestre".equals(natureCode);
        if (isYear || isSemester) {
            type = isYear ? __ANNEE_TYPE_ID : __SEMESTRE_TYPE_ID;
            return this._createObjetFormationAndChildren((Content)container, type, parentMutualise, report);
        }
        return null;
    }

    private PegaseChildWithChildren _createObjetFormationAndChildren(Content content, String type, boolean parentMutualise, ExportReport report) throws IOException, PegaseExportException, ApiException {
        ObjetMaquetteDetail objetMaquetteDetailCreated = this._createOrUpdateObjetFormation(content, type, parentMutualise, report);
        this._updateDescripteursSyllabus(content, objetMaquetteDetailCreated.getId(), TypeObjetMaquette.OBJET_FORMATION, (DescripteursSyllabus)new DescripteursObjetFormationSyllabus());
        ChildrenToAttachForObjectRequest childrenToAttach = this._createChildrenIfAny(content, objetMaquetteDetailCreated, report);
        UUID objetMaquetteDetailCreatedId = objetMaquetteDetailCreated.getId();
        return new PegaseChildWithChildren(this._createPegaseChild(objetMaquetteDetailCreatedId, true), childrenToAttach);
    }

    private ObjetMaquetteDetail _createOrUpdateObjetFormation(Content content, String type, boolean parentMutualise, ExportReport report) throws PegaseExportException {
        try {
            ObjetMaquetteAndEtagIfExists objetMaquetteAndEtagIfExists = this._getPegaseObjetFormationIfAlreadyExists(content, report);
            ObjetMaquetteDetail objetMaquetteDetail = objetMaquetteAndEtagIfExists.objetMaquetteDetail();
            if (objetMaquetteDetail != null) {
                return this._updateObjetFormation(objetMaquetteAndEtagIfExists, content, type, parentMutualise, report);
            }
            return this._createObjetFormation(content, type, parentMutualise, report);
        }
        catch (Exception e) {
            report.updateExportReport(ExportReport.ExportStatus.ERROR, ExportReport.ProblemTypes.API_ERROR);
            throw new PegaseExportException("Une erreur est survenue lors de la r\u00e9cup\u00e9ration de l'objet P\u00e9gase d\u00e9j\u00e0 existant", e);
        }
    }

    private PegaseChildWithChildren _createGroupFromCourseList(CourseList courseList, boolean parentMutualise, ExportReport report) throws PegaseExportException {
        CourseList.ChoiceType type = courseList.getType();
        boolean mandatory = !CourseList.ChoiceType.OPTIONAL.equals((Object)type);
        PlageDeChoix plageDeChoix = CourseList.ChoiceType.CHOICE.equals((Object)type) ? this._buildPlageDeChoix(courseList) : null;
        ObjetMaquetteDetail objetMaquetteDetailCreated = this._createOrUpdateGroup(courseList, parentMutualise, plageDeChoix, report);
        ChildrenToAttachForObjectRequest childrenToAttach = this._createChildrenIfAny((Content)courseList, objetMaquetteDetailCreated, report);
        UUID objetMaquetteDetailCreatedId = objetMaquetteDetailCreated.getId();
        return new PegaseChildWithChildren(this._createPegaseChild(objetMaquetteDetailCreatedId, mandatory), childrenToAttach);
    }

    private ObjetMaquetteDetail _createOrUpdateGroup(CourseList courseList, boolean parentMutualise, PlageDeChoix plageDeChoix, ExportReport report) throws PegaseExportException {
        try {
            ObjetMaquetteAndEtagIfExists objetMaquetteAndEtagIfExists = this._getPegaseGroupIfAlreadyExists((Content)courseList, report);
            ObjetMaquetteDetail objetMaquetteDetail = objetMaquetteAndEtagIfExists.objetMaquetteDetail();
            if (objetMaquetteDetail != null) {
                return this._updateGroup(objetMaquetteAndEtagIfExists, (Content)courseList, parentMutualise, plageDeChoix, report);
            }
            return this._createGroup(courseList, parentMutualise, plageDeChoix, report);
        }
        catch (Exception e) {
            report.updateExportReport(ExportReport.ExportStatus.ERROR, ExportReport.ProblemTypes.API_ERROR);
            throw new PegaseExportException("Une erreur est survenue lors de la r\u00e9cup\u00e9ration de l'objet P\u00e9gase d\u00e9j\u00e0 existant", e);
        }
    }

    private ObjetMaquetteDetail _updateGroup(ObjetMaquetteAndEtagIfExists objetMaquetteAndEtagIfExists, Content content, boolean parentMutualise, PlageDeChoix plageDeChoix, ExportReport report) throws PegaseExportException, IOException {
        DescripteursGroupementRequest descripteursGroupementRequest = new DescripteursGroupementRequest();
        String label = content.getTitle();
        descripteursGroupementRequest.setLibelle(StringUtils.truncate((String)label, (int)50));
        descripteursGroupementRequest.setLibelleLong(StringUtils.truncate((String)label, (int)150));
        descripteursGroupementRequest.setPlageDeChoix(plageDeChoix);
        return this._updateObjetMaquette(objetMaquetteAndEtagIfExists, content, parentMutualise, (DescripteursObjetMaquetteRequest)descripteursGroupementRequest, report);
    }

    private ObjetMaquetteDetail _createGroup(CourseList courseList, boolean parentMutualise, PlageDeChoix plageDeChoix, ExportReport report) throws PegaseExportException {
        DescripteursGroupementRequest descripteursGroupementRequest = new DescripteursGroupementRequest();
        if (plageDeChoix != null) {
            descripteursGroupementRequest.setPlageDeChoix(plageDeChoix);
        }
        CreerGroupementRequest creerGroupementRequest = new CreerGroupementRequest();
        return this._createObjetMaquette((Content)courseList, TypeObjetMaquette.GROUPEMENT, parentMutualise, (DescripteursObjetMaquetteRequest)descripteursGroupementRequest, (CreerObjetMaquetteRequest)creerGroupementRequest, report);
    }

    private ChildrenToAttachForObjectRequest _createChildrenIfAny(Content content, ObjetMaquetteDetail objetMaquetteDetailCreated, ExportReport report) throws UnknownDataException, AmetysRepositoryException {
        Map<String, PegaseChildWithChildren> children = new HashMap<String, PegaseChildWithChildren>();
        if (content instanceof ProgramItem) {
            ProgramItem programItem = (ProgramItem)content;
            children = this._createAllChildren(this._odfHelper.getChildProgramItems(programItem), objetMaquetteDetailCreated.getMutualise(), report);
        }
        return new ChildrenToAttachForObjectRequest(content, objetMaquetteDetailCreated.getId(), children);
    }

    private Map<String, PegaseChildWithChildren> _createAllChildren(List<ProgramItem> programItem, boolean parentMutualise, ExportReport report) {
        HashMap<String, PegaseChildWithChildren> children = new HashMap<String, PegaseChildWithChildren>();
        for (ProgramItem childContent : programItem) {
            PegaseChildWithChildren child = this._createChild((Content)childContent, parentMutualise, report);
            if (child == null) continue;
            children.put(child.pegaseChild().getId(), child);
        }
        return children;
    }

    private void _detachAndAttachAllChildren(Content content, UUID pegaseParentID, Map<String, PegaseChildWithChildren> children, ExportReport report) throws PegaseExportException {
        try {
            Map<String, PegaseChildWithChildren> childrenToCheck = Map.copyOf(children);
            this._detachChildren(content, pegaseParentID, children, report);
            for (PegaseChildWithChildren childToAttach : childrenToCheck.values()) {
                if (children.containsValue(childToAttach)) continue;
                ChildrenToAttachForObjectRequest childrenToAttach = childToAttach.childrenToAttachRequest();
                this._attachAllChildren(childrenToAttach.parentContent(), childrenToAttach.parentId(), childrenToAttach.children(), report);
            }
            this._attachAllChildren(content, pegaseParentID, children, report);
        }
        catch (Exception e) {
            throw new PegaseExportException("Une erreur est survenue lors de l'attachement des enfants de la formation '" + content.getTitle() + "'");
        }
    }

    private void _detachChildren(Content content, UUID pegaseParentObjectId, Map<String, PegaseChildWithChildren> children, ExportReport report) throws UnknownDataException, AmetysRepositoryException, PegaseExportException {
        try {
            for (PegaseChildWithChildren childToAttach : children.values()) {
                ChildrenToAttachForObjectRequest childrenToAttach = childToAttach.childrenToAttachRequest();
                this._detachChildren(childrenToAttach.parentContent(), childrenToAttach.parentId(), childrenToAttach.children(), report);
            }
            MaquetteStructure structureMaquetteParent = this._pegaseApiManager.getMaquettesApi().lireStructureMaquette(this._structureCode, pegaseParentObjectId);
            ObjetMaquetteStructure parentRacine = structureMaquetteParent.getRacine();
            List childrenAlreadyAttached = parentRacine.getEnfants();
            if (childrenAlreadyAttached != null) {
                for (EnfantsStructure child : childrenAlreadyAttached) {
                    UUID childId = child.getObjetMaquette().getId();
                    String stringChildId = childId.toString();
                    if (children.keySet().contains(stringChildId)) {
                        this._pegaseApiManager.getObjetsMaquetteApi().retirerEnfant(this._structureCode, pegaseParentObjectId, childId);
                        continue;
                    }
                    if (!this._trustAmetys) continue;
                    try {
                        this._pegaseApiManager.getObjetsMaquetteApi().retirerEnfant(this._structureCode, pegaseParentObjectId, childId);
                    }
                    catch (ApiException e) {
                        report.updateExportReport(ExportReport.ExportStatus.ERROR, ExportReport.ProblemTypes.API_ERROR, content);
                        this.getLogger().warn("L'enfant de code P\u00e9gase '{}' de l'\u00e9l\u00e9ment '{}' n'a pas pu \u00eatre d\u00e9tach\u00e9 dans P\u00e9gase", new Object[]{child.getId(), content.getTitle(), e});
                    }
                }
            }
        }
        catch (ApiException e) {
            report.updateExportReport(ExportReport.ExportStatus.WARN, ExportReport.ProblemTypes.API_ERROR, content);
            this.getLogger().warn("Les liens avec les enfants de l'\u00e9l\u00e9ment '{}' n'ont pas pu \u00eatre trait\u00e9s car les enfants depuis P\u00e9gase n'ont pas pu \u00eatre r\u00e9cup\u00e9r\u00e9s.", (Object)content.getTitle(), (Object)e);
        }
        catch (Exception e) {
            throw new PegaseExportException("Erreur lors de l'attachement des enfants de l'\u00e9l\u00e9ment " + content.getTitle() + ".", e);
        }
    }

    private void _attachAllChildren(Content content, UUID pegaseParentId, Map<String, PegaseChildWithChildren> children, ExportReport report) throws UnknownDataException, AmetysRepositoryException, PegaseExportException, IOException {
        if (!children.isEmpty()) {
            for (PegaseChildWithChildren childToAttach : children.values()) {
                ChildrenToAttachForObjectRequest childrenToAttach = childToAttach.childrenToAttachRequest();
                this._attachAllChildren(childrenToAttach.parentContent(), childrenToAttach.parentId(), childrenToAttach.children(), report);
            }
            for (PegaseChildWithChildren child : children.values()) {
                Enfant pegaseChildToAttach = child.pegaseChild();
                try {
                    this._changeMutualiseIfNecessary(UUID.fromString(pegaseChildToAttach.getId()), pegaseParentId);
                    this._pegaseApiManager.getObjetsMaquetteApi().ajouterEnfant(this._structureCode, pegaseParentId, pegaseChildToAttach);
                }
                catch (ApiException ex) {
                    report.updateExportReport(ExportReport.ExportStatus.WARN, ExportReport.ProblemTypes.LINKS_MISSING, content);
                    this.getLogger().warn("Une erreur est survenue lors de l'attachement de l'enfant ({}) \u00e0 l'\u00e9l\u00e9ment ({}) dans P\u00e9gase", new Object[]{pegaseChildToAttach.getId(), content.getTitle(), ex});
                }
            }
        }
    }

    private ObjetMaquetteAndEtagIfExists _changeMutualiseIfNecessary(UUID childId, UUID parentID) throws IOException, ApiException {
        List chemins;
        int numberOfChemins;
        ObjetsMaquetteApi objetsMaquetteApi = this._pegaseApiManager.getObjetsMaquetteApi();
        ObjetMaquetteDetail childObjetMaquetteDetail = objetsMaquetteApi.lireObjetMaquette(this._structureCode, childId);
        String etag = this._getEtag(objetsMaquetteApi);
        ObjetMaquetteAndEtagIfExists objetMaquetteAndEtagIfExists = new ObjetMaquetteAndEtagIfExists(childObjetMaquetteDetail, etag);
        List contextes = childObjetMaquetteDetail.getContextes();
        if (!childObjetMaquetteDetail.getMutualise().booleanValue() && contextes.size() == 1 && (numberOfChemins = (chemins = ((Contexte)contextes.get(0)).getChemin()).size()) > 1 && !parentID.equals(chemins.get(numberOfChemins - 1))) {
            return this._makeHierarchyMutualised(objetMaquetteAndEtagIfExists);
        }
        return objetMaquetteAndEtagIfExists;
    }

    private ObjetMaquetteAndEtagIfExists _makeHierarchyMutualised(ObjetMaquetteAndEtagIfExists objetMaquetteAndEtagIfExists) throws ApiException, IOException {
        ObjetMaquetteDetail objetMaquetteDetail = objetMaquetteAndEtagIfExists.objetMaquetteDetail();
        ObjetsMaquetteApi objetsMaquetteApi = null;
        if (objetMaquetteDetail.getEnfants().size() != 0) {
            MaquetteStructure structureMaquetteParent = this._pegaseApiManager.getMaquettesApi().lireStructureMaquette(this._structureCode, objetMaquetteDetail.getId());
            objetsMaquetteApi = this._pegaseApiManager.getObjetsMaquetteApi();
            ObjetMaquetteStructure racine = structureMaquetteParent.getRacine();
            List children = racine.getEnfants();
            for (EnfantsStructure child : children) {
                ObjetMaquetteDetail childObjetMaquette = objetsMaquetteApi.lireObjetMaquette(this._structureCode, child.getObjetMaquette().getId());
                this._makeHierarchyMutualised(new ObjetMaquetteAndEtagIfExists(childObjetMaquette, this._getEtag(objetsMaquetteApi)));
            }
        } else {
            objetsMaquetteApi = this._pegaseApiManager.getObjetsMaquetteApi();
        }
        objetMaquetteDetail = objetsMaquetteApi.rendreMutualise(this._structureCode, objetMaquetteDetail.getId(), objetMaquetteAndEtagIfExists.etag());
        return new ObjetMaquetteAndEtagIfExists(objetMaquetteDetail, this._getEtag(objetsMaquetteApi));
    }

    private ObjetMaquetteDetail _updateObjetFormation(ObjetMaquetteAndEtagIfExists objetMaquetteAndEtagIfExists, Content content, String type, boolean parentMutualise, ExportReport report) throws PegaseExportException, IOException {
        DescripteursObjetFormationRequest descripteursObjetFormationRequest = new DescripteursObjetFormationRequest();
        String label = content.getTitle();
        descripteursObjetFormationRequest.setLibelle(StringUtils.truncate((String)label, (int)50));
        descripteursObjetFormationRequest.setLibelleLong(StringUtils.truncate((String)label, (int)150));
        descripteursObjetFormationRequest.setType(type);
        descripteursObjetFormationRequest.setEcts(this._getEctsFromContent(content));
        return this._updateObjetMaquette(objetMaquetteAndEtagIfExists, content, parentMutualise, (DescripteursObjetMaquetteRequest)descripteursObjetFormationRequest, report);
    }

    private ObjetMaquetteDetail _updateObjetMaquette(ObjetMaquetteAndEtagIfExists objetMaquetteAndEtagIfExists, Content content, boolean parentMutualise, DescripteursObjetMaquetteRequest descObjetMaquette, ExportReport report) throws PegaseExportException, IOException {
        try {
            ObjetMaquetteAndEtagIfExists objetMaquetteAndEtagIfExistsMutualised = objetMaquetteAndEtagIfExists;
            if (parentMutualise) {
                objetMaquetteAndEtagIfExistsMutualised = this._makeHierarchyMutualised(objetMaquetteAndEtagIfExists);
            }
            ObjetMaquetteDetail objetMaquetteDetailFound = objetMaquetteAndEtagIfExistsMutualised.objetMaquetteDetail();
            ObjetsMaquetteApi objetsMaquetteApi = this._pegaseApiManager.getObjetsMaquetteApi();
            ObjetMaquetteDetail objetMaquetteDetail = objetsMaquetteApi.modifierDescripteursObjetMaquette(this._structureCode, objetMaquetteDetailFound.getId(), objetMaquetteAndEtagIfExistsMutualised.etag(), descObjetMaquette);
            return objetMaquetteDetail;
        }
        catch (ApiException e) {
            report.updateExportReport(ExportReport.ExportStatus.ERROR, ExportReport.ProblemTypes.ELEMENT_NOT_EXPORTED);
            throw new PegaseExportException("L'\u00e9l\u00e9ment " + content.getTitle() + " n'a pas pu \u00eatre export\u00e9e car sa modification dans P\u00e9gase a pos\u00e9 un probl\u00e8me", e);
        }
    }

    private ObjetMaquetteDetail _createObjetFormation(Content content, String type, boolean parentMutualise, ExportReport report) throws PegaseExportException {
        DescripteursObjetFormationRequest descripteursObjetFormationRequest = new DescripteursObjetFormationRequest();
        descripteursObjetFormationRequest.setType(type);
        descripteursObjetFormationRequest.setEcts(this._getEctsFromContent(content));
        CreerObjetFormationRequest creerObjetFormationRequest = new CreerObjetFormationRequest();
        return this._createObjetMaquette(content, TypeObjetMaquette.OBJET_FORMATION, parentMutualise, (DescripteursObjetMaquetteRequest)descripteursObjetFormationRequest, (CreerObjetMaquetteRequest)creerObjetFormationRequest, report);
    }

    private ObjetMaquetteDetail _createObjetMaquette(Content content, TypeObjetMaquette typeObjetMaquette, boolean parentMutualise, DescripteursObjetMaquetteRequest descripteursObjetMaquetteRequest, CreerObjetMaquetteRequest creerObjetMaquetteRequest, ExportReport report) throws PegaseExportException {
        try {
            ObjetsMaquetteApi objetsMaquetteApi = this._pegaseApiManager.getObjetsMaquetteApi();
            this._initCreerObjetMaquetteRequest(creerObjetMaquetteRequest, typeObjetMaquette, parentMutualise, content);
            String label = content.getTitle();
            descripteursObjetMaquetteRequest.setLibelle(StringUtils.truncate((String)label, (int)50));
            descripteursObjetMaquetteRequest.setLibelleLong(StringUtils.truncate((String)label, (int)150));
            creerObjetMaquetteRequest.setDescripteursObjetMaquette(descripteursObjetMaquetteRequest);
            ObjetMaquetteDetail objetMaquetteDetail = objetsMaquetteApi.creerObjetMaquette(this._structureCode, creerObjetMaquetteRequest);
            return objetMaquetteDetail;
        }
        catch (IOException e) {
            report.updateExportReport(ExportReport.ExportStatus.ERROR, ExportReport.ProblemTypes.API_ERROR);
            throw new PegaseExportException("Une erreur est survenue lors de la cr\u00e9ation de l'objet P\u00e9gase", e);
        }
        catch (ApiException e) {
            report.updateExportReport(ExportReport.ExportStatus.ERROR, ExportReport.ProblemTypes.ELEMENT_NOT_EXPORTED);
            throw new PegaseExportException("L'\u00e9l\u00e9ment " + content.getTitle() + " n'a pas pu \u00eatre export\u00e9 d\u00fb \u00e0 un probl\u00e8me rencontr\u00e9 avec P\u00e9gase", e);
        }
    }

    private PlageDeChoix _buildPlageDeChoix(CourseList courseList) {
        PlageDeChoix plageDeChoix = new PlageDeChoix();
        Long min = (Long)courseList.getValue("min", false, (Object)0L);
        plageDeChoix.setMin(Integer.valueOf(min.intValue()));
        Long max = (Long)courseList.getValue("max", false, (Object)min);
        plageDeChoix.setMax(Integer.valueOf(max.intValue()));
        return plageDeChoix;
    }

    static {
        __MANDATORY_ATTRIBUTES_BY_CONTENT_TYPE.put("org.ametys.plugins.odf.Content.program", Set.of("educationKind"));
        __MANDATORY_ATTRIBUTES_BY_CONTENT_TYPE.put("org.ametys.plugins.odf.Content.course", Set.of("courseType"));
    }

    protected record ObjetMaquetteAndEtagIfExists(ObjetMaquetteDetail objetMaquetteDetail, String etag) {
    }

    protected record PegaseChildWithChildren(Enfant pegaseChild, ChildrenToAttachForObjectRequest childrenToAttachRequest) {
    }

    protected record ChildrenToAttachForObjectRequest(Content parentContent, UUID parentId, Map<String, PegaseChildWithChildren> children) {
    }
}

