/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfsync.apogee;

import java.util.List;
import java.util.Map;

/**
 * Data access object to the remote DB Apogee
 */
public class ApogeePreviousYearsFieldsDAO extends AbstractApogeeDAO
{
    /** Avalon ROLE */
    public static final String ROLE = ApogeePreviousYearsFieldsDAO.class.getName();

    /**
     * Returns the number of students in a container for a given year
     * @param dataSourceId The id of data source. Can not be null.
     * @param sccParams the parameters values of the synchronizable collection
     * @param params The parameters for search criteria: Program ID
     * @return The number of students in the container for the given year
     */
    public List<Map<String, Object>> getYearNbStudents(String dataSourceId, Map<String, Object> sccParams, Map<String, Object> params)
    {
        return _executeSearch(dataSourceId, sccParams, params, "ApogeePreviousYears.getYearNbStudents");
    }
    
    /**
     * Returns the number of groups in a course part for a given year
     * @param dataSourceId The id of data source. Can not be null.
     * @param sccParams the parameters values of the synchronizable collection
     * @param params The parameters for search criteria: Program ID
     * @return The number of groups in the course part for the given year
     */
    public List<Map<String, Object>> getCoursePartGroups(String dataSourceId, Map<String, Object> sccParams, Map<String, Object> params)
    {
        return _executeSearch(dataSourceId, sccParams, params, "ApogeePreviousYears.getCoursePartGroups");
    }
}
