/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfweb.cart;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.ametys.core.cocoon.JSonReader;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.userpref.UserPreferencesException;
import org.ametys.plugins.odfweb.cart.ODFCartManager;
import org.ametys.web.WebHelper;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;

public class SaveODFCartAction
extends ServiceableAction {
    private ODFCartManager _cartManager;
    private CurrentUserProvider _currentUserProvider;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._cartManager = (ODFCartManager)((Object)smanager.lookup(ODFCartManager.ROLE));
        this._currentUserProvider = (CurrentUserProvider)smanager.lookup(CurrentUserProvider.ROLE);
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        String siteName = WebHelper.getSiteName((Request)request);
        UserIdentity owner = this._currentUserProvider.getUser();
        try {
            String[] itemIds = request.getParameter("itemIds").split(",");
            this._cartManager.setCartItems(owner, Arrays.asList(itemIds), siteName);
            result.put("success", true);
            result.put("items", this._cartManager.getCartItemIds(owner, siteName));
        }
        catch (UserPreferencesException e) {
            this.getLogger().error("Failed to save cart items for current user " + owner, (Throwable)e);
            result.put("success", false);
        }
        request.setAttribute(JSonReader.OBJECT_TO_READ, result);
        return EMPTY_MAP;
    }
}

