/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfweb.observation.solr;

import java.util.Map;
import javax.jcr.Repository;
import org.ametys.core.observation.Event;
import org.ametys.odf.course.Course;
import org.ametys.odf.program.AbstractProgram;
import org.ametys.odf.program.Program;
import org.ametys.odf.program.SubProgram;
import org.ametys.plugins.odfweb.observation.solr.AbstractSolrODFObserver;
import org.ametys.plugins.odfweb.repository.OdfPageHandler;
import org.ametys.plugins.odfweb.repository.ProgramPage;
import org.ametys.plugins.repository.provider.RequestAttributeWorkspaceSelector;
import org.ametys.web.repository.page.Page;
import org.ametys.web.site.SiteConfigurationExtensionPoint;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;

public class SolrContentValidatedPart1Observer
extends AbstractSolrODFObserver {
    protected SiteConfigurationExtensionPoint _siteConf;
    protected Repository _repository;
    protected OdfPageHandler _odfPageHandler;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._siteConf = (SiteConfigurationExtensionPoint)manager.lookup(SiteConfigurationExtensionPoint.ROLE);
        this._repository = (Repository)manager.lookup("javax.jcr.Repository");
        this._odfPageHandler = (OdfPageHandler)((Object)manager.lookup(OdfPageHandler.ROLE));
    }

    public boolean supports(Event event) {
        return event.getId().equals("content.validated");
    }

    @Override
    public int getPriority(Event event) {
        return 500;
    }

    @Override
    protected String _workspaceToUse() {
        return "live";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _updateIndex(Event event, Map<String, Object> transientVars, Page odfRootPage, Program program, SubProgram subProgram, Course course) throws Exception {
        boolean isValid;
        Page liveOdfRootPage = (Page)this._resolver.resolveById(odfRootPage.getId());
        Request request = ContextHelper.getRequest((Context)this._context);
        String currentWsp = RequestAttributeWorkspaceSelector.getForcedWorkspace((Request)request);
        try {
            RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)"default");
            isValid = this._odfPageHandler.isValidRestriction(liveOdfRootPage, program);
        }
        finally {
            RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)currentWsp);
        }
        String programId = program.getId();
        if (isValid || !this._resolver.hasAmetysObjectForId(programId)) {
            return;
        }
        Program liveProgram = (Program)this._resolver.resolveById(programId);
        ProgramPage liveAbstractProgramPage = null;
        if (subProgram != null) {
            SubProgram liveSubProgram = (SubProgram)this._resolver.resolveById(subProgram.getId());
            liveAbstractProgramPage = this._odfPageResolver.getSubProgramPage(liveOdfRootPage, liveSubProgram, (AbstractProgram)liveProgram);
        } else {
            liveAbstractProgramPage = this._odfPageResolver.getProgramPage(liveOdfRootPage, liveProgram);
        }
        if (liveAbstractProgramPage != null) {
            String abstractProgramPageId = liveAbstractProgramPage.getId();
            this.getLogger().info("Removing Solr page document with id: {}", (Object)abstractProgramPageId);
            this._solrPageIndexer.unindexPage(abstractProgramPageId, "live", true, true);
        }
    }
}

