/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfweb.restrictions;

import java.util.HashMap;
import java.util.Map;
import org.ametys.plugins.odfweb.restrictions.OdfProgramRestriction;
import org.ametys.plugins.odfweb.restrictions.OdfProgramRestrictionManager;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.Enumerator;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang.StringUtils;

public class OrgProgramRestrictionEnumerator
implements Enumerator<String>,
Serviceable,
Configurable {
    protected OdfProgramRestrictionManager _odfProgramRestrictionManager;
    protected boolean _mandatory;

    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration mandatoryConf = configuration.getChild("enumeration").getChild("custom-enumerator").getChild("mandatory", false);
        this._mandatory = mandatoryConf != null ? mandatoryConf.getValueAsBoolean(true) : false;
    }

    public void service(ServiceManager smanager) throws ServiceException {
        this._odfProgramRestrictionManager = (OdfProgramRestrictionManager)((Object)smanager.lookup(OdfProgramRestrictionManager.ROLE));
    }

    public Map<String, I18nizableText> getTypedEntries() throws Exception {
        HashMap<String, I18nizableText> entries = new HashMap<String, I18nizableText>();
        if (!this._mandatory) {
            entries.put("", new I18nizableText("plugin.odf-web", "PLUGINS_ODFWEB_NO_RESTRICTION"));
        }
        for (OdfProgramRestriction restriction : this._odfProgramRestrictionManager.getRestrictions().values()) {
            entries.put(restriction.getId(), restriction.getLabel());
        }
        return entries;
    }

    public I18nizableText getEntry(String value) throws Exception {
        I18nizableText entry = null;
        if (StringUtils.isEmpty((String)value)) {
            entry = new I18nizableText("plugin.odf-web", "PLUGINS_ODFWEB_NO_RESTRICTION");
        } else {
            OdfProgramRestriction restriction = this._odfProgramRestrictionManager.getRestrictions().get(value);
            if (restriction != null) {
                entry = restriction.getLabel();
            }
        }
        return entry;
    }
}

