/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfweb.repository;

import java.util.NoSuchElementException;

import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectIterator;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.virtual.AbstractConfigurableVirtualPage;
import org.ametys.web.repository.page.virtual.VirtualPageConfiguration;

/**
 * Common class for ODF virtual pages
 * @param <T> The type of factory to use
 *
 */
public abstract class AbstractOdfPage<T extends AbstractOdfPageFactory> extends AbstractConfigurableVirtualPage<T>
{
    /**
     * The constructor of abstract odf pages
     * @param root the odf root page.
     * @param configuration The abstract virtual page configuration
     * @param scheme The scheme
     * @param factory The factory
     */
    public AbstractOdfPage(Page root, VirtualPageConfiguration configuration, String scheme, T factory)
    {
        super(root, configuration, scheme, factory);
    }
    
    @SuppressWarnings("unchecked")
    @Override
    public AmetysObjectIterable<? extends AmetysObject> getChildren() throws AmetysRepositoryException
    {
        return getChildrenPages();
    }
    
    @Override
    public AmetysObjectIterable< ? extends Page> getChildrenPages(boolean includeInvisiblePages) throws AmetysRepositoryException
    {
        return getChildrenPages();
    }
    
    @Override
    public Page getChildPageAt(int index) throws UnknownAmetysObjectException, AmetysRepositoryException
    {
        if (index < 0)
        {
            throw new AmetysRepositoryException("Child page index cannot be negative");
        }
        
        AmetysObjectIterator<? extends Page> childPages = getChildrenPages().iterator();
        
        try
        {
            childPages.skip(index);
            return childPages.next();
        }
        catch (NoSuchElementException e)
        {
            throw new UnknownAmetysObjectException("There's no child page at index " + index + " for page " + this.getId());
        }
    }
}
