/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfweb.schedulable;

import org.quartz.JobExecutionContext;

import org.ametys.core.schedule.progression.ContainerProgressionTracker;
import org.ametys.web.WebConstants;

/**
 * This scheduler launches a Solr indexation on programs and subprograms to compute the skills indexing field
 * See {@link org.ametys.odf.schedulable.ComputeProgramSkillsSchedulable}
 */
public class ComputeProgramSkillsSchedulable extends org.ametys.odf.schedulable.ComputeProgramSkillsSchedulable
{
    @Override
    public void execute(JobExecutionContext context, ContainerProgressionTracker progressionTracker) throws Exception
    {
        super.execute(context, progressionTracker);
        
        doReindex(context, WebConstants.LIVE_WORKSPACE);
    }
}
