/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfweb.service.search.criterion;

import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.ametys.cms.content.ContentHelper;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.cms.search.ui.model.SearchUICriterion;
import org.ametys.core.util.I18nUtils;
import org.ametys.core.util.LambdaUtils;
import org.ametys.plugins.odfweb.service.search.helper.DegreeUniversityHelper;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.parameter.Validator;
import org.ametys.web.frontoffice.search.metamodel.Searchable;
import org.ametys.web.frontoffice.search.metamodel.impl.ContentAttributeContentSearchCriterionDefinition;
import org.apache.commons.lang3.tuple.Pair;

public class DegreeUniversityAttributeContentSearchCriterionDefinition
extends ContentAttributeContentSearchCriterionDefinition {
    public static final String ATTRIBUTE_DEGREE_TYPE = "type";
    public static final String ATTRIBUTE_DEGREE_TYPE_UNIVERSITY_VALUE = "UNIVERSITY";
    public static final String DEGREE_SEARCH_CRITERION_ID = "ProgramSearchable$indexingField$org.ametys.plugins.odf.Content.program$degree";
    public static final String DEGREE_UNIVERSITY_SEARCH_CRITERION_ID = "ProgramSearchable$indexingField$org.ametys.plugins.odf.Content.program$degree$University";
    public static final String SEARCH_CRITERION_ALL_DU_VALUE = "_Ametys_Degree_All_University";
    protected I18nUtils _i18nUtils;
    protected DegreeUniversityHelper _degreeUniversityHelper;

    public DegreeUniversityAttributeContentSearchCriterionDefinition(String pluginName, Optional<Searchable> searchable, SearchUICriterion criterion, Optional<ContentType> contentType, Optional<Validator> validator, AmetysObjectResolver resolver, ContentTypeExtensionPoint contentTypeEP, ContentHelper contentHelper, I18nUtils i18nUtils, DegreeUniversityHelper degreeUniversityHelper) {
        super(DEGREE_UNIVERSITY_SEARCH_CRITERION_ID, pluginName, searchable, criterion, contentType, validator, resolver, contentTypeEP, contentHelper);
        this._i18nUtils = i18nUtils;
        this._degreeUniversityHelper = degreeUniversityHelper;
        this.setLabel(new I18nizableText("plugin.odf-web", "PLUGINS_ODFWEB_SEARCH_CRITERION_DEGREE_UNIVERSITY_LABEL"));
    }

    public Map<Object, I18nizableText> getEntries(String language) {
        List contentsAsPair = this._degreeUniversityHelper.getDegrees(false).stream().map(content -> Pair.of((Object)content.getId(), (Object)content.getTitle(new Locale(language)))).collect(Collectors.toList());
        if (!this._degreeUniversityHelper.getDegrees(true).isEmpty()) {
            I18nizableText criterionAllDULabel = new I18nizableText("plugin.odf-web", "PLUGINS_ODFWEB_SEARCH_CRITERION_DEGREE_UNIVERSITY_FIELD_ALL");
            contentsAsPair.add(Pair.of((Object)SEARCH_CRITERION_ALL_DU_VALUE, (Object)this._i18nUtils.translate((I18nizable)criterionAllDULabel, language)));
        }
        return (Map)contentsAsPair.stream().sorted(Comparator.comparing(Pair::getRight)).collect(LambdaUtils.Collectors.toLinkedHashMap(Pair::getLeft, pair -> new I18nizableText((String)pair.getRight())));
    }

    public Long getOrder(String contentId) {
        if (SEARCH_CRITERION_ALL_DU_VALUE.equals(contentId)) {
            return this._degreeUniversityHelper.getDegrees(true).stream().map(c -> (Long)c.getValue("order")).filter(l -> l != null).min(Long::compare).orElse(null);
        }
        return super.getOrder(contentId);
    }
}

