/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfweb.repository;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.ametys.cms.repository.Content;
import org.ametys.core.cache.AbstractCacheManager;
import org.ametys.core.cache.Cache;
import org.ametys.odf.ODFHelper;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.course.Course;
import org.ametys.odf.courselist.CourseList;
import org.ametys.odf.program.AbstractProgram;
import org.ametys.odf.program.Program;
import org.ametys.odf.program.ProgramPart;
import org.ametys.odf.program.SubProgram;
import org.ametys.plugins.core.impl.cache.AbstractCacheKey;
import org.ametys.plugins.odfweb.repository.CoursePage;
import org.ametys.plugins.odfweb.repository.OdfPageHandler;
import org.ametys.plugins.odfweb.repository.ProgramPage;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.repository.page.Page;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;

public class OdfPageResolver
extends AbstractLogEnabled
implements Component,
Serviceable,
Initializable {
    public static final String ROLE = OdfPageResolver.class.getName();
    private static final String __PATH_IN_SITEMAP_CACHE = OdfPageResolver.class.getName() + "$pathInSitemap";
    private static final String __LEVELS_PATH_CACHE = OdfPageResolver.class.getName() + "$levelsPath";
    protected AmetysObjectResolver _ametysResolver;
    protected OdfPageHandler _odfPageHandler;
    protected ODFHelper _odfHelper;
    protected AbstractCacheManager _cacheManager;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this._ametysResolver = (AmetysObjectResolver)serviceManager.lookup(AmetysObjectResolver.ROLE);
        this._odfPageHandler = (OdfPageHandler)((Object)serviceManager.lookup(OdfPageHandler.ROLE));
        this._odfHelper = (ODFHelper)serviceManager.lookup(ODFHelper.ROLE);
        this._cacheManager = (AbstractCacheManager)serviceManager.lookup(AbstractCacheManager.ROLE);
    }

    public void initialize() throws Exception {
        this._cacheManager.createRequestCache(__PATH_IN_SITEMAP_CACHE, new I18nizableText("plugin.odf-web", "PLUGINS_ODF_WEB_CACHE_PATH_IN_SITEMAP_LABEL"), new I18nizableText("plugin.odf-web", "PLUGINS_ODF_WEB_CACHE_PATH_IN_SITEMAP_DESCRIPTION"), false);
        this._cacheManager.createRequestCache(__LEVELS_PATH_CACHE, new I18nizableText("plugin.odf-web", "PLUGINS_ODF_WEB_CACHE_LEVELS_PATH_LABEL"), new I18nizableText("plugin.odf-web", "PLUGINS_ODF_WEB_CACHE_LEVELS_PATH_DESCRIPTION"), false);
    }

    public Set<Page> getReferencingPages(ProgramItem programItem) {
        return this.getReferencingPages(programItem, null, ((Content)programItem).getLanguage());
    }

    public Set<Page> getReferencingPages(ProgramItem programItem, String siteName, String lang) {
        HashSet<Page> refPages = new HashSet<Page>();
        Set<Page> odfRootPages = this._odfPageHandler.getOdfRootPages(siteName, lang);
        for (Page rootPage : odfRootPages) {
            if (programItem instanceof Program) {
                ProgramPage programPage = this.getProgramPage(rootPage, (Program)programItem);
                if (programPage == null) continue;
                refPages.add((Page)programPage);
                continue;
            }
            if (programItem instanceof SubProgram) {
                Set parentPrograms = this._odfHelper.getParentPrograms(programItem);
                for (Program parentProgram : parentPrograms) {
                    ProgramPage subProgramPage = this.getSubProgramPage(rootPage, (SubProgram)programItem, (AbstractProgram)parentProgram);
                    if (subProgramPage == null) continue;
                    refPages.add((Page)subProgramPage);
                }
                continue;
            }
            if (!(programItem instanceof Course)) continue;
            List parentCourseLists = ((Course)programItem).getParentCourseLists();
            for (CourseList courseList : parentCourseLists) {
                List parentCourses = courseList.getParentCourses();
                for (Course parentCourse : parentCourses) {
                    CoursePage coursePage = this.getCoursePage(rootPage, (Course)programItem, parentCourse);
                    if (coursePage == null) continue;
                    refPages.add((Page)coursePage);
                }
                List<AbstractProgram> parentAbstractPrograms = this.getNearestAncestorAbstractPrograms((ProgramPart)courseList);
                for (AbstractProgram parentAbstractProgram : parentAbstractPrograms) {
                    CoursePage coursePage = this.getCoursePage(rootPage, (Course)programItem, parentAbstractProgram);
                    if (coursePage == null) continue;
                    refPages.add((Page)coursePage);
                }
            }
        }
        return refPages;
    }

    public ProgramPage getProgramPage(Program program) {
        return this.getProgramPage(program, null);
    }

    public ProgramPage getProgramPage(Program program, String siteName) {
        Page odfRootPage = this.getOdfRootPage(siteName, program.getLanguage(), program.getCatalog());
        if (odfRootPage == null) {
            return null;
        }
        return this.getProgramPage(odfRootPage, program);
    }

    public ProgramPage getProgramPage(Page odfRootPage, Program program) {
        String pageId = "program://_root?rootId=" + odfRootPage.getId() + "&programId=" + program.getId();
        try {
            return (ProgramPage)this._ametysResolver.resolveById(pageId);
        }
        catch (UnknownAmetysObjectException e) {
            return null;
        }
    }

    public ProgramPage getSubProgramPage(SubProgram subProgram, AbstractProgram parentProgram, String siteName) {
        Page odfRootPage = this.getOdfRootPage(siteName, subProgram.getLanguage(), subProgram.getCatalog());
        if (odfRootPage == null) {
            return null;
        }
        return this.getSubProgramPage(odfRootPage, subProgram, parentProgram);
    }

    public ProgramPage getSubProgramPage(Page odfRootPage, SubProgram subProgram, AbstractProgram parentAbstractProgram) {
        AbstractProgram parent = this.getNearestAncestorAbstractProgram((ProgramItem)subProgram, parentAbstractProgram);
        Program parentProgram = this.getParentProgram((ProgramItem)subProgram, parentAbstractProgram);
        if (parent == null || parentProgram == null) {
            return null;
        }
        String pageId = "program://" + this.getPathInProgram((ProgramItem)parent, (AbstractProgram)parentProgram) + "?rootId=" + odfRootPage.getId() + "&programId=" + subProgram.getId() + "&parentId=" + parentProgram.getId();
        try {
            return (ProgramPage)this._ametysResolver.resolveById(pageId);
        }
        catch (UnknownAmetysObjectException e) {
            return null;
        }
    }

    public CoursePage getCoursePage(Course course, AbstractProgram parentProgram, String siteName) {
        String catalog = course.getCatalog();
        Page odfRootPage = this.getOdfRootPage(siteName, course.getLanguage(), catalog);
        if (odfRootPage == null) {
            return null;
        }
        return this.getCoursePage(odfRootPage, course, parentProgram);
    }

    public CoursePage getCoursePage(Page odfRootPage, Course course, AbstractProgram parentAbstractProgram) {
        Object parent = null;
        Course parentCourse = this.getNearestAncestorCourse(course, parentAbstractProgram);
        parent = parentCourse != null ? parentCourse : this.getNearestAncestorAbstractProgram((ProgramItem)course, parentAbstractProgram);
        Program parentProgram = this.getParentProgram((ProgramItem)course, parentAbstractProgram);
        if (parent == null || parentProgram == null) {
            return null;
        }
        if (!this._odfPageHandler.isValidRestriction(odfRootPage, parentProgram)) {
            return null;
        }
        String pageId = "course://" + this.getPathInProgram((ProgramItem)parent, (AbstractProgram)parentProgram) + "?rootId=" + odfRootPage.getId() + "&courseId=" + course.getId() + "&programId=" + parentProgram.getId();
        try {
            return (CoursePage)this._ametysResolver.resolveById(pageId);
        }
        catch (UnknownAmetysObjectException e) {
            return null;
        }
    }

    public CoursePage getCoursePage(Course course, Course parentCourse, String siteName) {
        String catalog = course.getCatalog();
        Page odfRootPage = this.getOdfRootPage(siteName, course.getLanguage(), catalog);
        if (odfRootPage == null) {
            return null;
        }
        return this.getCoursePage(odfRootPage, course, parentCourse);
    }

    public CoursePage getCoursePage(Page odfRootPage, Course course, Course parentCourse) {
        AbstractProgram parent = this.getNearestAncestorAbstractProgram((ProgramItem)parentCourse, null);
        Program parentProgram = this.getParentProgram((ProgramItem)parentCourse, null);
        if (parent == null || parentProgram == null) {
            return null;
        }
        if (!this._odfPageHandler.isValidRestriction(odfRootPage, parentProgram)) {
            return null;
        }
        String pageId = "course://" + this.getPathInProgram((ProgramItem)parentCourse, (AbstractProgram)parentProgram) + "?rootId=" + odfRootPage.getId() + "&courseId=" + course.getId() + "&programId=" + parentProgram.getId();
        try {
            return (CoursePage)this._ametysResolver.resolveById(pageId);
        }
        catch (UnknownAmetysObjectException e) {
            return null;
        }
    }

    public Page getOdfRootPage(String siteName, String language, String catalog) {
        Page odfRootPage = null;
        if (StringUtils.isNotEmpty((CharSequence)siteName)) {
            odfRootPage = this._odfPageHandler.getOdfRootPage(siteName, language, catalog);
        }
        if (odfRootPage == null) {
            String odfSiteName = (String)Config.getInstance().getValue("odf.web.site.name");
            odfRootPage = this._odfPageHandler.getOdfRootPage(odfSiteName, language, catalog);
        }
        return odfRootPage;
    }

    public String getPathInProgram(ProgramItem programItem, AbstractProgram parentProgram) {
        Cache cache = this._cacheManager.get(__PATH_IN_SITEMAP_CACHE);
        return (String)cache.get((Object)PathInProgramCacheKey.of(programItem.getId(), parentProgram != null ? parentProgram.getId() : "__NOPARENT"), item -> {
            String parentPath;
            if (programItem instanceof Program || programItem.equals(parentProgram)) {
                return this._odfPageHandler.getPageName(programItem);
            }
            ArrayList<String> paths = new ArrayList<String>();
            ProgramItem parent = this._odfHelper.getParentProgramItem(programItem, parentProgram);
            if (parent != null && (parentPath = this.getPathInProgram(parent, parentProgram)) != null) {
                paths.add(parentPath);
            }
            if (programItem instanceof AbstractProgram || programItem instanceof Course) {
                paths.add(this._odfPageHandler.getPageName(programItem));
            }
            return paths.isEmpty() ? null : StringUtils.join(paths, (String)"/");
        });
    }

    public Program getParentProgram(ProgramItem programItem, AbstractProgram parentProgram) {
        AbstractProgram parent = parentProgram;
        ProgramItem parentItem = this._odfHelper.getParentProgramItem(programItem, parentProgram);
        while (parentItem != null && !(parentItem instanceof Program)) {
            if (parent != null && parentItem.equals(parent)) {
                parent = null;
            }
            parentItem = this._odfHelper.getParentProgramItem(parentItem, parent);
        }
        return parentItem != null ? (Program)parentItem : null;
    }

    public List<AbstractProgram> getNearestAncestorAbstractPrograms(ProgramPart programPart) {
        ArrayList<AbstractProgram> ancestors = new ArrayList<AbstractProgram>();
        List parents = programPart.getProgramPartParents();
        for (ProgramPart parent : parents) {
            if (parent instanceof AbstractProgram) {
                ancestors.add((AbstractProgram)parent);
                continue;
            }
            ancestors.addAll(this.getNearestAncestorAbstractPrograms(parent));
        }
        return ancestors;
    }

    public AbstractProgram getNearestAncestorAbstractProgram(ProgramItem programItem, AbstractProgram parentProgram) {
        ProgramItem parentItem = this._odfHelper.getParentProgramItem(programItem, parentProgram);
        while (parentItem != null && !(parentItem instanceof AbstractProgram)) {
            parentItem = this._odfHelper.getParentProgramItem(parentItem, parentProgram);
        }
        return parentItem != null ? (AbstractProgram)parentItem : null;
    }

    public Course getNearestAncestorCourse(Course course, AbstractProgram parentProgram) {
        ProgramItem parentItem = this._odfHelper.getParentProgramItem((ProgramItem)course, parentProgram);
        while (parentItem != null && !(parentItem instanceof Course) && !(parentItem instanceof AbstractProgram)) {
            parentItem = this._odfHelper.getParentProgramItem(parentItem, parentProgram);
        }
        return parentItem != null && parentItem instanceof Course ? (Course)parentItem : null;
    }

    public String getProgramItemPagePath(String siteName, String language, ProgramItem programItem, Program parentProgram) {
        String pathInProgram;
        String catalog = programItem.getCatalog();
        Cache cache = this._cacheManager.get(__LEVELS_PATH_CACHE);
        String rootPath = (String)cache.get((Object)ODFLevelsPathCacheKey.of(siteName, language, catalog, parentProgram.getId()), key -> this._getLevelsPath(siteName, language, programItem.getCatalog(), parentProgram));
        if (rootPath != null && (pathInProgram = this.getPathInProgram(programItem, (AbstractProgram)parentProgram)) != null) {
            return rootPath + pathInProgram;
        }
        return "";
    }

    private String _getLevelsPath(String siteName, String language, String catalog, Program parentProgram) {
        Page rootPage = this._odfPageHandler.getOdfRootPage(siteName, language, catalog);
        StringBuilder sb = new StringBuilder().append(rootPage.getSitemapName()).append('/').append(rootPage.getPathInSitemap()).append('/');
        String level1 = this._odfPageHandler.getLevel1PageName(rootPage, parentProgram);
        if (StringUtils.isNotEmpty((CharSequence)level1)) {
            sb.append(level1).append('/');
        }
        String level2 = this._odfPageHandler.getLevel2PageName(rootPage, parentProgram);
        if (StringUtils.isNotEmpty((CharSequence)level1)) {
            sb.append(level2).append('/');
        }
        return sb.toString();
    }

    private static class PathInProgramCacheKey
    extends AbstractCacheKey {
        protected PathInProgramCacheKey(String programItemId, String parentProgramId) {
            super(new Object[]{programItemId, parentProgramId});
        }

        public static PathInProgramCacheKey of(String programItemId, String parentProgramId) {
            return new PathInProgramCacheKey(programItemId, parentProgramId);
        }
    }

    private static class ODFLevelsPathCacheKey
    extends AbstractCacheKey {
        protected ODFLevelsPathCacheKey(String site, String lang, String catalog, String parentProgramId) {
            super(new Object[]{site, lang, catalog, parentProgramId});
        }

        public static ODFLevelsPathCacheKey of(String site, String lang, String catalog, String parentProgramId) {
            return new ODFLevelsPathCacheKey(site, lang, catalog, parentProgramId);
        }
    }
}

