/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfweb.service.search;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.ametys.cms.repository.Content;
import org.ametys.cms.search.advanced.AbstractTreeNode;
import org.ametys.cms.search.advanced.TreeLeaf;
import org.ametys.cms.search.query.ContentTypeQuery;
import org.ametys.cms.search.query.DocumentTypeQuery;
import org.ametys.cms.search.query.Query;
import org.ametys.cms.search.query.StringQuery;
import org.ametys.cms.search.solr.SearcherFactory;
import org.ametys.core.util.URIUtils;
import org.ametys.odf.course.Course;
import org.ametys.odf.program.AbstractProgram;
import org.ametys.odf.program.Program;
import org.ametys.odf.program.SubProgram;
import org.ametys.plugins.odfweb.repository.AbstractProgramItemPage;
import org.ametys.plugins.odfweb.repository.OdfPageResolver;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.web.frontoffice.search.fast.AbstractAutocompletionSearchServiceAction;
import org.ametys.web.frontoffice.search.instance.SearchServiceInstance;
import org.ametys.web.frontoffice.search.instance.model.FOSearchCriterion;
import org.ametys.web.frontoffice.search.instance.model.FOSearchCriterionMode;
import org.ametys.web.frontoffice.search.instance.model.RightCheckingMode;
import org.ametys.web.renderingcontext.RenderingContext;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.site.Site;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang.StringUtils;

public class ProgramItemAutocompletionSearchServiceAction
extends AbstractAutocompletionSearchServiceAction {
    protected OdfPageResolver _odfPageResolver;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._odfPageResolver = (OdfPageResolver)((Object)serviceManager.lookup(OdfPageResolver.ROLE));
    }

    protected Map<String, Object> _searchAmetysObject(Site site, String zoneItemId, String lang, String escapedQuery, int limit, RightCheckingMode rightCheckingMode) throws Exception {
        Map results = super._searchAmetysObject(site, zoneItemId, lang, escapedQuery, limit, rightCheckingMode);
        AmetysObjectIterable<Content> skillResults = this._getSkills(escapedQuery, lang, limit, rightCheckingMode);
        List skills = skillResults.stream().map(this::_getContentHit).collect(Collectors.toList());
        results.put("skills", skills);
        return results;
    }

    protected void setHitsInResults(Map<String, Object> results, AmetysObjectIterable<AmetysObject> searchHits, Site site, String zoneItemId, String lang) {
        List<String> catalogNames = this._getCatalogNames(zoneItemId);
        Page odfRootPage = catalogNames.size() == 1 ? this._odfPageResolver.getOdfRootPage(site.getName(), lang, catalogNames.get(0)) : null;
        List pages = searchHits.stream().filter(Content.class::isInstance).map(Content.class::cast).map(c -> this._getPageHit((Content)c, site.getName(), odfRootPage)).filter(Objects::nonNull).collect(Collectors.toList());
        results.put("pages", pages);
    }

    protected List<String> _getCatalogNames(String zoneItemId) {
        if (StringUtils.isNotEmpty((String)zoneItemId)) {
            SearchServiceInstance serviceInstance = this._searchServiceInstanceManager.get(zoneItemId);
            List<String> catalogValues = serviceInstance.getCriterionTree().map(AbstractTreeNode::getFlatLeaves).orElseGet(Collections::emptyList).stream().map(TreeLeaf::getValue).filter(c -> c.getMode() == FOSearchCriterionMode.STATIC).filter(c -> StringUtils.endsWith((String)c.getCriterionDefinition().getId(), (String)"$indexingField$org.ametys.plugins.odf.Content.programItem$catalog")).map(FOSearchCriterion::getStaticValue).flatMap(Optional::stream).map(String.class::cast).collect(Collectors.toList());
            return catalogValues;
        }
        return List.of();
    }

    protected AmetysObjectIterable<Content> _getSkills(String escapedQuery, String lang, int limit, RightCheckingMode rightCheckingMode) throws Exception {
        SearcherFactory.Searcher searcher = this._searcherFactory.create().withQuery((Query)new StringQuery("title", Query.Operator.SEARCH, escapedQuery, lang, true)).addFilterQuery((Query)new DocumentTypeQuery("content")).addFilterQuery((Query)new ContentTypeQuery(new String[]{"odf-enumeration.Skill"})).withLimits(0, limit);
        this._setRightCheckingMode(searcher, rightCheckingMode);
        return searcher.search();
    }

    protected Map<String, Object> _getPageHit(Content content, String siteName, Page odfRootPage) {
        AbstractProgramItemPage page = null;
        if (content instanceof Program) {
            page = odfRootPage != null ? this._odfPageResolver.getProgramPage(odfRootPage, (Program)content) : this._odfPageResolver.getProgramPage((Program)content, siteName);
        } else if (content instanceof SubProgram) {
            page = odfRootPage != null ? this._odfPageResolver.getSubProgramPage(odfRootPage, (SubProgram)content, null) : this._odfPageResolver.getSubProgramPage((SubProgram)content, null, siteName);
        } else if (content instanceof Course) {
            AbstractProgramItemPage abstractProgramItemPage = page = odfRootPage != null ? this._odfPageResolver.getCoursePage(odfRootPage, (Course)content, (AbstractProgram)null) : this._odfPageResolver.getCoursePage((Course)content, (AbstractProgram)null, siteName);
        }
        if (page != null) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("title", page.getTitle());
            RenderingContext context = this._renderingContextHandler.getRenderingContext();
            if (context != RenderingContext.BACK) {
                StringBuilder uri = new StringBuilder();
                uri.append(this._prefixHandler.getUriPrefix(siteName));
                uri.append("/");
                uri.append(page.getSitemapName() + "/" + page.getPathInSitemap() + ".html");
                result.put("url", URIUtils.encodePath((String)uri.toString()));
            } else {
                result.put("url", "javascript:(function(){parent.Ametys.tool.ToolsManager.openTool('uitool-page', {id:'" + page.getId() + "'});})()");
            }
            return result;
        }
        return null;
    }

    protected Map<String, Object> _getContentHit(Content content) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("title", content.getTitle());
        result.put("id", content.getId());
        return result;
    }
}

