/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfweb.cart;

import jakarta.mail.MessagingException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.ametys.cms.content.ContentHelper;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.cms.contenttype.ContentTypesHelper;
import org.ametys.cms.repository.Content;
import org.ametys.cms.transformation.xslt.ResolveURIComponent;
import org.ametys.core.ui.mail.StandardMailBodyHelper;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.userpref.UserPreferencesException;
import org.ametys.core.userpref.UserPreferencesManager;
import org.ametys.core.util.DateUtils;
import org.ametys.core.util.I18nUtils;
import org.ametys.core.util.IgnoreRootHandler;
import org.ametys.core.util.mail.SendMailHelper;
import org.ametys.odf.course.Course;
import org.ametys.odf.coursepart.CoursePart;
import org.ametys.odf.program.AbstractProgram;
import org.ametys.odf.program.Program;
import org.ametys.odf.program.SubProgram;
import org.ametys.plugins.odfweb.cart.ODFCartUserPreferencesStorage;
import org.ametys.plugins.odfweb.repository.OdfPageResolver;
import org.ametys.plugins.odfweb.repository.ProgramPage;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.provider.RequestAttributeWorkspaceSelector;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.renderingcontext.RenderingContext;
import org.ametys.web.renderingcontext.RenderingContextHandler;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.components.source.impl.SitemapSource;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.SourceUtil;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ODFCartManager
extends AbstractLogEnabled
implements Serviceable,
Component,
Contextualizable {
    public static final String ROLE = ODFCartManager.class.getName();
    public static final String CART_USER_PREF_CONTENT_IDS = "cartOdfContentIds";
    public static final String SUBSCRIPTION_USER_PREF_CONTENT_IDS = "subscriptionOdfContentIds";
    private UserPreferencesManager _userPrefManager;
    private AmetysObjectResolver _resolver;
    private SourceResolver _srcResolver;
    private OdfPageResolver _odfPageResolver;
    private ContentTypeExtensionPoint _cTypeEP;
    private ContentTypesHelper _cTypesHelper;
    private ODFCartUserPreferencesStorage _odfUserPrefStorage;
    private I18nUtils _i18nUtils;
    private UserManager _userManager;
    private SiteManager _siteManager;
    private RenderingContextHandler _renderingContextHandler;
    private CurrentUserProvider _currentUserProvider;
    private Context _context;
    private ContentHelper _contentHelper;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this._userPrefManager = (UserPreferencesManager)serviceManager.lookup(UserPreferencesManager.ROLE + ".FO");
        this._resolver = (AmetysObjectResolver)serviceManager.lookup(AmetysObjectResolver.ROLE);
        this._srcResolver = (SourceResolver)serviceManager.lookup(SourceResolver.ROLE);
        this._odfPageResolver = (OdfPageResolver)((Object)serviceManager.lookup(OdfPageResolver.ROLE));
        this._cTypeEP = (ContentTypeExtensionPoint)serviceManager.lookup(ContentTypeExtensionPoint.ROLE);
        this._cTypesHelper = (ContentTypesHelper)serviceManager.lookup(ContentTypesHelper.ROLE);
        this._contentHelper = (ContentHelper)serviceManager.lookup(ContentHelper.ROLE);
        this._odfUserPrefStorage = (ODFCartUserPreferencesStorage)((Object)serviceManager.lookup(ODFCartUserPreferencesStorage.ROLE));
        this._i18nUtils = (I18nUtils)serviceManager.lookup(I18nUtils.ROLE);
        this._userManager = (UserManager)serviceManager.lookup(UserManager.ROLE);
        this._siteManager = (SiteManager)serviceManager.lookup(SiteManager.ROLE);
        this._renderingContextHandler = (RenderingContextHandler)serviceManager.lookup(RenderingContextHandler.ROLE);
        this._currentUserProvider = (CurrentUserProvider)serviceManager.lookup(CurrentUserProvider.ROLE);
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public List<String> getCartItemIds(UserIdentity user, String siteName) throws UserPreferencesException {
        return this.getCartItemIds(user, siteName, CART_USER_PREF_CONTENT_IDS);
    }

    public List<String> getItemIdsWithSubscription(UserIdentity user, String siteName) throws UserPreferencesException {
        return this.getCartItemIds(user, siteName, SUBSCRIPTION_USER_PREF_CONTENT_IDS);
    }

    protected List<String> getCartItemIds(UserIdentity user, String siteName, String userPrefsId) throws UserPreferencesException {
        HashMap<String, String> contextVars = new HashMap<String, String>();
        contextVars.put("siteName", siteName);
        String contentIdsAsStr = this._userPrefManager.getUserPreferenceAsString(user, "/sites/" + siteName, contextVars, userPrefsId);
        if (StringUtils.isNotBlank((String)contentIdsAsStr)) {
            return Arrays.asList(StringUtils.split((String)contentIdsAsStr, (String)","));
        }
        return Collections.emptyList();
    }

    public List<ODFCartItem> getCartItems(UserIdentity owner, String siteName) throws UserPreferencesException {
        ArrayList<ODFCartItem> items = new ArrayList<ODFCartItem>();
        List<String> itemIds = this.getCartItemIds(owner, siteName);
        for (String itemId : itemIds) {
            ODFCartItem item = this.getCartItem(itemId);
            if (item != null) {
                items.add(item);
                continue;
            }
            this.getLogger().warn("The item with id '{}' stored in cart of user {} does not match an existing content anymore. It will be ignored", (Object)itemId, (Object)owner);
        }
        return items;
    }

    public List<ODFCartItem> getItemsWithSubscription(UserIdentity owner, String siteName) throws UserPreferencesException {
        ArrayList<ODFCartItem> items = new ArrayList<ODFCartItem>();
        List<String> itemIds = this.getItemIdsWithSubscription(owner, siteName);
        for (String itemId : itemIds) {
            ODFCartItem item = this.getCartItem(itemId);
            if (item != null) {
                items.add(item);
                continue;
            }
            this.getLogger().warn("The item with id '{}' stored in subscription of user {} does not match an existing content anymore. It will be ignored", (Object)itemId, (Object)owner);
        }
        return items;
    }

    public ODFCartItem getCartItem(String itemId) {
        int i = itemId.indexOf(59);
        String contentId = itemId;
        String parentId = null;
        if (i != -1) {
            contentId = itemId.substring(0, i);
            parentId = itemId.substring(i + 1);
        }
        try {
            return new ODFCartItem((Content)this._resolver.resolveById(contentId), parentId != null ? (Program)this._resolver.resolveById(parentId) : null);
        }
        catch (UnknownAmetysObjectException e) {
            return null;
        }
    }

    public void setCartItems(UserIdentity owner, List<String> itemIds, String siteName) throws UserPreferencesException {
        this.saveItemsInUserPreference(owner, itemIds, siteName, CART_USER_PREF_CONTENT_IDS);
    }

    public void setSubscription(UserIdentity owner, List<String> itemIds, String siteName) throws UserPreferencesException {
        this.saveItemsInUserPreference(owner, itemIds, siteName, SUBSCRIPTION_USER_PREF_CONTENT_IDS);
    }

    public void saveItemsInUserPreference(UserIdentity owner, List<String> itemIds, String siteName, String userPrefsId) throws UserPreferencesException {
        HashMap<String, String> contextVars = new HashMap<String, String>();
        contextVars.put("siteName", siteName);
        HashMap<String, String> preferences = new HashMap<String, String>();
        preferences.put(userPrefsId, StringUtils.join(itemIds, (String)","));
        this._odfUserPrefStorage.setUserPreferences(owner, "/sites/" + siteName, contextVars, preferences);
    }

    public boolean addCartItem(UserIdentity owner, String itemId, String siteName) throws UserPreferencesException {
        List<ODFCartItem> items = this.getCartItems(owner, siteName);
        ODFCartItem item = this.getCartItem(itemId);
        if (item == null) {
            this.getLogger().warn("Unknown item with id {}. It cannot be added to user cart", (Object)itemId);
            return false;
        }
        items.add(item);
        List<String> itemIds = items.stream().map(c -> c.getId()).collect(Collectors.toList());
        this.setCartItems(owner, itemIds, siteName);
        return true;
    }

    public boolean isSubscriber(UserIdentity owner, String itemId, String siteName) throws UserPreferencesException {
        List<String> subscriptions = this.getItemIdsWithSubscription(owner, siteName);
        return subscriptions.contains(itemId);
    }

    public boolean subscribe(UserIdentity owner, String itemId, String siteName) throws UserPreferencesException {
        List<ODFCartItem> items = this.getItemsWithSubscription(owner, siteName);
        ODFCartItem item = this.getCartItem(itemId);
        if (item == null) {
            this.getLogger().warn("Unknown item with id {}. It cannot be added to user subscriptions", (Object)itemId);
            return false;
        }
        items.add(item);
        List<String> itemIds = items.stream().map(c -> c.getId()).collect(Collectors.toList());
        this.setSubscription(owner, itemIds, siteName);
        return true;
    }

    public boolean unsubscribe(UserIdentity owner, String itemId, String siteName) throws UserPreferencesException {
        List<ODFCartItem> items = this.getItemsWithSubscription(owner, siteName);
        ODFCartItem item = this.getCartItem(itemId);
        if (item == null) {
            this.getLogger().warn("Unknown item with id {}. It cannot be remove from user subscriptions", (Object)itemId);
            return false;
        }
        items.remove(item);
        List<String> itemIds = items.stream().map(c -> c.getId()).collect(Collectors.toList());
        this.setSubscription(owner, itemIds, siteName);
        return true;
    }

    public Map<String, Object> shareCartItems(UserIdentity owner, List<String> itemIds, List<String> recipients, String siteName, String language, String message) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        User user = this._userManager.getUser(owner);
        String sender = user.getEmail();
        if (StringUtils.isEmpty((String)sender)) {
            this.getLogger().error("Cart's owner has no email, his ODF cart selection can not be shared");
            result.put("success", false);
            result.put("error", "no-owner-mail");
            return result;
        }
        List<ODFCartItem> items = itemIds.stream().map(i -> this.getCartItem((String)i)).filter(Objects::nonNull).collect(Collectors.toList());
        Site site = this._siteManager.getSite(siteName);
        HashMap<String, I18nizableText> i18nparam = new HashMap<String, I18nizableText>();
        i18nparam.put("siteTitle", new I18nizableText(site.getTitle()));
        I18nizableText i18nTextSubject = new I18nizableText("plugin.odf-web", "PLUGINS_ODFWEB_CART_SHARE_MAIL_SUBJECT", i18nparam);
        String subject = this._i18nUtils.translate((I18nizable)i18nTextSubject, language);
        String htmlBody = null;
        String textBody = null;
        try {
            htmlBody = this.getMailBody(items, message, owner, siteName, language, false);
            textBody = this.getMailBody(items, message, owner, siteName, language, true);
        }
        catch (IOException e) {
            this.getLogger().error("Fail to get mail body to share ODF cart selection", (Throwable)e);
            result.put("success", false);
            return result;
        }
        ArrayList<String> mailsInError = new ArrayList<String>();
        for (String recipient : recipients) {
            try {
                String prettyHTMLBody;
                try {
                    prettyHTMLBody = StandardMailBodyHelper.newHTMLBody().withLanguage(language).withTitle(subject).withMessage(htmlBody.replaceAll("\n", "")).withLink(site.getUrl(), new I18nizableText("plugin.odf-web", "PLUGINS_ODFWEB_CART_SHARE_MAIL_HTML_BODY_SITE_LINK")).build();
                }
                catch (IOException e) {
                    this.getLogger().warn("Failed to build wrapped HTML body for ODF cart. Fallback to no wrapped mail", (Throwable)e);
                    prettyHTMLBody = htmlBody;
                }
                SendMailHelper.newMail().withSubject(subject).withHTMLBody(prettyHTMLBody).withTextBody(textBody).withRecipient(recipient).withSender(sender).sendMail();
            }
            catch (MessagingException | IOException e) {
                this.getLogger().error("Failed to send ODF cart selection to '" + recipient + "'", e);
                mailsInError.add(recipient);
            }
        }
        if (mailsInError.size() > 0) {
            result.put("success", false);
            result.put("mailsInError", mailsInError);
        } else {
            result.put("success", true);
        }
        return result;
    }

    protected String getMailSubject(String siteName, String language) {
        Site site = this._siteManager.getSite(siteName);
        HashMap<String, I18nizableText> i18nparam = new HashMap<String, I18nizableText>();
        i18nparam.put("siteTitle", new I18nizableText(site.getTitle()));
        I18nizableText i18nTextSubject = new I18nizableText("plugin.odf-web", "PLUGINS_ODFWEB_CART_SHARE_MAIL_SUBJECT", i18nparam);
        return this._i18nUtils.translate((I18nizable)i18nTextSubject, language);
    }

    /*
     * Loose catch block
     */
    protected String getMailBody(List<ODFCartItem> items, String message, UserIdentity owner, String siteName, String language, boolean text) throws IOException {
        String string;
        InputStream is;
        Source source;
        RenderingContext currentContext;
        String currentWorkspace;
        Request request;
        block10: {
            request = ContextHelper.getRequest((Context)this._context);
            currentWorkspace = RequestAttributeWorkspaceSelector.getForcedWorkspace((Request)request);
            currentContext = this._renderingContextHandler.getRenderingContext();
            source = null;
            RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)"live");
            this._renderingContextHandler.setRenderingContext(RenderingContext.FRONT);
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("items", items);
            parameters.put("message", message);
            parameters.put("owner", owner);
            parameters.put("siteName", siteName);
            parameters.put("lang", language);
            parameters.put("format", text ? "text" : "html");
            source = this._srcResolver.resolveURI("cocoon://_plugins/odf-web/cart/mail/body", null, parameters);
            is = source.getInputStream();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            SourceUtil.copy((InputStream)is, (OutputStream)bos);
            string = bos.toString("UTF-8");
            if (is == null) break block10;
            is.close();
        }
        RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)currentWorkspace);
        this._renderingContextHandler.setRenderingContext(currentContext);
        if (source != null) {
            this._srcResolver.release(source);
        }
        return string;
        {
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)currentWorkspace);
                    this._renderingContextHandler.setRenderingContext(currentContext);
                    if (source != null) {
                        this._srcResolver.release(source);
                    }
                    throw throwable3;
                }
            }
        }
    }

    public void saxCartItems(ContentHandler contentHandler, UserIdentity owner, String siteName) throws SAXException, IOException, UserPreferencesException {
        List<ODFCartItem> items = this.getCartItems(owner, siteName);
        XMLUtils.startElement((ContentHandler)contentHandler, (String)"items");
        for (ODFCartItem item : items) {
            this.saxCartItem(contentHandler, item, siteName);
        }
        XMLUtils.endElement((ContentHandler)contentHandler, (String)"items");
    }

    public void saxCartItem(ContentHandler contentHandler, ODFCartItem item, String siteName) throws SAXException, IOException {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("id", item.getId());
        XMLUtils.startElement((ContentHandler)contentHandler, (String)"item", (Attributes)attrs);
        Content content = item.getContent();
        this.saxTypes(contentHandler, content.getTypes());
        this.saxContent(contentHandler, content, "cart");
        this.saxPage(contentHandler, item, siteName);
        Program parentProgram = item.getParentProgram();
        if (parentProgram != null) {
            attrs = new AttributesImpl();
            attrs.addCDATAAttribute("id", parentProgram.getId());
            attrs.addCDATAAttribute("title", parentProgram.getTitle());
            ProgramPage parentPage = this._odfPageResolver.getProgramPage(parentProgram, siteName);
            if (parentPage != null) {
                attrs.addCDATAAttribute("pageId", parentPage.getId());
            }
            XMLUtils.createElement((ContentHandler)contentHandler, (String)"parent", (Attributes)attrs);
        }
        XMLUtils.endElement((ContentHandler)contentHandler, (String)"item");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> cartItem2Json(ODFCartItem item, String siteName, String viewName) throws IOException {
        Page page;
        HashMap<String, Object> result = new HashMap<String, Object>();
        Content content = item.getContent();
        result.put("id", item.getId());
        result.put("contentId", content.getId());
        result.put("title", content.getTitle());
        result.put("name", content.getName());
        Program parentProgram = item.getParentProgram();
        if (parentProgram != null) {
            result.put("parentProgramId", parentProgram.getId());
            result.put("parentProgramTitle", parentProgram.getTitle());
        }
        if ((page = this.getPage(item, siteName)) != null) {
            result.put("pageId", page.getId());
            result.put("pageTitle", page.getTitle());
            result.put("pagePath", page.getPathInSitemap());
        }
        String cTypeId = content.getTypes()[0];
        ContentType cType = (ContentType)this._cTypeEP.getExtension(cTypeId);
        result.put("contentTypeId", cTypeId);
        result.put("contentTypeLabel", cType.getLabel());
        if (viewName != null && this._cTypesHelper.getView(viewName, content.getTypes(), content.getMixinTypes()) != null) {
            String uri = this._contentHelper.getContentHtmlViewUrl(content, viewName, parentProgram != null ? Map.of("parentProgramId", parentProgram.getId()) : Map.of());
            SitemapSource src = null;
            try {
                src = (SitemapSource)this._srcResolver.resolveURI(uri);
                try (InputStream is = src.getInputStream();){
                    String view = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                    result.put("view", view);
                }
            }
            finally {
                this._srcResolver.release((Source)src);
            }
        }
        if (content instanceof AbstractProgram) {
            try {
                boolean subscriber = this._currentUserProvider.getUser() != null && this.isSubscriber(this._currentUserProvider.getUser(), item.getId(), siteName);
                result.put("subscriber", subscriber);
            }
            catch (UserPreferencesException e) {
                this.getLogger().error("Fail to check if current user subscribes to content {}. It supposes he is not.", (Object)content.getId(), (Object)e);
                result.put("subscriber", false);
            }
            this.additionalItemInfo(item, (AbstractProgram)content, result);
        } else if (content instanceof Course) {
            this.additionalItemInfo(item, (Course)content, result);
        }
        return result;
    }

    protected void additionalItemInfo(ODFCartItem item, AbstractProgram abstractProgram, Map<String, Object> infos) {
    }

    protected void additionalItemInfo(ODFCartItem item, Course course, Map<String, Object> infos) {
        List courseParts;
        double numberOfHours;
        double ects = course.getEcts();
        if (ects > 0.0) {
            infos.put("ects", ects);
        }
        if ((numberOfHours = course.getNumberOfHours()) > 0.0) {
            infos.put("nbHours", numberOfHours);
        }
        if (!(courseParts = course.getCourseParts()).isEmpty()) {
            ArrayList courseparts = new ArrayList();
            for (CoursePart coursePart : course.getCourseParts()) {
                HashMap<String, Object> coursepart = new HashMap<String, Object>();
                coursepart.put("nature", coursePart.getNature());
                coursepart.put("nbHours", coursePart.getNumberOfHours());
            }
            infos.put("courseparts", courseparts);
        }
    }

    protected void saxTypes(ContentHandler handler, String[] types) throws SAXException {
        XMLUtils.startElement((ContentHandler)handler, (String)"types");
        for (String id : types) {
            ContentType cType = (ContentType)this._cTypeEP.getExtension(id);
            if (cType == null) continue;
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("id", cType.getId());
            XMLUtils.startElement((ContentHandler)handler, (String)"type", (Attributes)attrs);
            cType.getLabel().toSAX(handler);
            XMLUtils.endElement((ContentHandler)handler, (String)"type");
        }
        XMLUtils.endElement((ContentHandler)handler, (String)"types");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saxContent(ContentHandler handler, Content content, String viewName) throws SAXException, IOException {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addCDATAAttribute("id", content.getId());
        attrs.addCDATAAttribute("name", content.getName());
        attrs.addCDATAAttribute("title", content.getTitle(null));
        attrs.addCDATAAttribute("lastModifiedAt", DateUtils.zonedDateTimeToString((ZonedDateTime)content.getLastModified()));
        XMLUtils.startElement((ContentHandler)handler, (String)"content", (Attributes)attrs);
        if (this._cTypesHelper.getView("cart", content.getTypes(), content.getMixinTypes()) != null) {
            String uri = this._contentHelper.getContentHtmlViewUrl(content, viewName);
            SitemapSource src = null;
            try {
                src = (SitemapSource)this._srcResolver.resolveURI(uri);
                src.toSAX((ContentHandler)new IgnoreRootHandler(handler));
            }
            finally {
                this._srcResolver.release((Source)src);
            }
        }
        XMLUtils.endElement((ContentHandler)handler, (String)"content");
    }

    protected void saxPage(ContentHandler handler, ODFCartItem item, String siteName) throws SAXException {
        Page page = this.getPage(item, siteName);
        if (page != null) {
            String pageId = page.getId();
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("id", pageId);
            attrs.addCDATAAttribute("path", ResolveURIComponent.resolve((String)"page", (String)pageId));
            XMLUtils.createElement((ContentHandler)handler, (String)"page", (Attributes)attrs, (String)page.getTitle());
        }
    }

    protected Page getPage(ODFCartItem item, String siteName) {
        Content content = item.getContent();
        if (content instanceof Course) {
            return this._odfPageResolver.getCoursePage((Course)content, (AbstractProgram)item.getParentProgram(), siteName);
        }
        if (content instanceof Program) {
            return this._odfPageResolver.getProgramPage((Program)content, siteName);
        }
        if (content instanceof SubProgram) {
            return this._odfPageResolver.getSubProgramPage((SubProgram)content, (AbstractProgram)item.getParentProgram(), siteName);
        }
        this.getLogger().info("No page found of content {} in ODF cart", (Object)content.getId());
        return null;
    }

    class ODFCartItem {
        private Content _content;
        private Program _parentProgram;

        public ODFCartItem(Content content) {
            this(content, null);
        }

        public ODFCartItem(Content content, Program parentProgram) {
            this._content = content;
            this._parentProgram = parentProgram;
        }

        String getId() {
            return this._content.getId() + (String)(this._parentProgram != null ? ";" + this._parentProgram.getId() : "");
        }

        Content getContent() {
            return this._content;
        }

        Program getParentProgram() {
            return this._parentProgram;
        }

        public int hashCode() {
            return Objects.hash(this.getId());
        }

        public boolean equals(Object other) {
            return other != null && this.getClass() == other.getClass() && this.getId().equals(((ODFCartItem)other).getId());
        }
    }
}

