/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfweb.cart;

import java.util.HashMap;
import java.util.Map;
import org.ametys.core.cocoon.JSonReader;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.userpref.UserPreferencesException;
import org.ametys.plugins.odfweb.cart.ODFCartManager;
import org.ametys.web.WebHelper;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;

public class SubscribeODFCartAction
extends ServiceableAction {
    private ODFCartManager _cartManager;
    private CurrentUserProvider _currentUserProvider;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._cartManager = (ODFCartManager)((Object)smanager.lookup(ODFCartManager.ROLE));
        this._currentUserProvider = (CurrentUserProvider)smanager.lookup(CurrentUserProvider.ROLE);
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        String siteName = WebHelper.getSiteName((Request)request);
        UserIdentity owner = this._currentUserProvider.getUser();
        String itemId = request.getParameter("itemId");
        boolean subscribe = Boolean.valueOf(request.getParameter("subscribe"));
        try {
            if (subscribe) {
                this._cartManager.subscribe(owner, itemId, siteName);
            } else {
                this._cartManager.unsubscribe(owner, itemId, siteName);
            }
            result.put("success", true);
            result.put("items", this._cartManager.getItemIdsWithSubscription(owner, siteName));
        }
        catch (UserPreferencesException e) {
            this.getLogger().error("Failed to add subscription to content '" + itemId + "' for current user " + owner, (Throwable)e);
            result.put("success", false);
        }
        request.setAttribute(JSonReader.OBJECT_TO_READ, result);
        return EMPTY_MAP;
    }
}

