<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
				xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
				xmlns:xalan="http://xml.apache.org/xalan"
				xmlns:math="java.lang.Math"
				xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
				xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                extension-element-prefixes="math ametys resolver">
	
    <xsl:import href="service:web://pages/services/search-pages/search-criteria/search-criteria_3.3.xsl"/>
    
	<xsl:variable name="catalog" select="ametys:serviceParameter('catalog')/text()"/>
    <xsl:variable name="lang" select="ametys:lang()"/>
    <xsl:variable name="siteName" select="ametys:site()"/>
    
    <xsl:variable name="search-css-class"><xsl:call-template name="search-css-class"/></xsl:variable>
    <xsl:variable name="search-odf-type"><xsl:call-template name="search-odf-type"/></xsl:variable>
    
    <xsl:variable name="zone-item-id" select="/search/zone-item/@id"/>
	
    <!-- Used in common.xsl -->
    <xsl:variable name="common-service-css-class-name">odf search search-criteria search-odf <xsl:value-of select="$search-css-class"/></xsl:variable>
    <xsl:variable name="is-empty" select="not(/search)"/>    
    <xsl:variable name="common-service-name">service-search-odf</xsl:variable>    
    
    <xsl:template name="search-css-class">search-odf-programs</xsl:template>
    <xsl:template name="search-odf-type">program</xsl:template>
    <xsl:template name="search-criteria-url">/plugins/odf-web/search-criteria.xml</xsl:template>
    
    <xsl:template name="js-autocompletion">
        <script type="text/javascript">
            <xsl:comment>
                $j().ready(function() 
                {
                    function parseXML(data) 
                    {
                        var results = [];
                        var branches = $j(data).find('item');
                        $j(branches).each(function() {
                          var text = $j.trim($j(this).text());
                          results[results.length] = {'data': [text, text], 'result': text, 'value': text};
                        });
                        return results;
                    }
                        
                    var url = "<xsl:value-of select="$uri-prefix"/>/plugins/odf-web/service/search/auto-completion-<xsl:value-of select="$search-odf-type"/>/<xsl:value-of select="$site"/>/<xsl:value-of select="$lang"/>.xml";
                    $j("#search-textfield-<xsl:value-of select="$uniqueId"/>").autocomplete({
                        source: function( request, response ) {
                                $j.ajax({
                                    url: url + "?q=" + request.term,
                                    dataType: "xml",
                                    success: function( xmlResponse  ) {
                                        response( parseXML (xmlResponse));
                                    }
                                });
                        },
                        minLength: 2,
                        delay: 500
                    });                            
                });
            </xsl:comment>
        </script>  
    </xsl:template>
    
    <xsl:template name="form-search">	
           <input type="hidden" name="submit-form">
               <xsl:if test="/search/group-id and normalize-space(/search/group-id) != ''">
                   <xsl:attribute name="value"><xsl:value-of select="/search/group-id"/></xsl:attribute>
               </xsl:if>
           </input>
           <xsl:if test="/search/zone-item/@id and $search-page = ''">
               <input type="hidden" name="zone-item-id" value="{/search/zone-item/@id}"/>
           </xsl:if>
           
           <!-- Catalog -->
           <input type="hidden" name="catalog" value="{$catalog}"/>
           
           <xsl:call-template name="form-search-content-types"/>
           
           <!-- Put title field before textfield -->
           <xsl:call-template name="form-search-element-title">
           		<xsl:with-param name="value" select="/search/form/values/metadata/metadata[@name = 'title']"/>
           </xsl:call-template>
           
           <!-- Textfield -->
           <xsl:call-template name="form-search-element-keywords"/>
           
           <!-- All words -->
           <xsl:call-template name="form-search-element-allwords"/>
		
           <!-- Exact wording -->
           <xsl:call-template name="form-search-element-exactwording"/>
		
			<!-- No words -->
           <xsl:call-template name="form-search-element-nowords"/>
           
           <!-- Metadata -->
           <xsl:call-template name="form-search-by-metadata"/>
		
           <!-- Template common for submit button -->
           <xsl:call-template name="common-utils-input-submit">
               <xsl:with-param name="class-name">search</xsl:with-param>
               <xsl:with-param name="i18nkey" select="'plugin.web:FRONT_MODULE_SEARCH_BUTTON_OK'" />                                
           </xsl:call-template>
	</xsl:template>
	
	<xsl:template name="form-search-content-types">
        <input type="hidden" name="content-types" value="org.ametys.plugins.odf.Content.program"/>
	</xsl:template>
	
    <!-- Title field -->
    <xsl:template name="form-search-element-title">
    	<xsl:param name="value" />
    	
    	<xsl:if test="/search/form/fields/metadata[@name = 'title']">
	    	<div class="field">
	       		<div class="label"><label for="search-metadata-title-{$uniqueId}"><xsl:value-of select="/search/form/fields/metadata[@name = 'title']/label"/></label></div>
	       		<div class="input">
	         		<input id="search-metadata-title-{$uniqueId}" type="text" name="metadata-title" value="{$value}" class="text"/>
	       		</div>
	   			<div class="field-end"></div>
	   		</div>
	   	</xsl:if>
    </xsl:template>
    
    <xsl:template name="form-search-by-metadata">
    	<xsl:for-each select="/search/form/fields/metadata[@name != 'title']">
        	<xsl:variable name="value" select="/search/form/values/metadata/metadata[@name = current()/@name]"/>
        	<xsl:choose>
        		<xsl:when test="enumeration">
        			<xsl:call-template name="form-search-by-metadata-enum" >
        				<xsl:with-param name="value" select="$value" />
        			</xsl:call-template>
        		</xsl:when>
        		<xsl:otherwise>
        			<xsl:call-template name="form-search-by-metadata-text" >
        				<xsl:with-param name="value" select="$value" />
        			</xsl:call-template>
        		</xsl:otherwise>
        	</xsl:choose>
    	</xsl:for-each>
    </xsl:template>
    
</xsl:stylesheet>
