/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfweb.observation.solr;

import org.ametys.cms.ObservationConstants;
import org.ametys.core.observation.Observer;
import org.ametys.odf.orgunit.OrgUnit;
import org.ametys.plugins.repository.RepositoryConstants;
import org.ametys.web.WebConstants;
import org.ametys.web.repository.page.Page;

/**
 * {@link Observer} for observing the move or validation of an {@link OrgUnit}
 * in order to index (2nd step) in Solr the given ODF root pages (because the virtual tree may have changed)
 */
public class SolrOrgUnitChangedPart2Observer extends AbstractSolrOrgUnitObserver
{
    @Override
    protected String[] _supportedEventIds()
    {
        return new String[] {ObservationConstants.EVENT_CONTENT_MODIFIED, ObservationConstants.EVENT_CONTENT_VALIDATED};
    }
    
    @Override
    protected void _updateIndex(Page odfRootPage) throws Exception
    {
        // Index recursively
        String odfRootPageId = odfRootPage.getId();
        _solrPageIndexer.indexPage(odfRootPageId, RepositoryConstants.DEFAULT_WORKSPACE, true, true);
        _solrPageIndexer.indexPage(odfRootPageId, WebConstants.LIVE_WORKSPACE, true, true);
    }
}
