/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfweb.catalog;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.ametys.core.cocoon.JSonReader;
import org.ametys.web.source.SkinSource;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.acting.AbstractAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang.StringUtils;

public class GetInDesignTemplatesAction
extends AbstractAction {
    private static InDesignPathFilter __PATH_FILTER = new InDesignPathFilter();

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        SkinSource indesignDirSource;
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        HashMap result = new HashMap();
        ArrayList templates = new ArrayList();
        String skinName = request.getParameter("skinName");
        if (StringUtils.isNotEmpty((String)skinName) && (indesignDirSource = (SkinSource)resolver.resolveURI("skin:" + skinName + "://indesign")).exists() && indesignDirSource.isCollection()) {
            try (DirectoryStream<Path> models = Files.newDirectoryStream(indesignDirSource.getFile(), __PATH_FILTER);){
                for (Path model : models) {
                    String fileName = model.getFileName().toString();
                    HashMap<String, String> info = new HashMap<String, String>();
                    info.put("filepath", fileName);
                    info.put("filename", fileName.substring(0, fileName.lastIndexOf(".")));
                    templates.add(info);
                }
            }
        }
        result.put("templates", templates);
        request.setAttribute(JSonReader.OBJECT_TO_READ, result);
        return EMPTY_MAP;
    }

    static class InDesignPathFilter
    implements DirectoryStream.Filter<Path> {
        InDesignPathFilter() {
        }

        @Override
        public boolean accept(Path entry) throws IOException {
            return Files.isRegularFile(entry, new LinkOption[0]) && entry.getFileName().toString().toLowerCase().endsWith(".indt");
        }
    }
}

