<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2015 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
				xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
				xmlns:xalan="http://xml.apache.org/xalan"
				xmlns:math="java.lang.Math"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
				xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                extension-element-prefixes="math">
                
    <xsl:import href="service:odf-web://pages/services/search/search_1.2.xsl"/>

	<xsl:param name="displayProgramReferences" select="ametys:serviceParameter('displayProgramReferences')"/>
	
    <xsl:template name="search-css-class">search-odf-courses</xsl:template>
    <xsl:template name="search-odf-type">course</xsl:template>
    
    <xsl:template name="form-search-content-types">
        <input type="hidden" name="content-types" value="org.ametys.plugins.odf.Content.course"/>
	</xsl:template>
	
	<!-- +
		 | Template for results
		 + -->
	<xsl:template name="hits">
        <div class="results">
            <ul>
                <xsl:for-each select="/search/hits/hit">
                    <li>
                        <xsl:attribute name="class">hit page<xsl:text> </xsl:text>
                            <xsl:call-template name="common-utils-class"/>                        
                        </xsl:attribute>                    
                        <a title="{title}">
                        	<xsl:attribute name="href"><xsl:call-template name="hit-href"/></xsl:attribute>
                        	<xsl:value-of select="title"/>
                        </a>
                        <xsl:call-template name="hit-scoring"/>          
                        <xsl:call-template name="excerpt"/>  
                        <xsl:call-template name="hit-lastvalidation"/>  
                        <xsl:call-template name="hit-referencingprograms"/>                                           
                    </li>
                </xsl:for-each>                            
            </ul>
        </div>    
	</xsl:template>	   
    
    <xsl:template name="hit-referencingprograms">
    	<xsl:if test="$displayProgramReferences = 'true' and referencingProgram">
            <div class="referencingprogram">
                <i18n:text i18n:key="PLUGINS_ODFWEB_SERVICE_SEARCH_COURSE_REFERENCING_PROGRAMS_INTRO" i18n:catalogue="plugin.odf-web"/>
           		<ul>
        			<xsl:for-each select="referencingProgram">
        				<li>
	        				<a>
	        					<xsl:attribute name="href">
	        						<xsl:call-template name="hit-href">
	        							<xsl:with-param name="url" select="@path"/>
	        						</xsl:call-template>
	        					</xsl:attribute>
	        					<xsl:value-of select="@title"/>
	        				</a>
        				</li>
        			</xsl:for-each>
        		</ul>
            </div>
    	</xsl:if>
    </xsl:template>

</xsl:stylesheet>
