/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfweb.alerts;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.cms.repository.Content;
import org.ametys.odf.program.Program;
import org.ametys.plugins.odfweb.repository.OdfPageResolver;
import org.ametys.runtime.config.Config;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;

/**
 * Alerts engine: sends alerts mail.
 * This is the web version of the engine: it sets the currently processed content's
 * site name in the request object, and sends additional site and page information
 * in the alerts e-mails.
 */
public class AlertSchedulable extends org.ametys.web.alerts.AlertSchedulable
{
    /** The ODF page resolver */
    protected OdfPageResolver _odfPageResolver;
    /** The site manager */
    protected SiteManager _siteManager;
    
    @Override
    public void service(ServiceManager manager) throws ServiceException
    {
        super.service(manager);
        _odfPageResolver = (OdfPageResolver) manager.lookup(OdfPageResolver.ROLE);
        _siteManager = (SiteManager) manager.lookup(SiteManager.ROLE);
    }
    
    @Override
    protected Site _getSite(Content content)
    {
        Site site = super._getSite(content);
        if (site == null)
        {
            String siteName = Config.getInstance().getValue("odf.web.site.name");
            site = _siteManager.getSite(siteName);
        }
        
        return site;
    }
    
    @Override
    protected Page _getPage(Content content, Site site)
    {
        if (content instanceof Program)
        {
            return _odfPageResolver.getProgramPage((Program) content, site.getName());
        }
        else
        {
            return super._getPage(content, site);
        }
    }
}
