/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfweb.catalog;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.ametys.core.ui.Callable;
import org.ametys.odf.catalog.Catalog;
import org.ametys.plugins.odfweb.repository.OdfPageHandler;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.repository.page.Page;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class CatalogDAO
extends org.ametys.odf.catalog.CatalogDAO {
    private OdfPageHandler _odfPageHandler;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._odfPageHandler = (OdfPageHandler)((Object)smanager.lookup(OdfPageHandler.ROLE));
    }

    @Callable
    public Map<String, Object> removeCatalog(String catalogId, boolean forceDeletion) {
        Catalog catalog = null;
        try {
            catalog = (Catalog)this._resolver.resolveById(catalogId);
        }
        catch (UnknownAmetysObjectException e) {
            return Map.of("error", "unknown-catalog");
        }
        Page page = this._odfPageHandler.getOdfRootPage(null, null, catalog.getName());
        if (page != null) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("error", "error-with-message");
            result.put("message", new I18nizableText("plugin.odf-web", "PLUGINS_ODFWEB_CATALOG_DELETE_ERROR_ODFROOT", Collections.singletonList(page.getTitle())));
            return result;
        }
        return super.removeCatalog(catalogId, forceDeletion);
    }
}

