/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfweb.repository;

import com.google.common.base.Splitter;
import java.util.Map;
import org.ametys.odf.course.Course;
import org.ametys.odf.program.Program;
import org.ametys.plugins.odfweb.repository.AbstractOdfPageFactory;
import org.ametys.plugins.odfweb.repository.CoursePage;
import org.ametys.plugins.repository.AmetysObjectFactory;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.web.repository.page.Page;
import org.apache.commons.lang3.StringUtils;

public class CoursePageFactory
extends AbstractOdfPageFactory
implements AmetysObjectFactory<CoursePage> {
    public CoursePage createCoursePage(Page root, Course course, Program parentProgram, String path, Page parentPage) {
        return new CoursePage(root, this.getConfiguration(), this, course, parentProgram, path, parentPage);
    }

    public CoursePage getAmetysObjectById(String id) throws AmetysRepositoryException {
        String path = StringUtils.substringBetween((String)id, (String)"://", (String)"?");
        String queryString = StringUtils.substringAfter((String)id, (String)"?");
        Map ids = Splitter.on((String)"&").withKeyValueSeparator("=").split((CharSequence)queryString);
        String rootId = (String)ids.get("rootId");
        String courseId = (String)ids.get("courseId");
        String programId = (String)ids.get("programId");
        try {
            Page root = (Page)this._resolver.resolveById(rootId);
            Course course = (Course)this._resolver.resolveById(courseId);
            Program program = (Program)this._resolver.resolveById(programId);
            if (!this._odfPageHandler.isValidRestriction(root, program)) {
                throw new UnknownAmetysObjectException("There's no course page " + courseId + " for site " + root.getSiteName());
            }
            String levelPath = this._odfPageHandler.computeLevelsPath(root, program);
            String coursePath = StringUtils.isNotBlank((CharSequence)levelPath) ? levelPath + "/" + path : path;
            root.getChild(coursePath);
            try {
                CoursePage coursePage = this.createCoursePage(root, course, program, path, null);
                coursePage.getPathInSitemap();
                return coursePage;
            }
            catch (UnknownAmetysObjectException e) {
                throw new UnknownAmetysObjectException("There's no course page " + programId + " for site " + root.getSiteName(), (Throwable)e);
            }
        }
        catch (UnknownAmetysObjectException e) {
            throw new UnknownAmetysObjectException("There's no object for id " + id, (Throwable)e);
        }
    }

    public String getScheme() {
        return "course";
    }

    public boolean hasAmetysObjectForId(String id) throws AmetysRepositoryException {
        String path = StringUtils.substringBetween((String)id, (String)"://", (String)"?");
        String queryString = StringUtils.substringAfter((String)id, (String)"?");
        Map ids = Splitter.on((String)"&").withKeyValueSeparator("=").split((CharSequence)queryString);
        String rootId = (String)ids.get("rootId");
        String courseId = (String)ids.get("courseId");
        String programId = (String)ids.get("programId");
        try {
            Page root = (Page)this._resolver.resolveById(rootId);
            Program program = (Program)this._resolver.resolveById(programId);
            String levelPath = this._odfPageHandler.computeLevelsPath(root, program);
            String coursePath = StringUtils.isNotBlank((CharSequence)levelPath) ? levelPath + "/" + path : path;
            root.getChild(coursePath);
            return this._resolver.hasAmetysObjectForId(courseId);
        }
        catch (UnknownAmetysObjectException e) {
            return false;
        }
    }
}

