/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfweb.repository;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.ametys.cms.content.ContentHelper;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.cms.contenttype.ContentTypesHelper;
import org.ametys.cms.repository.Content;
import org.ametys.core.ui.Callable;
import org.ametys.core.util.I18nUtils;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.catalog.CatalogsManager;
import org.ametys.odf.course.Course;
import org.ametys.odf.enumeration.OdfReferenceTableHelper;
import org.ametys.odf.orgunit.RootOrgUnitProvider;
import org.ametys.odf.program.AbstractProgram;
import org.ametys.odf.program.Program;
import org.ametys.odf.program.SubProgram;
import org.ametys.odf.tree.OdfClassificationHandler;
import org.ametys.plugins.odfweb.repository.FirstLevelPage;
import org.ametys.plugins.odfweb.repository.FirstLevelPageFactory;
import org.ametys.plugins.odfweb.repository.RedirectPage;
import org.ametys.plugins.odfweb.repository.SecondLevelPage;
import org.ametys.plugins.odfweb.restrictions.OdfProgramRestriction;
import org.ametys.plugins.odfweb.restrictions.OdfProgramRestrictionManager;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectIterator;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.jcr.JCRAmetysObject;
import org.ametys.plugins.repository.jcr.NameHelper;
import org.ametys.plugins.repository.provider.WorkspaceSelector;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.VirtualFactoryExpression;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.PageQueryHelper;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.sitemap.Sitemap;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;

public class OdfPageHandler
extends AbstractLogEnabled
implements Component,
Initializable,
Serviceable {
    public static final String ROLE = OdfPageHandler.class.getName();
    public static final String LEVEL1_ATTRIBUTE_NAME = "firstLevel";
    public static final String LEVEL2_ATTRIBUTE_NAME = "secondLevel";
    public static final String CATALOG_DATA_NAME = "odf-root-catalog";
    protected static final List<String> NON_ELIGIBLE_CTYPES_FOR_LEVEL = Arrays.asList("org.ametys.plugins.odf.Content.programItem", "odf-enumeration.Mention");
    protected AmetysObjectResolver _resolver;
    protected I18nUtils _i18nUtils;
    protected ContentTypeExtensionPoint _cTypeEP;
    protected CatalogsManager _catalogsManager;
    protected WorkspaceSelector _workspaceSelector;
    protected Map<String, Map<String, Map<String, Set<String>>>> _odfRootPages;
    protected Map<String, Map<String, Boolean>> _hasOdfRoot;
    protected ServiceManager _manager;
    protected OdfProgramRestrictionManager _odfRestrictionsManager;
    protected ContentTypesHelper _contentTypesHelper;
    protected ContentHelper _contentHelper;
    protected OdfReferenceTableHelper _odfReferenceTableHelper;
    protected RootOrgUnitProvider _orgUnitProvider;
    protected OdfClassificationHandler _odfClassificationHandler;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this._manager = serviceManager;
        this._resolver = (AmetysObjectResolver)serviceManager.lookup(AmetysObjectResolver.ROLE);
        this._i18nUtils = (I18nUtils)serviceManager.lookup(I18nUtils.ROLE);
        this._cTypeEP = (ContentTypeExtensionPoint)serviceManager.lookup(ContentTypeExtensionPoint.ROLE);
        this._workspaceSelector = (WorkspaceSelector)serviceManager.lookup(WorkspaceSelector.ROLE);
        this._catalogsManager = (CatalogsManager)serviceManager.lookup(CatalogsManager.ROLE);
        this._odfRestrictionsManager = (OdfProgramRestrictionManager)((Object)serviceManager.lookup(OdfProgramRestrictionManager.ROLE));
        this._contentTypesHelper = (ContentTypesHelper)serviceManager.lookup(ContentTypesHelper.ROLE);
        this._contentHelper = (ContentHelper)serviceManager.lookup(ContentHelper.ROLE);
        this._odfReferenceTableHelper = (OdfReferenceTableHelper)serviceManager.lookup(OdfReferenceTableHelper.ROLE);
        this._orgUnitProvider = (RootOrgUnitProvider)serviceManager.lookup(RootOrgUnitProvider.ROLE);
        this._odfClassificationHandler = (OdfClassificationHandler)serviceManager.lookup(OdfClassificationHandler.ROLE);
    }

    public void initialize() throws Exception {
        this._odfRootPages = new HashMap<String, Map<String, Map<String, Set<String>>>>();
        this._hasOdfRoot = new HashMap<String, Map<String, Boolean>>();
    }

    public Page getOdfRootPage(String siteName, String sitemapName) throws AmetysRepositoryException {
        Set<Page> rootPages = this.getOdfRootPages(siteName, sitemapName);
        return rootPages.isEmpty() ? null : rootPages.iterator().next();
    }

    public Page getOdfRootPage(String siteName, String sitemapName, String catalogName) throws AmetysRepositoryException {
        String catalogToCompare = catalogName != null ? catalogName : "";
        for (Page odfRootPage : this.getOdfRootPages(siteName, sitemapName)) {
            if (!catalogToCompare.equals(this.getCatalog(odfRootPage))) continue;
            return odfRootPage;
        }
        return null;
    }

    @Callable
    public List<String> getOdfRootPageIds(String siteName, String sitemapName) throws AmetysRepositoryException {
        Set<Page> pages = this.getOdfRootPages(siteName, sitemapName);
        return pages.stream().map(p -> p.getId()).collect(Collectors.toList());
    }

    public Set<Page> getOdfRootPages(String siteName, String sitemapName) throws AmetysRepositoryException {
        HashSet<Page> rootPages = new HashSet();
        String workspace = this._workspaceSelector.getWorkspace();
        Map<Object, Object> wspOdfRootPages = null;
        if (this._odfRootPages.containsKey(workspace)) {
            wspOdfRootPages = this._odfRootPages.get(workspace);
        } else {
            wspOdfRootPages = new HashMap();
            this._odfRootPages.put(workspace, wspOdfRootPages);
        }
        Map siteOdfRootPages = null;
        if (wspOdfRootPages.containsKey(siteName)) {
            siteOdfRootPages = (Map)wspOdfRootPages.get(siteName);
        } else {
            siteOdfRootPages = new HashMap();
            wspOdfRootPages.put(siteName, siteOdfRootPages);
        }
        if (siteOdfRootPages.containsKey(sitemapName)) {
            Set odfRootPageIds = (Set)siteOdfRootPages.get(sitemapName);
            if (odfRootPageIds != null) {
                for (String pageId : odfRootPageIds) {
                    rootPages.add((Page)this._resolver.resolveById(pageId));
                }
            }
        } else {
            rootPages = this._getOdfRootPages(siteName, sitemapName);
            HashSet<String> odfRootPageIds = new HashSet<String>();
            for (Page rootPage : rootPages) {
                odfRootPageIds.add(rootPage.getId());
            }
            siteOdfRootPages.put(sitemapName, odfRootPageIds);
        }
        return rootPages;
    }

    public boolean hasOdfRootPage(Site site) {
        boolean hasOneRoot = false;
        String workspace = this._workspaceSelector.getWorkspace();
        String siteName = site.getName();
        Map<Object, Object> wspHasOneRoot = null;
        if (this._hasOdfRoot.containsKey(workspace)) {
            wspHasOneRoot = this._hasOdfRoot.get(workspace);
        } else {
            wspHasOneRoot = new HashMap();
            this._hasOdfRoot.put(workspace, wspHasOneRoot);
        }
        if (wspHasOneRoot.containsKey(siteName)) {
            hasOneRoot = (Boolean)wspHasOneRoot.get(siteName);
        } else {
            AmetysObjectIterator sitemaps = site.getSitemaps().iterator();
            while (sitemaps.hasNext() && !hasOneRoot) {
                String sitemapName = ((Sitemap)sitemaps.next()).getName();
                if (this.getOdfRootPages(site.getName(), sitemapName).isEmpty()) continue;
                hasOneRoot = true;
            }
            wspHasOneRoot.put(siteName, hasOneRoot);
        }
        return hasOneRoot;
    }

    public boolean isValidRestriction(Page rootPage, Program program) {
        if (!program.getCatalog().equals(this.getCatalog(rootPage))) {
            return false;
        }
        if (!program.getLanguage().equals(rootPage.getSitemapName())) {
            return false;
        }
        OdfProgramRestriction restriction = this._odfRestrictionsManager.getRestriction(rootPage);
        if (restriction != null) {
            return restriction.contains(program);
        }
        return true;
    }

    public void clearRootCache() {
        this._odfRootPages = new HashMap<String, Map<String, Map<String, Set<String>>>>();
        this._hasOdfRoot = new HashMap<String, Map<String, Boolean>>();
    }

    public void clearRootCache(String siteName, String sitemapName) {
        if (this._odfRootPages.containsKey(siteName)) {
            this._odfRootPages.get(siteName).remove(sitemapName);
        }
        this._hasOdfRoot.remove(siteName);
    }

    public boolean isODFRootPage(Page page) {
        if (page instanceof JCRAmetysObject) {
            try {
                JCRAmetysObject jcrPage = (JCRAmetysObject)page;
                Node node = jcrPage.getNode();
                if (node.hasProperty("ametys-internal:virtual")) {
                    Value[] values = node.getProperty("ametys-internal:virtual").getValues();
                    boolean hasValue = false;
                    for (int i = 0; i < values.length && !hasValue; ++i) {
                        hasValue = FirstLevelPageFactory.class.getName().equals(values[i].getString());
                    }
                    return hasValue;
                }
                return false;
            }
            catch (RepositoryException e) {
                return false;
            }
        }
        return false;
    }

    protected Page _getOdfRootPage(String siteName, String sitemapName) throws AmetysRepositoryException {
        VirtualFactoryExpression expression = new VirtualFactoryExpression(FirstLevelPageFactory.class.getName());
        String query = PageQueryHelper.getPageXPathQuery((String)siteName, (String)sitemapName, null, (Expression)expression, null);
        AmetysObjectIterable pages = this._resolver.query(query);
        Page page = pages.stream().findFirst().orElse(null);
        return page;
    }

    protected Set<Page> _getOdfRootPages(String siteName, String sitemapName) throws AmetysRepositoryException {
        VirtualFactoryExpression expression = new VirtualFactoryExpression(FirstLevelPageFactory.class.getName());
        String query = PageQueryHelper.getPageXPathQuery((String)siteName, (String)sitemapName, null, (Expression)expression, null);
        return this._resolver.query(query).stream().collect(Collectors.toSet());
    }

    public String getCatalog(Page rootPage) {
        return (String)rootPage.getValue(CATALOG_DATA_NAME, (Object)"");
    }

    public String getLevel1Metadata(String siteName, String sitemapName, String catalog) {
        Page rootPage = this.getOdfRootPage(siteName, sitemapName, catalog);
        return this.getLevel1Metadata(rootPage);
    }

    public String getLevel1Metadata(Page rootPage) {
        return (String)rootPage.getValue(LEVEL1_ATTRIBUTE_NAME);
    }

    public String getLevel2Metadata(String siteName, String sitemapName, String catalog) {
        Page rootPage = this.getOdfRootPage(siteName, sitemapName, catalog);
        return this.getLevel2Metadata(rootPage);
    }

    public String getLevel2Metadata(Page rootPage) {
        return (String)rootPage.getValue(LEVEL2_ATTRIBUTE_NAME);
    }

    public Map<String, OdfClassificationHandler.LevelValue> getLevel1Values(String siteName, String sitemapName, String catalog) {
        Page rootPage = this.getOdfRootPage(siteName, sitemapName, catalog);
        return this.getLevel1Values(rootPage);
    }

    public String getProgramLevelValue(Program program, String levelMetaPath) {
        List programLevelValue = this._odfClassificationHandler.getProgramLevelValues(program, levelMetaPath);
        return programLevelValue.isEmpty() ? null : (String)programLevelValue.get(0);
    }

    public String getProgramLevel1Value(Page rootPage, Program program) {
        String level1Metadata = this.getLevel1Metadata(rootPage);
        if (StringUtils.isNotBlank((CharSequence)level1Metadata)) {
            List programLevelValue = this._odfClassificationHandler.getProgramLevelValues(program, level1Metadata);
            return programLevelValue.isEmpty() ? null : (String)programLevelValue.get(0);
        }
        return null;
    }

    public String getProgramLevel2Value(Page rootPage, Program program) {
        String level2Metadata = this.getLevel2Metadata(rootPage);
        if (StringUtils.isNotBlank((CharSequence)level2Metadata)) {
            List programLevelValue = this._odfClassificationHandler.getProgramLevelValues(program, level2Metadata);
            return programLevelValue.isEmpty() ? null : (String)programLevelValue.get(0);
        }
        return null;
    }

    public String getLevel1PageName(Page rootPage, Program program) {
        String value = this.getProgramLevel1Value(rootPage, program);
        return value != null ? NameHelper.filterName((String)value) + "-" + this.encodeLevelValue(value) : "";
    }

    public String getLevel2PageName(Page rootPage, Program program) {
        String value = this.getProgramLevel2Value(rootPage, program);
        return value != null ? NameHelper.filterName((String)value) + "-" + this.encodeLevelValue(value) : "";
    }

    public String getOrgunitIdFromUaiCode(Page rootPage, String uaiCode) {
        return this._odfClassificationHandler.getOrgunitIdFromUaiCode(rootPage.getSitemapName(), uaiCode);
    }

    public AmetysObjectIterable<Program> getProgramsWithRestrictions(Page rootPage, String level1, String level2, String programCode, String programName) {
        return this.getProgramsWithRestrictions(rootPage, this.getLevel1Metadata(rootPage), level1, this.getLevel2Metadata(rootPage), level2, programCode, programName);
    }

    public AmetysObjectIterable<Program> getProgramsWithRestrictions(Page rootPage, String level1Metadata, String level1, String level2Metadata, String level2, String programCode, String programName) {
        OdfProgramRestriction restriction = this._odfRestrictionsManager.getRestriction(rootPage);
        return this._odfClassificationHandler.getPrograms(this.getCatalog(rootPage), rootPage.getSitemapName(), level1Metadata, level1, level2Metadata, level2, programCode, programName, restriction == null ? null : ImmutableList.of((Object)restriction.getExpression()));
    }

    public Map<String, OdfClassificationHandler.LevelValue> getLevel1Values(Page rootPage) {
        String level1Value = this.getLevel1Metadata(rootPage);
        if (StringUtils.isNotBlank((CharSequence)level1Value)) {
            return this._odfClassificationHandler.getLevelValues(level1Value, rootPage.getSitemapName());
        }
        return Collections.EMPTY_MAP;
    }

    public Map<String, OdfClassificationHandler.LevelValue> getLevel2Values(String siteName, String sitemapName, String catalog) {
        Page rootPage = this.getOdfRootPage(siteName, sitemapName, catalog);
        return this.getLevel2Values(rootPage);
    }

    public Map<String, OdfClassificationHandler.LevelValue> getLevel2Values(Page rootPage) {
        String level2Value = this.getLevel2Metadata(rootPage);
        if (StringUtils.isNotBlank((CharSequence)level2Value)) {
            return this._odfClassificationHandler.getLevelValues(level2Value, rootPage.getSitemapName());
        }
        return Collections.EMPTY_MAP;
    }

    public String encodeLevelValue(String value) {
        return this._odfClassificationHandler.encodeLevelValue(value);
    }

    public String decodeLevelValue(String value) {
        return this._odfClassificationHandler.decodeLevelValue(value);
    }

    public String getPageName(ProgramItem item) {
        if (item instanceof AbstractProgram || item instanceof Course) {
            String filteredTitle;
            block5: {
                filteredTitle = "";
                try {
                    filteredTitle = NameHelper.filterName((String)((Content)item).getTitle());
                }
                catch (IllegalArgumentException e) {
                    if (item instanceof Program) {
                        filteredTitle = "program";
                    }
                    if (item instanceof SubProgram) {
                        filteredTitle = "subprogram";
                    }
                    if (!(item instanceof Course)) break block5;
                    filteredTitle = "course";
                }
            }
            return filteredTitle + "-" + item.getCode();
        }
        throw new IllegalArgumentException("Illegal program item : no page can be associated for a program item of type " + item.getClass().getName());
    }

    public Map<String, ModelItem> getEligibleAttributesForLevel() {
        return this._odfClassificationHandler.getEligibleAttributesForLevel();
    }

    public Map<String, I18nizableText> getCatalogs() {
        return this._odfClassificationHandler.getCatalogs();
    }

    public Map<String, ModelItem> getEnumeratedAttributes(String programContentTypeId, boolean allowMultiple) {
        return this._odfClassificationHandler.getEnumeratedAttributes(programContentTypeId, allowMultiple);
    }

    public String computeLevelsPath(Page rootPage, Program parentProgram) {
        if (this.getLevel1Metadata(rootPage) != null) {
            String level1 = this.getProgramLevel1Value(rootPage, parentProgram);
            if (StringUtils.isNotBlank((CharSequence)level1)) {
                if (this.getLevel2Metadata(rootPage) != null) {
                    String level2 = this.getProgramLevel2Value(rootPage, parentProgram);
                    if (StringUtils.isNotBlank((CharSequence)level2)) {
                        SecondLevelPage secondLevelPage = this.findSecondLevelPage(rootPage, level1, level2);
                        return secondLevelPage.getParent().getName() + "/" + secondLevelPage.getName();
                    }
                    return null;
                }
                return this.findFirstLevelPage(rootPage, level1).getName();
            }
            return null;
        }
        return "";
    }

    public FirstLevelPage findFirstLevelPage(Page rootPage, String level1Value) {
        String firstLevelPageId = "odfLevel1://" + level1Value + "?rootId=" + rootPage.getId();
        return (FirstLevelPage)this._resolver.resolveById(firstLevelPageId);
    }

    public SecondLevelPage findSecondLevelPage(Page rootPage, String level1Value, String level2Value) {
        String secondLevelPageId = "odfLevel2://" + level1Value + "/" + level2Value + "?rootId=" + rootPage.getId();
        return (SecondLevelPage)this._resolver.resolveById(secondLevelPageId);
    }

    public Page addRedirectIfNeeded(Page page, String name) {
        if (!name.equals(page.getName())) {
            Page page2;
            this.getLogger().warn("Redirect path '{}' to '{}' page", (Object)name, (Object)page.getName());
            if (page instanceof RedirectPage) {
                RedirectPage redirectPage = (RedirectPage)page;
                page2 = redirectPage.getRedirectPage();
            } else {
                page2 = page;
            }
            return new RedirectPage(page2);
        }
        return page;
    }

    public Page exploreQueuePath(Page page, String queuePath) {
        if (StringUtils.isNotEmpty((CharSequence)queuePath)) {
            return (Page)page.getChild(queuePath);
        }
        return page;
    }
}

