/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfweb.service.search.helper;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.ametys.cms.content.ContentHelper;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ContentTypeExpression;
import org.ametys.cms.search.ui.model.SearchUICriterion;
import org.ametys.cms.search.ui.model.impl.IndexingFieldSearchUICriterion;
import org.ametys.core.util.I18nUtils;
import org.ametys.plugins.odfweb.service.search.criterion.DegreeUniversityAttributeContentSearchCriterionDefinition;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.query.QueryHelper;
import org.ametys.plugins.repository.query.expression.AndExpression;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.NotExpression;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.parameter.Validator;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.runtime.plugin.component.PluginAware;
import org.ametys.runtime.plugin.component.ThreadSafeComponentManager;
import org.ametys.web.frontoffice.search.metamodel.Searchable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class DegreeUniversityHelper
extends AbstractLogEnabled
implements Component,
Serviceable,
Contextualizable,
PluginAware {
    public static final String ROLE = DegreeUniversityHelper.class.getName();
    protected AmetysObjectResolver _resolver;
    protected I18nUtils _i18nUtils;
    protected ContentTypeExtensionPoint _cTypeEP;
    protected ContentHelper _contentHelper;
    protected ServiceManager _manager;
    protected Context _context;
    protected String _pluginName;

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._i18nUtils = (I18nUtils)manager.lookup(I18nUtils.ROLE);
        this._cTypeEP = (ContentTypeExtensionPoint)manager.lookup(ContentTypeExtensionPoint.ROLE);
        this._contentHelper = (ContentHelper)manager.lookup(ContentHelper.ROLE);
        this._manager = manager;
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._pluginName = pluginName;
    }

    public List<Content> getDegrees(boolean isUniversity) {
        StringExpression duExpression = new StringExpression("type", Expression.Operator.EQ, "UNIVERSITY");
        AndExpression expr = new AndExpression(new Expression[]{new ContentTypeExpression(Expression.Operator.EQ, new String[]{"odf-enumeration.Degree"}), isUniversity ? duExpression : new NotExpression((Expression)duExpression)});
        return this._resolver.query(QueryHelper.getXPathQuery(null, (String)"ametys:content", (Expression)expr)).stream().filter(Content.class::isInstance).map(Content.class::cast).collect(Collectors.toList());
    }

    public DegreeUniversityAttributeContentSearchCriterionDefinition getDegreeUniversityCriterionDefinition(Searchable searcheable) {
        try {
            ThreadSafeComponentManager searchCriterionManager = new ThreadSafeComponentManager();
            searchCriterionManager.setLogger(this.getLogger());
            searchCriterionManager.contextualize(this._context);
            searchCriterionManager.service(this._manager);
            Configuration criteriaConf = this._getDegreeIndexingFieldCriteriaConfiguration();
            searchCriterionManager.addComponent(this._pluginName, null, "degree", IndexingFieldSearchUICriterion.class, criteriaConf);
            searchCriterionManager.initialize();
            ContentType programContentType = (ContentType)this._cTypeEP.getExtension("org.ametys.plugins.odf.Content.program");
            Optional<Validator> validator = this._getDegreeValidator(programContentType);
            SearchUICriterion criterion = (SearchUICriterion)searchCriterionManager.lookup("degree");
            return new DegreeUniversityAttributeContentSearchCriterionDefinition(this._pluginName, Optional.of(searcheable), criterion, Optional.of(programContentType), validator, this._resolver, this._cTypeEP, this._contentHelper, this._i18nUtils, this);
        }
        catch (Exception e) {
            throw new RuntimeException("An error occured when retrieving IndexingFieldSearchCriterionDefinitions", e);
        }
    }

    private Optional<Validator> _getDegreeValidator(ContentType contentType) {
        return Optional.of(contentType.getModelItem("degree")).filter(ElementDefinition.class::isInstance).map(ElementDefinition.class::cast).map(ElementDefinition::getValidator);
    }

    private Configuration _getDegreeIndexingFieldCriteriaConfiguration() {
        DefaultConfiguration criteriaConf = new DefaultConfiguration("criteria");
        DefaultConfiguration metaConf = new DefaultConfiguration("field");
        criteriaConf.addChild((Configuration)metaConf);
        metaConf.setAttribute("path", "degree");
        DefaultConfiguration cTypesConf = new DefaultConfiguration("contentTypes");
        criteriaConf.addChild((Configuration)cTypesConf);
        DefaultConfiguration baseTypeConf = new DefaultConfiguration("baseType");
        baseTypeConf.setAttribute("id", "org.ametys.plugins.odf.Content.program");
        cTypesConf.addChild((Configuration)baseTypeConf);
        return criteriaConf;
    }
}

