/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfweb;

import java.util.LinkedHashMap;
import java.util.Map;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

import org.ametys.odf.program.ProgramFactory;
import org.ametys.plugins.odfweb.repository.OdfPageHandler;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.Enumerator;
import org.ametys.runtime.model.ModelItem;

/**
 * Enumerator for the eligible metadata for ODF page level
 *
 */
public class EligibleMetadataForLevelEnumerator implements Enumerator<String>, Serviceable
{
    /** The ODF root page handler. */
    protected OdfPageHandler _odfRootHandler;
    
    @Override
    public void service(ServiceManager serviceManager) throws ServiceException
    {
        _odfRootHandler = (OdfPageHandler) serviceManager.lookup(OdfPageHandler.ROLE);
    }
    
    @Override
    public I18nizableText getEntry(String value) throws Exception
    {
        Map<String, ModelItem> eligibleAttributesForLevel = _odfRootHandler.getEnumeratedAttributes(ProgramFactory.PROGRAM_CONTENT_TYPE, true);
        
        if (eligibleAttributesForLevel.containsKey(value))
        {
            return eligibleAttributesForLevel.get(value).getLabel();
        }
        
        return null;
    }

    @Override
    public Map<String, I18nizableText> getTypedEntries() throws Exception
    {
        Map<String, ModelItem> eligibleAttributesForLevel = _odfRootHandler.getEnumeratedAttributes(ProgramFactory.PROGRAM_CONTENT_TYPE, true);
        
        Map<String, I18nizableText> entries = new LinkedHashMap<>();
        
        for (String path : eligibleAttributesForLevel.keySet())
        {
            entries.put(path, eligibleAttributesForLevel.get(path).getLabel());
        }
        
        return entries;
    }
}
