/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfweb.observation;

import java.util.Map;

import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;

import org.ametys.cms.ObservationConstants;
import org.ametys.cms.repository.Content;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.Observer;
import org.ametys.odf.observation.OdfObservationConstants;
import org.ametys.odf.skill.ODFSkillsHelper;
import org.ametys.plugins.repository.RepositoryConstants;
import org.ametys.plugins.repository.jcr.JCRAmetysObject;
import org.ametys.web.synchronization.AbstractSynchronizeObserver;


/**
 * {@link Observer} for observing skills display change
 */
public class SkillsDisplayObserver extends AbstractSynchronizeObserver
{
    @Override
    public boolean supports(Event event)
    {
        return event.getId().equals(OdfObservationConstants.ODF_CONTENT_SKILLS_EXCLUSION_CHANGED);
    }

    @Override
    protected void _internalObserve(Event event, Session liveSession) throws RepositoryException
    {
        Map<String, Object> arguments = event.getArguments();
        Content content = (Content) arguments.get(ObservationConstants.ARGS_CONTENT);
        
        if (!(content instanceof JCRAmetysObject))
        {
            return;
        }
        
        Node node = ((JCRAmetysObject) content).getNode();
        
        try
        {
            Node clonedNode = liveSession.getNodeByIdentifier(node.getIdentifier());
            
            String excludedProperty = RepositoryConstants.NAMESPACE_PREFIX_INTERNAL + ":" + ODFSkillsHelper.SKILLS_EXCLUDED_INTERNAL_ATTRIBUTE_NAME;
            clonedNode.setProperty(excludedProperty, node.getProperty(excludedProperty).getValue());
        }
        catch (ItemNotFoundException e)
        {
            // content does not exist in the live workspace
        }
        
        if (liveSession.hasPendingChanges())
        {
            liveSession.save();
        }
    }
}
