/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfweb.service.search;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;

import org.ametys.cms.repository.Content;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.web.frontoffice.search.requesttime.SearchComponent;
import org.ametys.web.frontoffice.search.requesttime.SearchComponentArguments;

/**
 * This {@link SearchComponent} sax the skill search field
 */
public class SaxSkillSearchComponent extends AbstractSkillSearchComponent implements Serviceable
{
    private AmetysObjectResolver _resolver;
    
    public void service(ServiceManager smanager) throws ServiceException
    {
        _resolver = (AmetysObjectResolver) smanager.lookup(AmetysObjectResolver.ROLE);
    }
    
    public int priority()
    {
        return SEARCH_PRIORITY + 3000;
    }
    
    @Override
    public boolean supports(SearchComponentArguments args)
    {
        return args.launchSearch() && super.supports(args);
    }
    
    public void execute(SearchComponentArguments args) throws Exception
    {
        String skillId = _getSkillId(args.request());
        if (StringUtils.isNotBlank(skillId))
        {
            Content skill = _resolver.resolveById(skillId);
            
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("id", skillId);
            XMLUtils.createElement(args.contentHandler(), "skill", attrs, skill.getTitle());
        }
    }
}
