/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.odfweb.service.search;

import org.apache.commons.lang3.StringUtils;

import org.ametys.cms.search.query.StringQuery;
import org.ametys.cms.search.solr.SearcherFactory.Searcher;
import org.ametys.odf.skill.ProgramSkillsProperty;
import org.ametys.web.frontoffice.search.requesttime.SearchComponent;
import org.ametys.web.frontoffice.search.requesttime.SearchComponentArguments;

/**
 * This {@link SearchComponent} add a query on acquired skill's id if present
 */
public class SkillSearchComponent extends AbstractSkillSearchComponent
{
    
    public int priority()
    {
        return SEARCH_PRIORITY - 9000;
    }
    
    public void execute(SearchComponentArguments args) throws Exception
    {
        Searcher searcher = args.searcher();
        
        String skillId = _getSkillId(args.request());
        if (StringUtils.isNotBlank(skillId))
        {
            searcher.addFilterQuery(new StringQuery(ProgramSkillsProperty.PROGRAM_SKILLS_PROPERTY_NAME, skillId));
        }
    }
}
