/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfweb;

import java.net.URI;
import org.ametys.cms.repository.Content;
import org.ametys.core.util.URIUtils;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.course.Course;
import org.ametys.odf.program.AbstractProgram;
import org.ametys.odf.program.Program;
import org.ametys.odf.program.SubProgram;
import org.ametys.plugins.odfweb.repository.OdfPageHandler;
import org.ametys.plugins.odfweb.repository.OdfPageResolver;
import org.ametys.plugins.odfweb.repository.ProgramPage;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.runtime.config.Config;
import org.ametys.web.URIPrefixHandler;
import org.ametys.web.renderingcontext.RenderingContext;
import org.ametys.web.renderingcontext.RenderingContextHandler;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.site.SiteManager;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;

public class OdfURIResolver
extends org.ametys.odf.OdfURIResolver
implements Contextualizable {
    private Context _context;
    private SiteManager _siteManager;
    private OdfPageResolver _odfPageResolver;
    private RenderingContextHandler _renderingContextHandler;
    private URIPrefixHandler _prefixHandler;
    private OdfPageHandler _odfPageHandler;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._odfPageResolver = (OdfPageResolver)((Object)manager.lookup(OdfPageResolver.ROLE));
        this._odfPageHandler = (OdfPageHandler)((Object)manager.lookup(OdfPageHandler.ROLE));
        this._renderingContextHandler = (RenderingContextHandler)manager.lookup(RenderingContextHandler.ROLE);
        this._prefixHandler = (URIPrefixHandler)manager.lookup(URIPrefixHandler.ROLE);
        this._siteManager = (SiteManager)manager.lookup(SiteManager.ROLE);
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public String resolve(String uri, boolean download, boolean absolute, boolean internal) {
        Request request = ContextHelper.getRequest((Context)this._context);
        String currentSite = (String)request.getAttribute("finalsite");
        if (currentSite == null) {
            currentSite = (String)request.getAttribute("site");
        }
        if (currentSite == null) {
            currentSite = (String)request.getAttribute("siteName");
        }
        int i = uri.indexOf(59);
        String contentId = uri;
        if (i != -1) {
            contentId = uri.substring(0, i);
        }
        Content content = (Content)this._resolver.resolveById(contentId);
        Page odfRootPage = this._odfPageResolver.getOdfRootPage(currentSite, content.getLanguage(), ((ProgramItem)content).getCatalog());
        RenderingContext context = this._renderingContextHandler.getRenderingContext();
        ProgramPage page = null;
        String pagePath = null;
        if (content instanceof Program) {
            page = this._odfPageResolver.getProgramPage((Program)content, currentSite);
        } else if (content instanceof SubProgram) {
            page = this._getSubProgramPage((SubProgram)content, odfRootPage, uri.split(";"));
        } else if (content instanceof Course) {
            page = this._getCoursePage((Course)content, odfRootPage, uri.split(";"));
        }
        if (page == null) {
            String siteName = (String)Config.getInstance().getValue("odf.web.site.name");
            return this._getContentURI(content, siteName, context, absolute, internal);
        }
        String siteName = page.getSiteName();
        pagePath = page.getSitemapName() + "/" + page.getPathInSitemap() + ".html";
        try {
            if (!siteName.equals(currentSite) && context == RenderingContext.FRONT) {
                String url = this._siteManager.getSite(siteName).getUrl();
                return url + "/" + page.getSitemapName() + "/" + page.getPathInSitemap() + ".html";
            }
            if (context != RenderingContext.BACK) {
                StringBuilder result = new StringBuilder();
                if (internal) {
                    result.append("cocoon://").append(siteName);
                } else if (absolute) {
                    result.append(this._prefixHandler.getAbsoluteUriPrefix(siteName));
                } else {
                    result.append(this._prefixHandler.getUriPrefix(siteName));
                }
                result.append("/").append(pagePath);
                return URIUtils.encodePath((String)result.toString());
            }
            return "javascript:(function(){parent.Ametys.tool.ToolsManager.openTool('uitool-page', {id:'" + page.getId() + "'});})()";
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private Page _getSubProgramPage(SubProgram subProgram, Page odfRootPage, String[] paths) {
        if (odfRootPage == null) {
            return null;
        }
        int index = paths.length - 1;
        if (paths.length > 2) {
            AmetysObject lastParent = this._resolver.resolveById(paths[index]);
            Program rootProgram = null;
            rootProgram = lastParent instanceof Program ? (Program)lastParent : this._odfPageResolver.getParentProgram((ProgramItem)lastParent, null);
            if (rootProgram == null) {
                return null;
            }
            Object pagePath = this._odfPageResolver.getPathInProgram((ProgramItem)lastParent, null);
            --index;
            while (index > 0) {
                ProgramItem parentItem = (ProgramItem)this._resolver.resolveById(paths[index]);
                if (!(parentItem instanceof AbstractProgram)) continue;
                pagePath = (String)pagePath + "/" + this._odfPageHandler.getPageName(parentItem);
                --index;
            }
            return (Page)this._resolver.resolveById("program://" + (String)pagePath + "?rootId=" + odfRootPage.getId() + "&programId=" + subProgram.getId() + "&parentId=" + rootProgram.getId());
        }
        if (paths.length == 2) {
            AmetysObject parent = this._resolver.resolveById(paths[index]);
            if (parent instanceof AbstractProgram) {
                return this._odfPageResolver.getSubProgramPage(odfRootPage, subProgram, (AbstractProgram)parent);
            }
        } else {
            return this._odfPageResolver.getSubProgramPage(odfRootPage, subProgram, null);
        }
        return null;
    }

    private Page _getCoursePage(Course course, Page odfRootPage, String[] paths) {
        if (odfRootPage == null) {
            return null;
        }
        int index = paths.length - 1;
        if (paths.length > 2) {
            AmetysObject lastParent = this._resolver.resolveById(paths[index]);
            Program rootProgram = null;
            rootProgram = lastParent instanceof Program ? (Program)lastParent : this._odfPageResolver.getParentProgram((ProgramItem)lastParent, null);
            if (rootProgram == null) {
                return null;
            }
            Object pagePath = this._odfPageResolver.getPathInProgram((ProgramItem)lastParent, null);
            --index;
            while (index > 0) {
                ProgramItem parentItem = (ProgramItem)this._resolver.resolveById(paths[index]);
                if (!(parentItem instanceof AbstractProgram) && !(parentItem instanceof Course)) continue;
                pagePath = (String)pagePath + "/" + this._odfPageHandler.getPageName(parentItem);
                --index;
            }
            return (Page)this._resolver.resolveById("course://" + (String)pagePath + "?rootId=" + odfRootPage.getId() + "&courseId=" + course.getId() + "&programId=" + rootProgram.getId());
        }
        if (paths.length == 2) {
            AmetysObject parent = this._resolver.resolveById(paths[index]);
            if (parent instanceof AbstractProgram) {
                return this._odfPageResolver.getCoursePage(odfRootPage, course, (AbstractProgram)parent);
            }
            if (parent instanceof Course) {
                return this._odfPageResolver.getCoursePage(odfRootPage, course, (Course)parent);
            }
        } else {
            return this._odfPageResolver.getCoursePage(odfRootPage, course, (AbstractProgram)null);
        }
        return null;
    }

    protected String _getContentURI(Content content, String siteName, RenderingContext context, boolean absolute, boolean internal) {
        try {
            if (context == RenderingContext.FRONT) {
                return "";
            }
            if (context != RenderingContext.BACK) {
                StringBuilder result = new StringBuilder();
                if (internal) {
                    result.append("cocoon://").append(siteName);
                } else if (absolute) {
                    result.append(this._prefixHandler.getAbsoluteUriPrefix());
                } else {
                    result.append(this._prefixHandler.getUriPrefix());
                }
                result.append("/").append("_wrapped-content.html");
                String query = "contentId=" + content.getId() + "&userLocale=" + content.getLanguage() + "&siteName=" + siteName;
                return new URI(null, null, result.toString(), query, null).toASCIIString();
            }
            return "javascript:(function(){parent.Ametys.tool.ToolsManager.openTool('uitool-content', {id:'" + content.getId() + "'});})()";
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

