/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfweb.observation;

import java.util.Map;
import org.ametys.cms.repository.Content;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.Observer;
import org.ametys.odf.orgunit.OrgUnit;
import org.ametys.odf.program.Program;
import org.ametys.plugins.odfweb.repository.FirstLevelPageFactory;
import org.ametys.plugins.odfweb.repository.ODFPageCache;
import org.ametys.plugins.odfweb.repository.OdfPageHandler;
import org.ametys.plugins.odfweb.repository.OdfPageResolver;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.provider.RequestAttributeWorkspaceSelector;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.VirtualFactoryExpression;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.PageQueryHelper;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;
import org.ametys.web.repository.sitemap.Sitemap;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;

public class ClearODFPageCacheObserver
extends AbstractLogEnabled
implements Observer,
Serviceable,
Contextualizable {
    protected OdfPageHandler _odfPageHandler;
    protected ODFPageCache _odfPageCache;
    protected SiteManager _siteManager;
    protected OdfPageResolver _odfPageResolver;
    protected AmetysObjectResolver _resolver;
    protected Context _context;

    public void service(ServiceManager manager) throws ServiceException {
        this._odfPageHandler = (OdfPageHandler)((Object)manager.lookup(OdfPageHandler.ROLE));
        this._odfPageCache = (ODFPageCache)((Object)manager.lookup(ODFPageCache.ROLE));
        this._siteManager = (SiteManager)manager.lookup(SiteManager.ROLE);
        this._odfPageResolver = (OdfPageResolver)((Object)manager.lookup(OdfPageResolver.ROLE));
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public boolean supports(Event event) {
        Content content = (Content)event.getArguments().get("content");
        return event.getId().equals("page.changed") || event.getId().equals("site.updated") || event.getId().equals("content.modified") && content instanceof OrgUnit || event.getId().equals("content.validated") && (content instanceof OrgUnit || content instanceof Program);
    }

    public int getPriority(Event event) {
        return 1100;
    }

    public void observe(Event event, Map<String, Object> transientVars) throws Exception {
        Content targetContent = (Content)event.getArguments().get("content");
        Page targetPage = (Page)event.getArguments().get("page");
        Site targetSite = (Site)event.getArguments().get("site");
        if (targetPage != null) {
            this._clearCache(targetPage);
        } else if (targetContent instanceof Program) {
            this._clearCache((Program)targetContent);
        } else if (targetContent instanceof OrgUnit) {
            this._clearCache((OrgUnit)targetContent);
        } else if (targetSite != null) {
            this._clearCache(targetSite);
        }
    }

    protected void _clearCache(Page page) {
        if (this._odfPageHandler.isODFRootPage(page)) {
            this._odfPageCache.clearCache(page);
        }
    }

    protected void _clearCache(Program program) {
        AmetysObjectIterable<Page> rootPages = this._getOdfRootPages();
        for (Page rootPage : rootPages) {
            this._odfPageCache.clearCache(rootPage);
        }
    }

    private AmetysObjectIterable<Page> _getOdfRootPages() {
        VirtualFactoryExpression expression = new VirtualFactoryExpression(FirstLevelPageFactory.class.getName());
        String query = PageQueryHelper.getPageXPathQuery(null, null, null, (Expression)expression, null);
        return this._resolver.query(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _clearCache(OrgUnit orgUnit) {
        Request request = ContextHelper.getRequest((Context)this._context);
        String currentWsp = RequestAttributeWorkspaceSelector.getForcedWorkspace((Request)request);
        try {
            RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)"live");
            for (Site site : this._siteManager.getSites()) {
                if (!this._odfPageHandler.hasOdfRootPage(site)) continue;
                AmetysObjectIterable sitemaps = site.getSitemaps();
                try {
                    for (Sitemap sitemap : sitemaps) {
                        for (Page page : this._odfPageHandler.getOdfRootPages(sitemap.getSiteName(), sitemap.getSitemapName())) {
                            this._odfPageCache.clearCache(page);
                        }
                    }
                }
                finally {
                    if (sitemaps == null) continue;
                    sitemaps.close();
                }
            }
        }
        finally {
            RequestAttributeWorkspaceSelector.setForcedWorkspace((Request)request, (String)currentWsp);
        }
    }

    protected void _clearCache(Site site) {
        String siteName = site.getName();
        for (Sitemap sitemap : site.getSitemaps()) {
            for (Page odfRootPage : this._odfPageHandler.getOdfRootPages(siteName, sitemap.getSitemapName())) {
                this._odfPageCache.clearCache(odfRootPage);
            }
        }
    }
}

