/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfweb.observation.solr;

import java.util.Map;
import java.util.Set;
import org.ametys.cms.content.indexing.solr.observation.ObserverHelper;
import org.ametys.cms.indexing.IndexingObserver;
import org.ametys.core.observation.Event;
import org.ametys.odf.course.Course;
import org.ametys.odf.program.Program;
import org.ametys.odf.program.SubProgram;
import org.ametys.plugins.odfweb.observation.AbstractODFObserver;
import org.ametys.plugins.odfweb.repository.OdfPageResolver;
import org.ametys.web.indexing.solr.SolrPageIndexer;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.sitemap.Sitemap;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractSolrODFObserver
extends AbstractODFObserver
implements IndexingObserver {
    public static final String REQUEST_ATTRIBUTE_INDEXING = "odfweb.solr.indexing";
    protected SolrPageIndexer _solrPageIndexer;
    protected OdfPageResolver _odfPageResolver;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._solrPageIndexer = (SolrPageIndexer)manager.lookup(SolrPageIndexer.ROLE);
        this._odfPageResolver = (OdfPageResolver)((Object)manager.lookup(OdfPageResolver.ROLE));
    }

    public int getPriority(Event event) {
        return 3000;
    }

    @Override
    protected final void _internalObserve(Event event, Map<String, Object> transientVars, Page odfRootPage, Set<Program> programs, SubProgram subProgram, Course course) throws Exception {
        if (ObserverHelper.isNotSuspendedObservationForIndexation()) {
            Request request = ContextHelper.getRequest((Context)this._context);
            request.setAttribute(REQUEST_ATTRIBUTE_INDEXING, (Object)true);
            Sitemap sitemap = odfRootPage.getSitemap();
            String sitemapName = sitemap.getSitemapName();
            for (Program program : programs) {
                if (!StringUtils.equals((String)sitemapName, (String)program.getLanguage())) continue;
                this._updateIndex(event, transientVars, odfRootPage, program, subProgram, course);
            }
        }
    }

    protected abstract void _updateIndex(Event var1, Map<String, Object> var2, Page var3, Program var4, SubProgram var5, Course var6) throws Exception;
}

