/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfweb.observation.solr;

import java.util.Map;
import org.ametys.core.observation.Event;
import org.ametys.odf.course.Course;
import org.ametys.odf.program.Program;
import org.ametys.odf.program.SubProgram;
import org.ametys.plugins.odfweb.observation.solr.AbstractSolrODFObserver;
import org.ametys.plugins.odfweb.repository.ProgramPage;
import org.ametys.web.repository.page.Page;

public class UnindexProgramObserver
extends AbstractSolrODFObserver {
    public boolean supports(Event event) {
        return (event.getId().equals("content.deleting") || event.getId().equals("content.untag.live")) && event.getArguments().get("content") instanceof Program;
    }

    @Override
    public int getPriority(Event event) {
        return 0;
    }

    @Override
    protected void _updateIndex(Event event, Map<String, Object> transientVars, Page odfRootPage, Program program, SubProgram subProgram, Course course) throws Exception {
        ProgramPage programPage = this._odfPageResolver.getProgramPage(odfRootPage, program);
        if (programPage != null) {
            String pageId = programPage.getId();
            this.getLogger().info("Updating Solr document with id: {}", (Object)pageId);
            if (event.getId().equals("content.deleting")) {
                this._solrPageIndexer.unindexPage(pageId, "default", true, true);
            }
            this._solrPageIndexer.unindexPage(pageId, "live", true, true);
        }
    }
}

