/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfweb.repository;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.ametys.odf.program.AbstractProgram;
import org.ametys.odf.program.Program;
import org.ametys.odf.tree.OdfClassificationHandler;
import org.ametys.plugins.odfweb.repository.AbstractOdfPageFactory;
import org.ametys.plugins.odfweb.repository.FirstLevelPage;
import org.ametys.plugins.odfweb.repository.ProgramPage;
import org.ametys.plugins.odfweb.repository.ProgramPageFactory;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.CollectionIterable;
import org.ametys.plugins.repository.EmptyIterable;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.repository.jcr.JCRAmetysObject;
import org.ametys.plugins.repository.virtual.VirtualAmetysObjectFactory;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.virtual.VirtualPageConfiguration;
import org.apache.commons.lang3.StringUtils;

public class FirstLevelPageFactory
extends AbstractOdfPageFactory
implements VirtualAmetysObjectFactory<Page> {
    public String getScheme() {
        return "odfLevel1";
    }

    public Page getAmetysObjectById(String id) throws AmetysRepositoryException {
        String childName = this._extractChildName(id);
        Page rootPage = this._extractRoot(id);
        return (Page)this._findFirstLevelValueEntry(rootPage, childName).map(entry -> this._toFirstLevelPage(rootPage, (Map.Entry<String, OdfClassificationHandler.LevelValue>)entry)).orElseThrow(() -> new UnknownAmetysObjectException("There's no virtual child page named " + childName + " for parent " + rootPage));
    }

    private Page _extractRoot(String id) {
        String rootId = StringUtils.substringAfter((String)id, (String)"?rootId=");
        return (Page)this._resolver.resolveById(rootId);
    }

    private String _extractChildName(String id) {
        String rawChildName = StringUtils.substringBetween((String)id, (String)"://", (String)"?");
        return this._odfPageHandler.decodeLevelValue(rawChildName);
    }

    private Optional<Map.Entry<String, OdfClassificationHandler.LevelValue>> _findFirstLevelValueEntry(Page rootPage, String levelCode) {
        Map<String, OdfClassificationHandler.LevelValue> firstLevelValues = this._odfPageHandler.getLevel1Values(rootPage);
        return this._findFirstLevelValueEntry(firstLevelValues, levelCode);
    }

    private Optional<Map.Entry<String, OdfClassificationHandler.LevelValue>> _findFirstLevelValueEntry(Map<String, OdfClassificationHandler.LevelValue> firstLevelValues, String levelCode) {
        return firstLevelValues.entrySet().stream().filter(entry -> ((String)entry.getKey()).equals(levelCode)).findFirst();
    }

    private FirstLevelPage _toFirstLevelPage(Page rootPage, Map.Entry<String, OdfClassificationHandler.LevelValue> firstLevelValueEntry) throws AmetysRepositoryException {
        String childName = firstLevelValueEntry.getKey();
        String title = firstLevelValueEntry.getValue().getValue();
        VirtualPageConfiguration configuration = this.getConfiguration();
        return new FirstLevelPage(rootPage, configuration, this, childName, title);
    }

    private ProgramPage _toProgramPage(Program program, Page root) {
        ProgramPageFactory programPageFactory = this.getProgramPageFactory();
        return new ProgramPage(root, programPageFactory.getConfiguration(), programPageFactory, (AbstractProgram)program, null, null, root);
    }

    public boolean hasAmetysObjectForId(String id) throws AmetysRepositoryException {
        String childName = this._extractChildName(id);
        Page rootPage = this._extractRoot(id);
        return this._hasFirstLevelValue(rootPage, childName);
    }

    public Page getChild(JCRAmetysObject parent, String childName) {
        if (!(parent instanceof Page)) {
            throw new IllegalArgumentException("The holder of the ODF virtual pages should be a page.");
        }
        Page rootPage = (Page)parent;
        String level1Metadata = this._odfPageHandler.getLevel1Metadata(rootPage);
        if (StringUtils.isBlank((CharSequence)level1Metadata)) {
            return this._pageCache.getChildProgramPage(rootPage, rootPage, null, null, childName);
        }
        Map<String, OdfClassificationHandler.LevelValue> firstLevelValues = this._odfPageHandler.getLevel1Values(rootPage);
        int i = childName.lastIndexOf("-");
        String code = i != -1 ? this._odfPageHandler.decodeLevelValue(childName.substring(i + 1)) : this._odfPageHandler.decodeLevelValue(childName);
        return Optional.of(code).map(firstLevelValues::get).map(OdfClassificationHandler.LevelValue::getValue).map(title -> new FirstLevelPage(rootPage, this.getConfiguration(), this, code, (String)title)).map(page -> this._odfPageHandler.addRedirectIfNeeded((Page)page, childName)).orElseThrow(() -> new UnknownAmetysObjectException("There's no virtual child page named " + childName + " for parent " + parent));
    }

    public AmetysObjectIterable<Page> getChildren(JCRAmetysObject parent) {
        if (!(parent instanceof Page)) {
            throw new IllegalArgumentException("The holder of the ODF virtual pages should be a page.");
        }
        Page rootPage = (Page)parent;
        String level1Metadata = this._odfPageHandler.getLevel1Metadata(rootPage);
        if (StringUtils.isBlank((CharSequence)level1Metadata)) {
            List pages = this._pageCache.getPrograms(rootPage, null, null, true).orElseGet(() -> new EmptyIterable()).stream().map(p -> this._toProgramPage((Program)p, rootPage)).collect(Collectors.toList());
            return new CollectionIterable(pages);
        }
        Map<String, OdfClassificationHandler.LevelValue> firstLevelValues = this._odfPageHandler.getLevel1Values(rootPage);
        Map<String, Map<String, Collection<Program>>> firstLevelCache = this._pageCache.getProgramCache(rootPage, true);
        List children = firstLevelCache.keySet().stream().map(firstLevelCode -> this._findFirstLevelValueEntry(firstLevelValues, (String)firstLevelCode).orElse(null)).filter(Objects::nonNull).map(entry -> this._toFirstLevelPage(rootPage, (Map.Entry<String, OdfClassificationHandler.LevelValue>)entry)).collect(Collectors.toList());
        return new CollectionIterable(children);
    }

    public boolean hasChild(JCRAmetysObject parent, String childName) {
        if (!(parent instanceof Page)) {
            throw new IllegalArgumentException("The holder of the ODF virtual pages should be a page.");
        }
        Page rootPage = (Page)parent;
        String level1Metadata = this._odfPageHandler.getLevel1Metadata(rootPage);
        if (StringUtils.isBlank((CharSequence)level1Metadata)) {
            Optional<Program> program = this._pageCache.getProgramFromPageName(rootPage, null, null, childName);
            return program.isPresent();
        }
        return this._hasFirstLevelValue(rootPage, childName);
    }

    private boolean _hasFirstLevelValue(Page rootPage, String level1Code) throws AmetysRepositoryException {
        Map<String, OdfClassificationHandler.LevelValue> firstLevelValues = this._odfPageHandler.getLevel1Values(rootPage);
        return firstLevelValues.containsKey(level1Code);
    }
}

