/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfweb.restrictions.rules;

import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import org.ametys.odf.program.Program;
import org.ametys.plugins.odfweb.restrictions.rules.OdfRestrictionRule;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.ametys.runtime.model.type.ElementType;

public class OdfMetadataRestrictionRule
implements OdfRestrictionRule {
    private final String _metadataPath;
    private final String _untypedValue;

    public OdfMetadataRestrictionRule(String metadataPath, String untypedValue) {
        this._metadataPath = metadataPath;
        this._untypedValue = untypedValue;
    }

    @Override
    public Expression getExpression() {
        return new StringExpression(this._metadataPath, Expression.Operator.EQ, this._untypedValue);
    }

    @Override
    public boolean contains(Program program) {
        ElementType type = (ElementType)program.getDefinition(this._metadataPath).getType();
        Object typedValue = type.castValue((Object)this._untypedValue);
        return Optional.ofNullable(program.getValue(this._metadataPath)).map(value -> Arrays.asList(value)).orElse(Collections.EMPTY_LIST).stream().anyMatch(value -> value.equals(typedValue));
    }

    @Override
    public boolean hasOrgunitRestrictions() {
        return false;
    }
}

