/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfweb.rights;

import org.ametys.core.cache.Cache;
import org.ametys.core.user.UserIdentity;
import org.ametys.odf.ODFHelper;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.program.AbstractProgram;
import org.ametys.odf.program.Container;
import org.ametys.plugins.core.impl.cache.AbstractCacheKey;
import org.ametys.plugins.odfweb.repository.OdfPageHandler;
import org.ametys.plugins.odfweb.repository.OdfPageResolver;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.WebHelper;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang3.StringUtils;

public class ODFRoleAccessControllerHelper
extends org.ametys.odf.rights.ODFRoleAccessControllerHelper
implements Contextualizable {
    private static final String __CACHE_BY_SITE_ID = ODFRoleAccessControllerHelper.class.getName() + "$cacheBySite";
    private SiteManager _siteManager;
    private OdfPageHandler _odfPageHandler;
    private OdfPageResolver _odfPageResolver;
    private ODFHelper _odfHelper;
    private Context _context;

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._siteManager = (SiteManager)smanager.lookup(SiteManager.ROLE);
        this._odfPageHandler = (OdfPageHandler)((Object)smanager.lookup(OdfPageHandler.ROLE));
        this._odfPageResolver = (OdfPageResolver)((Object)smanager.lookup(OdfPageResolver.ROLE));
        this._odfHelper = (ODFHelper)smanager.lookup(ODFHelper.ROLE);
    }

    public void initialize() throws Exception {
        if (!this._cacheManager.hasCache(__CACHE_BY_SITE_ID)) {
            this._cacheManager.createRequestCache(__CACHE_BY_SITE_ID, new I18nizableText("plugin.odf-web", "PLUGINS_ODF_WEB_CACHE_ROLE_ACCESS_CONTROLLER_LABEL"), new I18nizableText("plugin.odf-web", "PLUGINS_ODF_WEB_CACHE_ROLE_ACCESS_CONTROLLER_DESCRIPTION"), false);
        }
    }

    public boolean hasODFRoleOnAnyProgramItem(UserIdentity user, String attributePath) {
        Cache<CacheKey, Boolean> cache = this._getCacheBySite();
        Request request = ContextHelper.getRequest((Context)this._context);
        String siteName = WebHelper.getSiteName((Request)request);
        CacheKey key = CacheKey.of(user, siteName, attributePath);
        return (Boolean)cache.get((Object)key, __ -> this._hasODFRoleOnAnyProgramItem(user, siteName, attributePath));
    }

    private boolean _hasODFRoleOnAnyProgramItem(UserIdentity user, String siteName, String attributePath) {
        AmetysObjectIterable programItems = this._odfRightHelper.getProgramItemsWithUserAsRole(user, attributePath);
        if (programItems.getSize() == 0L) {
            return false;
        }
        if (StringUtils.isNotBlank((CharSequence)siteName)) {
            Site site = this._siteManager.getSite(siteName);
            String odfMainSite = (String)Config.getInstance().getValue("odf.web.site.name");
            if (siteName.equals(odfMainSite)) {
                return true;
            }
            if (this._odfPageHandler.hasOdfRootPage(site)) {
                for (ProgramItem programItem : programItems) {
                    if (programItem instanceof Container) {
                        for (AbstractProgram abstractProgram : this._odfHelper.getParentAbstractPrograms(programItem)) {
                            if (this._odfPageResolver.getReferencingPages((ProgramItem)abstractProgram, siteName, null).isEmpty()) continue;
                            return true;
                        }
                        continue;
                    }
                    if (this._odfPageResolver.getReferencingPages(programItem, siteName, null).isEmpty()) continue;
                    return true;
                }
                return false;
            }
            return false;
        }
        return true;
    }

    private Cache<CacheKey, Boolean> _getCacheBySite() {
        return this._cacheManager.get(__CACHE_BY_SITE_ID);
    }

    static class CacheKey
    extends AbstractCacheKey {
        CacheKey(UserIdentity userIdentity, String siteName, String roleAttributePath) {
            super(new Object[]{userIdentity, siteName, roleAttributePath});
        }

        static CacheKey of(UserIdentity userIdentity, String siteName, String roleAttributePath) {
            return new CacheKey(userIdentity, siteName, roleAttributePath);
        }
    }
}

