/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfweb.service.search;

import java.time.ZonedDateTime;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Predicate;
import org.ametys.cms.repository.Content;
import org.ametys.core.util.DateUtils;
import org.ametys.odf.ProgramItem;
import org.ametys.odf.course.Course;
import org.ametys.odf.data.EducationalPath;
import org.ametys.odf.program.AbstractProgram;
import org.ametys.plugins.odfweb.repository.CoursePage;
import org.ametys.plugins.odfweb.service.search.CourseReturnable;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.web.frontoffice.search.metamodel.impl.PageReturnable;
import org.ametys.web.frontoffice.search.metamodel.impl.PageSaxer;
import org.ametys.web.frontoffice.search.requesttime.SearchComponentArguments;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.site.Site;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.slf4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class CourseSaxer
extends PageSaxer {
    private CourseReturnable _courseReturnable;

    public CourseSaxer(PageReturnable pageReturnable, CourseReturnable courseReturnable) {
        super(pageReturnable);
        this._courseReturnable = courseReturnable;
    }

    public boolean canSax(AmetysObject hit, Logger logger, SearchComponentArguments args) {
        return hit instanceof Course;
    }

    public void sax(ContentHandler contentHandler, AmetysObject hit, Logger logger, SearchComponentArguments args) throws SAXException {
        Course course = (Course)hit;
        this._saxCourseContent(contentHandler, course, logger, args);
        Optional<CoursePage> coursePage = this._resolveCoursePage(course, args.currentSite());
        if (coursePage.isPresent()) {
            Page page = (Page)coursePage.get();
            XMLUtils.createElement((ContentHandler)contentHandler, (String)"uri", (String)(page.getSitemap().getName() + "/" + page.getPathInSitemap()));
        }
        this._saxCoursePages(contentHandler, course);
    }

    private Optional<CoursePage> _resolveCoursePage(Course course, Site currentSite) {
        return Optional.of(this._courseReturnable._odfPageResolver).map(res -> res.getCoursePage(course, (AbstractProgram)null, currentSite.getName()));
    }

    private void _saxCourseContent(ContentHandler contentHandler, Course course, Logger logger, SearchComponentArguments args) throws SAXException {
        XMLUtils.createElement((ContentHandler)contentHandler, (String)"title", (String)course.getTitle());
        ZonedDateTime lastValidationDate = course.getLastValidationDate();
        if (lastValidationDate != null) {
            XMLUtils.createElement((ContentHandler)contentHandler, (String)"lastValidation", (String)DateUtils.zonedDateTimeToString((ZonedDateTime)lastValidationDate));
        }
        Locale locale = new Locale(args.currentPage().getSitemapName());
        this.saxContent((Content)course, "index", locale, contentHandler, logger);
    }

    private void _saxCoursePages(ContentHandler contentHandler, Course course) throws SAXException {
        List educationalPaths = this._courseReturnable._odfHelper.getEducationalPaths((ProgramItem)course, true, true);
        Predicate<ProgramItem> filter = p -> p instanceof AbstractProgram || p instanceof Course;
        for (EducationalPath path : educationalPaths) {
            String uri = this._courseReturnable._odfHelper.getEducationalPathAsString(path, AmetysObject::getId, (CharSequence)";", filter);
            XMLUtils.startElement((ContentHandler)contentHandler, (String)"coursePage");
            XMLUtils.createElement((ContentHandler)contentHandler, (String)"uri", (String)uri);
            String resolvedUri = this._courseReturnable._odfURIResolver.resolve(uri, false, false, false);
            XMLUtils.createElement((ContentHandler)contentHandler, (String)"resolvedUri", (String)resolvedUri);
            List<ProgramItem> programItems = path.resolveProgramItems(this._courseReturnable._resolver).filter(filter).toList();
            this._saxCoursePath(contentHandler, programItems);
            XMLUtils.endElement((ContentHandler)contentHandler, (String)"coursePage");
        }
    }

    private void _saxCoursePath(ContentHandler contentHandler, List<ProgramItem> programItems) throws SAXException {
        XMLUtils.startElement((ContentHandler)contentHandler, (String)"path");
        for (ProgramItem item : programItems) {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("id", ((Content)item).getId());
            XMLUtils.createElement((ContentHandler)contentHandler, (String)"element", (Attributes)attrs, (String)((Content)item).getTitle());
        }
        XMLUtils.endElement((ContentHandler)contentHandler, (String)"path");
    }
}

