/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfweb.service.search;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.ametys.cms.search.SearchResults;
import org.ametys.plugins.odfweb.service.search.helper.DegreeUniversityHelper;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.web.frontoffice.search.instance.SearchServiceInstance;
import org.ametys.web.frontoffice.search.instance.model.FOSearchCriterion;
import org.ametys.web.frontoffice.search.metamodel.FacetDefinition;
import org.ametys.web.frontoffice.search.requesttime.SearchComponentArguments;
import org.ametys.web.frontoffice.search.requesttime.impl.SaxEnumeratedCriteriaComponent;
import org.ametys.web.frontoffice.search.requesttime.impl.SearchComponentHelper;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class SaxDegreeUniversityEnumeratedCriteriaComponent
extends SaxEnumeratedCriteriaComponent {
    protected DegreeUniversityHelper _degreeUniversityHelper;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._degreeUniversityHelper = (DegreeUniversityHelper)((Object)manager.lookup(DegreeUniversityHelper.ROLE));
    }

    public int priority() {
        return super.priority() + 1;
    }

    public void execute(SearchComponentArguments args) throws Exception {
        Optional enumeratedResults = args.enumeratedResults();
        if (enumeratedResults.isPresent()) {
            ContentHandler contentHandler = args.contentHandler();
            XMLUtils.startElement((ContentHandler)contentHandler, (String)"enumerated-criteria");
            Map contextualParameters = SearchComponentHelper.getSearchComponentContextualParameters((SearchComponentArguments)args);
            Map<FacetDefinition, FOSearchCriterion> serviceFacets = this._getFacetDefinitions(args.serviceInstance());
            this._saxCountEnumeratedCriteria(contentHandler, args.generatorParameters(), serviceFacets, (SearchResults)enumeratedResults.get(), contextualParameters);
            XMLUtils.endElement((ContentHandler)contentHandler, (String)"enumerated-criteria");
        } else {
            super.execute(args);
        }
    }

    protected Map<FacetDefinition, FOSearchCriterion> _getFacetDefinitions(SearchServiceInstance serviceInstance) {
        return super._getFacetDefinitions(serviceInstance).entrySet().stream().filter(entry -> ((FacetDefinition)entry.getKey()).getId().equals("ContentReturnable$ProgramSearchable$indexingField$org.ametys.plugins.odf.Content.program$degree$University")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    protected void _saxFacetItemsWithCount(ContentHandler contentHandler, FacetDefinition facet, Map<String, Integer> valuesForCurrentFacetDef, Map<String, Object> contextualParameters) throws SAXException {
        List dUIds = this._degreeUniversityHelper.getDegrees(true).stream().map(AmetysObject::getId).collect(Collectors.toList());
        int allCount = 0;
        for (String value : valuesForCurrentFacetDef.keySet()) {
            if (!dUIds.contains(value)) continue;
            allCount += valuesForCurrentFacetDef.get(value).intValue();
        }
        Map<String, Integer> valuesForAllDU = Map.of("_Ametys_Degree_All_University", allCount);
        super._saxFacetItemsWithCount(contentHandler, facet, valuesForAllDU, contextualParameters);
    }
}

