<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2019 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
    xmlns:xalan="http://xml.apache.org/xalan"
    xmlns:exsl="http://exslt.org/common"
    xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
    xmlns:ametys="org.ametys.cms.transformation.xslt.AmetysXSLTHelper"
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
    exclude-result-prefixes="i18n xalan resolver exsl">
    
    <xsl:import href="plugin:odf://pages/properties/view.xsl"/>
    <xsl:import href="plugin:web://pages/properties/view.xsl"/>

    <xsl:template match="/view">
        <xml>
            <xsl:call-template name="card"/>
            
            <xsl:call-template name="content-metadata"/>
            <xsl:call-template name="content-tags"/>
            
            <xsl:choose>
                <xsl:when test="odf/programItem">
                    <xsl:call-template name="program-item-paths"/>
                    <xsl:call-template name="program-item-children"/>
                    <xsl:call-template name="other-referencing-contents"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:call-template name="referencing-contents"/>
                    
                    <xsl:call-template name="content-pages"/>
                    <xsl:call-template name="initial-content"/>
                    <xsl:call-template name="content-shares"/>
                </xsl:otherwise>
            </xsl:choose>
        </xml>
    </xsl:template>
    
</xsl:stylesheet>