/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfweb.cart;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.cms.repository.Content;
import org.ametys.plugins.odfweb.cart.ODFCartManager;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class CartDownloadGenerator
extends ServiceableGenerator {
    private ODFCartManager _cartManager;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._cartManager = (ODFCartManager)((Object)smanager.lookup(ODFCartManager.ROLE));
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String[] itemIds = request.getParameterValues("itemId");
        String siteName = request.getParameter("siteName");
        StringBuilder sb = new StringBuilder();
        sb.append("cocoon:/").append(siteName).append("/_content/");
        String downloadUriPrefix = sb.toString();
        this.contentHandler.startDocument();
        this.contentHandler.startPrefixMapping("zip", "http://apache.org/cocoon/zip-archive/1.0");
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"http://apache.org/cocoon/zip-archive/1.0", (String)"archive");
        Set contents = Arrays.stream(itemIds).map(i -> this._cartManager.getCartItem((String)i)).filter(Objects::nonNull).map(item -> item.getContent()).collect(Collectors.toSet());
        for (Content content : contents) {
            String contentName = content.getName();
            AttributesImpl zipAttrs = new AttributesImpl();
            zipAttrs.addAttribute("", "name", "name", "CDATA", content.getTitle() + ".pdf");
            zipAttrs.addAttribute("", "src", "src", "CDATA", downloadUriPrefix + contentName + ".pdf");
            XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"http://apache.org/cocoon/zip-archive/1.0", (String)"entry", (Attributes)zipAttrs);
            XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"http://apache.org/cocoon/zip-archive/1.0", (String)"entry");
        }
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"http://apache.org/cocoon/zip-archive/1.0", (String)"archive");
        this.contentHandler.endPrefixMapping("zip");
        this.contentHandler.endDocument();
    }
}

