/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.odfweb.cart;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.ametys.core.datasource.ConnectionHelper;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.userpref.UserPreferencesException;
import org.ametys.core.userpref.UserPreferencesStorage;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.commons.lang.StringUtils;

public class ODFCartUserPreferencesStorage
extends AbstractLogEnabled
implements UserPreferencesStorage,
Configurable,
Component {
    public static final String ROLE = ODFCartUserPreferencesStorage.class.getName();
    protected String _dataSourceId;
    protected String _loginColumn;
    protected String _populationColumn;
    protected String _contextColumn;
    protected String _contentIdColumn;
    protected Map<String, String> _prefIdToTable;

    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration dataSourceConf = configuration.getChild("datasource", false);
        if (dataSourceConf == null) {
            throw new ConfigurationException("The 'datasource' configuration node must be defined.", dataSourceConf);
        }
        String dataSourceConfParam = dataSourceConf.getValue();
        String dataSourceConfType = dataSourceConf.getAttribute("type", "config");
        this._dataSourceId = StringUtils.equals((String)dataSourceConfType, (String)"config") ? (String)Config.getInstance().getValue(dataSourceConfParam) : dataSourceConfParam;
        this._contentIdColumn = configuration.getChild("content-id").getValue("contentId");
        this._loginColumn = configuration.getChild("loginColumn").getValue("login").toLowerCase();
        this._populationColumn = configuration.getChild("populationColumn").getValue("population").toLowerCase();
        this._contextColumn = configuration.getChild("contextColumn").getValue("context");
        this.configureMappings(configuration.getChild("mappings"));
    }

    public void configureMappings(Configuration configuration) throws ConfigurationException {
        this._prefIdToTable = new HashMap<String, String>();
        for (Configuration mappingConf : configuration.getChildren("mapping")) {
            String prefId = mappingConf.getAttribute("prefId");
            String table = mappingConf.getAttribute("table");
            this._prefIdToTable.put(prefId, table);
        }
    }

    public Map<String, String> getUnTypedUserPrefs(UserIdentity user, String storageContext, Map<String, String> contextVars) throws UserPreferencesException {
        HashMap<String, String> prefs = new HashMap<String, String>();
        for (String id : this._prefIdToTable.keySet()) {
            prefs.put(id, this.getUserPreferenceAsString(user, storageContext, contextVars, id));
        }
        return prefs;
    }

    public void removeUserPreferences(Collection<String> prefIds, UserIdentity user, String storageContext, Map<String, String> contextVars) throws UserPreferencesException {
        Connection connection = null;
        try {
            connection = ConnectionHelper.getConnection((String)this._dataSourceId);
            for (String id : prefIds) {
                this._removeUserPreferencesFromTable(connection, user, storageContext, this._prefIdToTable.get(id));
            }
        }
        catch (SQLException e) {
            String message = "Database error trying to remove ODF cart preferences for user '" + String.valueOf(user) + "' in context '" + storageContext + "'.";
            this.getLogger().error(message, (Throwable)e);
            throw new UserPreferencesException(message, (Throwable)e);
        }
        finally {
            ConnectionHelper.cleanup((Connection)connection);
        }
    }

    public void removeUserPreferences(UserIdentity user, String storageContext, Map<String, String> contextVars) throws UserPreferencesException {
        Connection connection = null;
        try {
            connection = ConnectionHelper.getConnection((String)this._dataSourceId);
            for (String id : this._prefIdToTable.keySet()) {
                this._removeUserPreferencesFromTable(connection, user, storageContext, this._prefIdToTable.get(id));
            }
        }
        catch (SQLException e) {
            String message = "Database error trying to remove ODF cart preferences for user '" + String.valueOf(user) + "' in context '" + storageContext + "'.";
            this.getLogger().error(message, (Throwable)e);
            throw new UserPreferencesException(message, (Throwable)e);
        }
        finally {
            ConnectionHelper.cleanup((Connection)connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _removeUserPreferencesFromTable(Connection connection, UserIdentity user, String storageContext, String table) throws SQLException {
        PreparedStatement stmt = null;
        try {
            StringBuilder query = new StringBuilder();
            query.append("DELETE FROM ").append(table).append(" WHERE ").append(this._loginColumn).append(" = ? AND ").append(this._populationColumn).append(" = ?");
            if (storageContext != null) {
                query.append(" AND ").append(this._contextColumn).append(" = ?");
            }
            stmt = connection.prepareStatement(query.toString());
            stmt.setString(1, user.getLogin());
            stmt.setString(2, user.getPopulationId());
            if (storageContext != null) {
                stmt.setString(3, storageContext);
            }
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            ConnectionHelper.cleanup(stmt);
            throw throwable;
        }
        ConnectionHelper.cleanup((Statement)stmt);
    }

    public void removeContentFromUserPreferences(String contentId) throws UserPreferencesException {
        Connection connection = null;
        PreparedStatement stmt = null;
        try {
            connection = ConnectionHelper.getConnection((String)this._dataSourceId);
            StringBuilder query = new StringBuilder();
            query.append("DELETE FROM ").append(this._prefIdToTable.get("cartOdfContentIds")).append(" WHERE ").append(this._contentIdColumn).append(" like ?");
            stmt = connection.prepareStatement(query.toString());
            stmt.setString(1, contentId + "%");
            stmt.executeUpdate();
            ConnectionHelper.cleanup((Statement)stmt);
            query = new StringBuilder();
            query.append("DELETE FROM ").append(this._prefIdToTable.get("subscriptionOdfContentIds")).append(" WHERE ").append(this._contentIdColumn).append(" like ?");
            stmt = connection.prepareStatement(query.toString());
            stmt.setString(1, contentId + "%");
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                String message = "Database error trying to remove ODF content of id '" + contentId + "' from all user's preferences";
                this.getLogger().error(message, (Throwable)e);
                throw new UserPreferencesException(message, (Throwable)e);
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanup(stmt);
                ConnectionHelper.cleanup((Connection)connection);
                throw throwable;
            }
        }
        ConnectionHelper.cleanup((Statement)stmt);
        ConnectionHelper.cleanup((Connection)connection);
    }

    public void setUserPreferences(UserIdentity user, String storageContext, Map<String, String> contextVars, Map<String, String> preferences) throws UserPreferencesException {
        this.removeUserPreferences(preferences.keySet(), user, storageContext, contextVars);
        Connection connection = null;
        try {
            connection = ConnectionHelper.getConnection((String)this._dataSourceId);
            this._insertPreferences(connection, preferences, user, storageContext);
        }
        catch (SQLException e) {
            String message = "Database error trying to set ODF cart preferences of user '" + String.valueOf(user) + "' in context '" + storageContext + "'.";
            this.getLogger().error(message, (Throwable)e);
            throw new UserPreferencesException(message, (Throwable)e);
        }
        finally {
            ConnectionHelper.cleanup((Connection)connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _insertPreferences(Connection connection, Map<String, String> preferences, UserIdentity user, String storageContext) throws SQLException {
        for (String id : preferences.keySet()) {
            String table = this._prefIdToTable.get(id);
            String[] contentIdsTab = StringUtils.split((String)preferences.get(id), (String)",");
            if (contentIdsTab.length <= 0) continue;
            PreparedStatement stmt = null;
            try {
                int i;
                StringBuilder query = new StringBuilder();
                query.append("INSERT INTO ").append(table).append("(").append(this._loginColumn).append(", ").append(this._populationColumn);
                query.append(", ").append(this._contextColumn);
                query.append(", ").append(this._contentIdColumn);
                StringBuilder values = new StringBuilder();
                for (i = 0; i < contentIdsTab.length; ++i) {
                    if (i != 0) {
                        values.append(",");
                    }
                    values.append("(?, ?, ?, ?)");
                }
                query.append(") VALUES ").append((CharSequence)values);
                i = 1;
                stmt = connection.prepareStatement(query.toString());
                for (String idContent : contentIdsTab) {
                    stmt.setString(i++, user.getLogin());
                    stmt.setString(i++, user.getPopulationId());
                    stmt.setString(i++, storageContext);
                    stmt.setString(i++, idContent);
                }
                stmt.executeUpdate();
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanup(stmt);
                throw throwable;
            }
            ConnectionHelper.cleanup((Statement)stmt);
        }
    }

    public String getUserPreferenceAsString(UserIdentity user, String storageContext, Map<String, String> contextVars, String id) throws UserPreferencesException {
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        String value = null;
        String table = this._prefIdToTable.get(id);
        try {
            StringBuilder query = new StringBuilder();
            query.append("SELECT ").append(this._contentIdColumn).append(" FROM ").append(table).append(" WHERE ").append(this._loginColumn).append(" = ? AND ").append(this._populationColumn).append(" = ?");
            query.append(" AND ").append(this._contextColumn).append(" = ?");
            connection = ConnectionHelper.getConnection((String)this._dataSourceId);
            statement = connection.prepareStatement(query.toString());
            statement.setString(1, user.getLogin());
            statement.setString(2, user.getPopulationId());
            statement.setString(3, storageContext);
            rs = statement.executeQuery();
            ArrayList<String> results = new ArrayList<String>();
            while (rs.next()) {
                results.add(rs.getString(1));
            }
            value = StringUtils.join(results, (String)",");
        }
        catch (SQLException e) {
            try {
                String message = "Database error trying to get ODF cart preferences of user '" + String.valueOf(user) + "' in context '" + storageContext + "'.";
                this.getLogger().error(message, (Throwable)e);
                throw new UserPreferencesException(message, (Throwable)e);
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanup(rs);
                ConnectionHelper.cleanup(statement);
                ConnectionHelper.cleanup(connection);
                throw throwable;
            }
        }
        ConnectionHelper.cleanup((ResultSet)rs);
        ConnectionHelper.cleanup((Statement)statement);
        ConnectionHelper.cleanup((Connection)connection);
        return value;
    }

    public Long getUserPreferenceAsLong(UserIdentity user, String storageContext, Map<String, String> contextVars, String id) throws UserPreferencesException {
        return null;
    }

    public ZonedDateTime getUserPreferenceAsDate(UserIdentity user, String storageContext, Map<String, String> contextVars, String id) throws UserPreferencesException {
        return null;
    }

    public Boolean getUserPreferenceAsBoolean(UserIdentity user, String storageContext, Map<String, String> contextVars, String id) throws UserPreferencesException {
        return null;
    }

    public Double getUserPreferenceAsDouble(UserIdentity user, String storageContext, Map<String, String> contextVars, String id) throws UserPreferencesException {
        return null;
    }
}

